// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewDeleteRoleParams creates a new DeleteRoleParams object
// with the default values initialized.
func NewDeleteRoleParams() *DeleteRoleParams {
	var ()
	return &DeleteRoleParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteRoleParamsWithTimeout creates a new DeleteRoleParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewDeleteRoleParamsWithTimeout(timeout time.Duration) *DeleteRoleParams {
	var ()
	return &DeleteRoleParams{

		timeout: timeout,
	}
}

// NewDeleteRoleParamsWithContext creates a new DeleteRoleParams object
// with the default values initialized, and the ability to set a context for a request
func NewDeleteRoleParamsWithContext(ctx context.Context) *DeleteRoleParams {
	var ()
	return &DeleteRoleParams{

		Context: ctx,
	}
}

// NewDeleteRoleParamsWithHTTPClient creates a new DeleteRoleParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewDeleteRoleParamsWithHTTPClient(client *http.Client) *DeleteRoleParams {
	var ()
	return &DeleteRoleParams{
		HTTPClient: client,
	}
}

/*DeleteRoleParams contains all the parameters to send to the API endpoint
for the delete role operation typically these are written to a http.Request
*/
type DeleteRoleParams struct {

	/*RoleID
	  Id of the role to delete

	*/
	RoleID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the delete role params
func (o *DeleteRoleParams) WithTimeout(timeout time.Duration) *DeleteRoleParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete role params
func (o *DeleteRoleParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete role params
func (o *DeleteRoleParams) WithContext(ctx context.Context) *DeleteRoleParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete role params
func (o *DeleteRoleParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete role params
func (o *DeleteRoleParams) WithHTTPClient(client *http.Client) *DeleteRoleParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete role params
func (o *DeleteRoleParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithRoleID adds the roleID to the delete role params
func (o *DeleteRoleParams) WithRoleID(roleID string) *DeleteRoleParams {
	o.SetRoleID(roleID)
	return o
}

// SetRoleID adds the roleId to the delete role params
func (o *DeleteRoleParams) SetRoleID(roleID string) {
	o.RoleID = roleID
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteRoleParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param roleId
	if err := r.SetPathParam("roleId", o.RoleID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
