// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/swag"

	strfmt "github.com/go-openapi/strfmt"
)

// NewGetPeopleParams creates a new GetPeopleParams object
// with the default values initialized.
func NewGetPeopleParams() *GetPeopleParams {
	var (
		listDefault = bool(true)
	)
	return &GetPeopleParams{
		List: &listDefault,

		timeout: cr.DefaultTimeout,
	}
}

// NewGetPeopleParamsWithTimeout creates a new GetPeopleParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewGetPeopleParamsWithTimeout(timeout time.Duration) *GetPeopleParams {
	var (
		listDefault = bool(true)
	)
	return &GetPeopleParams{
		List: &listDefault,

		timeout: timeout,
	}
}

// NewGetPeopleParamsWithContext creates a new GetPeopleParams object
// with the default values initialized, and the ability to set a context for a request
func NewGetPeopleParamsWithContext(ctx context.Context) *GetPeopleParams {
	var (
		listDefault = bool(true)
	)
	return &GetPeopleParams{
		List: &listDefault,

		Context: ctx,
	}
}

// NewGetPeopleParamsWithHTTPClient creates a new GetPeopleParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewGetPeopleParamsWithHTTPClient(client *http.Client) *GetPeopleParams {
	var (
		listDefault = bool(true)
	)
	return &GetPeopleParams{
		List:       &listDefault,
		HTTPClient: client,
	}
}

/*GetPeopleParams contains all the parameters to send to the API endpoint
for the get people operation typically these are written to a http.Request
*/
type GetPeopleParams struct {

	/*Format
	  Format produced in output (defaults to xml)

	*/
	Format *string
	/*List
	  list children of the current resource

	*/
	List *bool
	/*Path
	  User or group identifier, including full group path (optional)

	*/
	Path string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the get people params
func (o *GetPeopleParams) WithTimeout(timeout time.Duration) *GetPeopleParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get people params
func (o *GetPeopleParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get people params
func (o *GetPeopleParams) WithContext(ctx context.Context) *GetPeopleParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get people params
func (o *GetPeopleParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get people params
func (o *GetPeopleParams) WithHTTPClient(client *http.Client) *GetPeopleParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get people params
func (o *GetPeopleParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFormat adds the format to the get people params
func (o *GetPeopleParams) WithFormat(format *string) *GetPeopleParams {
	o.SetFormat(format)
	return o
}

// SetFormat adds the format to the get people params
func (o *GetPeopleParams) SetFormat(format *string) {
	o.Format = format
}

// WithList adds the list to the get people params
func (o *GetPeopleParams) WithList(list *bool) *GetPeopleParams {
	o.SetList(list)
	return o
}

// SetList adds the list to the get people params
func (o *GetPeopleParams) SetList(list *bool) {
	o.List = list
}

// WithPath adds the path to the get people params
func (o *GetPeopleParams) WithPath(path string) *GetPeopleParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the get people params
func (o *GetPeopleParams) SetPath(path string) {
	o.Path = path
}

// WriteToRequest writes these params to a swagger request
func (o *GetPeopleParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Format != nil {

		// query param format
		var qrFormat string
		if o.Format != nil {
			qrFormat = *o.Format
		}
		qFormat := qrFormat
		if qFormat != "" {
			if err := r.SetQueryParam("format", qFormat); err != nil {
				return err
			}
		}

	}

	if o.List != nil {

		// query param list
		var qrList bool
		if o.List != nil {
			qrList = *o.List
		}
		qList := swag.FormatBool(qrList)
		if qList != "" {
			if err := r.SetQueryParam("list", qList); err != nil {
				return err
			}
		}

	}

	// path param path
	if err := r.SetPathParam("path", o.Path); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
