// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/pydio/pydio-sdk-go/models"
)

// NewPatchPeopleParams creates a new PatchPeopleParams object
// with the default values initialized.
func NewPatchPeopleParams() *PatchPeopleParams {
	var ()
	return &PatchPeopleParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewPatchPeopleParamsWithTimeout creates a new PatchPeopleParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewPatchPeopleParamsWithTimeout(timeout time.Duration) *PatchPeopleParams {
	var ()
	return &PatchPeopleParams{

		timeout: timeout,
	}
}

// NewPatchPeopleParamsWithContext creates a new PatchPeopleParams object
// with the default values initialized, and the ability to set a context for a request
func NewPatchPeopleParamsWithContext(ctx context.Context) *PatchPeopleParams {
	var ()
	return &PatchPeopleParams{

		Context: ctx,
	}
}

// NewPatchPeopleParamsWithHTTPClient creates a new PatchPeopleParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewPatchPeopleParamsWithHTTPClient(client *http.Client) *PatchPeopleParams {
	var ()
	return &PatchPeopleParams{
		HTTPClient: client,
	}
}

/*PatchPeopleParams contains all the parameters to send to the API endpoint
for the patch people operation typically these are written to a http.Request
*/
type PatchPeopleParams struct {

	/*Format
	  Format produced in output (defaults to xml)

	*/
	Format *string
	/*PatchTuple
	  parameterName / parameterValue association

	*/
	PatchTuple *models.PeoplePatch
	/*Path
	  User or group identifier, including full group path

	*/
	Path string
	/*ResourceType
	  Wether it's a user or a group

	*/
	ResourceType string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the patch people params
func (o *PatchPeopleParams) WithTimeout(timeout time.Duration) *PatchPeopleParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the patch people params
func (o *PatchPeopleParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the patch people params
func (o *PatchPeopleParams) WithContext(ctx context.Context) *PatchPeopleParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the patch people params
func (o *PatchPeopleParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the patch people params
func (o *PatchPeopleParams) WithHTTPClient(client *http.Client) *PatchPeopleParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the patch people params
func (o *PatchPeopleParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFormat adds the format to the patch people params
func (o *PatchPeopleParams) WithFormat(format *string) *PatchPeopleParams {
	o.SetFormat(format)
	return o
}

// SetFormat adds the format to the patch people params
func (o *PatchPeopleParams) SetFormat(format *string) {
	o.Format = format
}

// WithPatchTuple adds the patchTuple to the patch people params
func (o *PatchPeopleParams) WithPatchTuple(patchTuple *models.PeoplePatch) *PatchPeopleParams {
	o.SetPatchTuple(patchTuple)
	return o
}

// SetPatchTuple adds the patchTuple to the patch people params
func (o *PatchPeopleParams) SetPatchTuple(patchTuple *models.PeoplePatch) {
	o.PatchTuple = patchTuple
}

// WithPath adds the path to the patch people params
func (o *PatchPeopleParams) WithPath(path string) *PatchPeopleParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the patch people params
func (o *PatchPeopleParams) SetPath(path string) {
	o.Path = path
}

// WithResourceType adds the resourceType to the patch people params
func (o *PatchPeopleParams) WithResourceType(resourceType string) *PatchPeopleParams {
	o.SetResourceType(resourceType)
	return o
}

// SetResourceType adds the resourceType to the patch people params
func (o *PatchPeopleParams) SetResourceType(resourceType string) {
	o.ResourceType = resourceType
}

// WriteToRequest writes these params to a swagger request
func (o *PatchPeopleParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Format != nil {

		// query param format
		var qrFormat string
		if o.Format != nil {
			qrFormat = *o.Format
		}
		qFormat := qrFormat
		if qFormat != "" {
			if err := r.SetQueryParam("format", qFormat); err != nil {
				return err
			}
		}

	}

	if o.PatchTuple != nil {
		if err := r.SetBodyParam(o.PatchTuple); err != nil {
			return err
		}
	}

	// path param path
	if err := r.SetPathParam("path", o.Path); err != nil {
		return err
	}

	// query param resourceType
	qrResourceType := o.ResourceType
	qResourceType := qrResourceType
	if qResourceType != "" {
		if err := r.SetQueryParam("resourceType", qResourceType); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
