// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"
)

// New creates a new provisioning API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) *Client {
	return &Client{transport: transport, formats: formats}
}

/*
Client for provisioning API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

/*
AdminAddWorkspaceFeature Add a metasource

*/
func (a *Client) AdminAddWorkspaceFeature(params *AdminAddWorkspaceFeatureParams, authInfo runtime.ClientAuthInfoWriter) (*AdminAddWorkspaceFeatureOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAdminAddWorkspaceFeatureParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "adminAddWorkspaceFeature",
		Method:             "POST",
		PathPattern:        "/admin/workspaces/{workspaceId}/features/{metaId}",
		ProducesMediaTypes: []string{"application/json", "application/xml"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AdminAddWorkspaceFeatureReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*AdminAddWorkspaceFeatureOK), nil

}

/*
AdminCreateWorkspace Create a workspace from scratch by posting JSON data

*/
func (a *Client) AdminCreateWorkspace(params *AdminCreateWorkspaceParams, authInfo runtime.ClientAuthInfoWriter) (*AdminCreateWorkspaceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAdminCreateWorkspaceParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "adminCreateWorkspace",
		Method:             "POST",
		PathPattern:        "/admin/workspaces",
		ProducesMediaTypes: []string{"application/json", "application/xml"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AdminCreateWorkspaceReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*AdminCreateWorkspaceOK), nil

}

/*
AdminDeleteWorkspace Load detail of a workspace

*/
func (a *Client) AdminDeleteWorkspace(params *AdminDeleteWorkspaceParams, authInfo runtime.ClientAuthInfoWriter) (*AdminDeleteWorkspaceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAdminDeleteWorkspaceParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "adminDeleteWorkspace",
		Method:             "DELETE",
		PathPattern:        "/admin/workspaces/{workspaceId}",
		ProducesMediaTypes: []string{"application/json", "application/xml"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AdminDeleteWorkspaceReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*AdminDeleteWorkspaceOK), nil

}

/*
AdminEditWorkspace NOT IMPLEMENTED YET - Edit details of a workspace

*/
func (a *Client) AdminEditWorkspace(params *AdminEditWorkspaceParams, authInfo runtime.ClientAuthInfoWriter) (*AdminEditWorkspaceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAdminEditWorkspaceParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "adminEditWorkspace",
		Method:             "PATCH",
		PathPattern:        "/admin/workspaces/{workspaceId}",
		ProducesMediaTypes: []string{"application/json", "application/xml"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AdminEditWorkspaceReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*AdminEditWorkspaceOK), nil

}

/*
AdminEditWorkspaceFeature Edit a metasource

*/
func (a *Client) AdminEditWorkspaceFeature(params *AdminEditWorkspaceFeatureParams, authInfo runtime.ClientAuthInfoWriter) (*AdminEditWorkspaceFeatureOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAdminEditWorkspaceFeatureParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "adminEditWorkspaceFeature",
		Method:             "PATCH",
		PathPattern:        "/admin/workspaces/{workspaceId}/features/{metaId}",
		ProducesMediaTypes: []string{"application/json", "application/xml"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AdminEditWorkspaceFeatureReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*AdminEditWorkspaceFeatureOK), nil

}

/*
AdminGetWorkspace Load detail of a workspace

*/
func (a *Client) AdminGetWorkspace(params *AdminGetWorkspaceParams, authInfo runtime.ClientAuthInfoWriter) (*AdminGetWorkspaceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAdminGetWorkspaceParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "adminGetWorkspace",
		Method:             "GET",
		PathPattern:        "/admin/workspaces/{workspaceId}",
		ProducesMediaTypes: []string{"application/json", "application/xml"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AdminGetWorkspaceReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*AdminGetWorkspaceOK), nil

}

/*
AdminListWorkspaces List Workspaces

*/
func (a *Client) AdminListWorkspaces(params *AdminListWorkspacesParams, authInfo runtime.ClientAuthInfoWriter) (*AdminListWorkspacesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAdminListWorkspacesParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "adminListWorkspaces",
		Method:             "GET",
		PathPattern:        "/admin/workspaces",
		ProducesMediaTypes: []string{"application/json", "application/xml"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AdminListWorkspacesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*AdminListWorkspacesOK), nil

}

/*
AdminLoadShareList Get list of share on workspace
*/
func (a *Client) AdminLoadShareList(params *AdminLoadShareListParams, authInfo runtime.ClientAuthInfoWriter) (*AdminLoadShareListOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAdminLoadShareListParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "adminLoadShareList",
		Method:             "GET",
		PathPattern:        "/admin/workspaces/{workspaceId}/sharelist-load",
		ProducesMediaTypes: []string{"application/json", "application/xml"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AdminLoadShareListReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*AdminLoadShareListOK), nil

}

/*
AdminLoadSharedElementData Get detail of share
*/
func (a *Client) AdminLoadSharedElementData(params *AdminLoadSharedElementDataParams, authInfo runtime.ClientAuthInfoWriter) (*AdminLoadSharedElementDataOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAdminLoadSharedElementDataParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "adminLoadSharedElementData",
		Method:             "POST",
		PathPattern:        "/admin/workspaces/{workspaceId}/load-shared-element-data/{file}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AdminLoadSharedElementDataReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*AdminLoadSharedElementDataOK), nil

}

/*
AdminRemoveWorkspaceFeature Edit a metasource

*/
func (a *Client) AdminRemoveWorkspaceFeature(params *AdminRemoveWorkspaceFeatureParams, authInfo runtime.ClientAuthInfoWriter) (*AdminRemoveWorkspaceFeatureOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAdminRemoveWorkspaceFeatureParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "adminRemoveWorkspaceFeature",
		Method:             "DELETE",
		PathPattern:        "/admin/workspaces/{workspaceId}/features/{metaId}",
		ProducesMediaTypes: []string{"application/json", "application/xml"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AdminRemoveWorkspaceFeatureReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*AdminRemoveWorkspaceFeatureOK), nil

}

/*
AdminUpdateWorkspace Update a workspace by posting JSON data

*/
func (a *Client) AdminUpdateWorkspace(params *AdminUpdateWorkspaceParams, authInfo runtime.ClientAuthInfoWriter) (*AdminUpdateWorkspaceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAdminUpdateWorkspaceParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "adminUpdateWorkspace",
		Method:             "PATCH",
		PathPattern:        "/admin/workspaces",
		ProducesMediaTypes: []string{"application/json", "application/xml"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AdminUpdateWorkspaceReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*AdminUpdateWorkspaceOK), nil

}

/*
CreatePeople Create a new user or a new group with this path. To create a user,  make sure to pass a userPass parameter. Otherwise it will create a  group.

*/
func (a *Client) CreatePeople(params *CreatePeopleParams, authInfo runtime.ClientAuthInfoWriter) (*CreatePeopleOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreatePeopleParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "createPeople",
		Method:             "POST",
		PathPattern:        "/admin/people/{path}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreatePeopleReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*CreatePeopleOK), nil

}

/*
CreateRole Create a new role with this ID

*/
func (a *Client) CreateRole(params *CreateRoleParams, authInfo runtime.ClientAuthInfoWriter) (*CreateRoleOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateRoleParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "createRole",
		Method:             "POST",
		PathPattern:        "/admin/roles/{roleId}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateRoleReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*CreateRoleOK), nil

}

/*
DeletePeople Delete Role by Id

*/
func (a *Client) DeletePeople(params *DeletePeopleParams, authInfo runtime.ClientAuthInfoWriter) (*DeletePeopleOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeletePeopleParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "deletePeople",
		Method:             "DELETE",
		PathPattern:        "/admin/people/{path}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeletePeopleReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DeletePeopleOK), nil

}

/*
DeleteRole Delete Role by Id

*/
func (a *Client) DeleteRole(params *DeleteRoleParams, authInfo runtime.ClientAuthInfoWriter) (*DeleteRoleOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteRoleParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "deleteRole",
		Method:             "DELETE",
		PathPattern:        "/admin/roles/{roleId}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteRoleReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DeleteRoleOK), nil

}

/*
GetPeople List roles

*/
func (a *Client) GetPeople(params *GetPeopleParams, authInfo runtime.ClientAuthInfoWriter) (*GetPeopleOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetPeopleParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "getPeople",
		Method:             "GET",
		PathPattern:        "/admin/people/{path}",
		ProducesMediaTypes: []string{"application/json", "application/xml"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetPeopleReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetPeopleOK), nil

}

/*
GetRole Get Role by Id

*/
func (a *Client) GetRole(params *GetRoleParams, authInfo runtime.ClientAuthInfoWriter) (*GetRoleOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRoleParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "getRole",
		Method:             "GET",
		PathPattern:        "/admin/roles/{roleId}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetRoleReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetRoleOK), nil

}

/*
GetRoles List roles

*/
func (a *Client) GetRoles(params *GetRolesParams, authInfo runtime.ClientAuthInfoWriter) (*GetRolesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRolesParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "getRoles",
		Method:             "GET",
		PathPattern:        "/admin/roles",
		ProducesMediaTypes: []string{"application/json", "application/xml"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetRolesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetRolesOK), nil

}

/*
PatchPeople Update user or group specific data with this path. Use resourceType parameter to discriminate, and send a parameterName/parameterValue couple to be patched.

Authorized parameterName values are described below, along with the parameterValue corresponding specification:
- For groups
  - groupLabel : relabel an existing group
- For users
  - userPass: change user password
  - userProfile: update user profile
  - userLock: set/remove a lock on a user. Value must be a lockname:lockvalue string where lockvalue is "true" or "fale".
  - userRoles: Bunch update roles, eventually reorder them, as a JSON encoded array.
  - userAddRole: add a role to the user
  - userRemoveRole: remove a role currently applied to the user.
  - userPreferences: a JSON associative array of key/values to update.

To edit user/group permissions or parameters, use the role api instead,  using the object specific role_id (AJXP_GRP_/groupPath or AJXP_USR_/userId).

*/
func (a *Client) PatchPeople(params *PatchPeopleParams, authInfo runtime.ClientAuthInfoWriter) (*PatchPeopleOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPatchPeopleParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "patchPeople",
		Method:             "PATCH",
		PathPattern:        "/admin/people/{path}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PatchPeopleReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*PatchPeopleOK), nil

}

/*
UpdateRole Update the role

*/
func (a *Client) UpdateRole(params *UpdateRoleParams, authInfo runtime.ClientAuthInfoWriter) (*UpdateRoleOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateRoleParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "updateRole",
		Method:             "PATCH",
		PathPattern:        "/admin/roles/{roleId}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateRoleReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateRoleOK), nil

}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
