// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/pydio/pydio-sdk-go/models"
)

// NewUpdateRoleParams creates a new UpdateRoleParams object
// with the default values initialized.
func NewUpdateRoleParams() *UpdateRoleParams {
	var ()
	return &UpdateRoleParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateRoleParamsWithTimeout creates a new UpdateRoleParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewUpdateRoleParamsWithTimeout(timeout time.Duration) *UpdateRoleParams {
	var ()
	return &UpdateRoleParams{

		timeout: timeout,
	}
}

// NewUpdateRoleParamsWithContext creates a new UpdateRoleParams object
// with the default values initialized, and the ability to set a context for a request
func NewUpdateRoleParamsWithContext(ctx context.Context) *UpdateRoleParams {
	var ()
	return &UpdateRoleParams{

		Context: ctx,
	}
}

// NewUpdateRoleParamsWithHTTPClient creates a new UpdateRoleParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewUpdateRoleParamsWithHTTPClient(client *http.Client) *UpdateRoleParams {
	var ()
	return &UpdateRoleParams{
		HTTPClient: client,
	}
}

/*UpdateRoleParams contains all the parameters to send to the API endpoint
for the update role operation typically these are written to a http.Request
*/
type UpdateRoleParams struct {

	/*Role
	  JSON description of the new role

	*/
	Role *models.Role
	/*RoleID
	  Id of the role to load

	*/
	RoleID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the update role params
func (o *UpdateRoleParams) WithTimeout(timeout time.Duration) *UpdateRoleParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update role params
func (o *UpdateRoleParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update role params
func (o *UpdateRoleParams) WithContext(ctx context.Context) *UpdateRoleParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update role params
func (o *UpdateRoleParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update role params
func (o *UpdateRoleParams) WithHTTPClient(client *http.Client) *UpdateRoleParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update role params
func (o *UpdateRoleParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithRole adds the role to the update role params
func (o *UpdateRoleParams) WithRole(role *models.Role) *UpdateRoleParams {
	o.SetRole(role)
	return o
}

// SetRole adds the role to the update role params
func (o *UpdateRoleParams) SetRole(role *models.Role) {
	o.Role = role
}

// WithRoleID adds the roleID to the update role params
func (o *UpdateRoleParams) WithRoleID(roleID string) *UpdateRoleParams {
	o.SetRoleID(roleID)
	return o
}

// SetRoleID adds the roleId to the update role params
func (o *UpdateRoleParams) SetRoleID(roleID string) {
	o.RoleID = roleID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateRoleParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Role != nil {
		if err := r.SetBodyParam(o.Role); err != nil {
			return err
		}
	}

	// path param roleId
	if err := r.SetPathParam("roleId", o.RoleID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
