// Code generated by go-swagger; DO NOT EDIT.

package task

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewDeleteTaskParams creates a new DeleteTaskParams object
// with the default values initialized.
func NewDeleteTaskParams() *DeleteTaskParams {
	var ()
	return &DeleteTaskParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteTaskParamsWithTimeout creates a new DeleteTaskParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewDeleteTaskParamsWithTimeout(timeout time.Duration) *DeleteTaskParams {
	var ()
	return &DeleteTaskParams{

		timeout: timeout,
	}
}

// NewDeleteTaskParamsWithContext creates a new DeleteTaskParams object
// with the default values initialized, and the ability to set a context for a request
func NewDeleteTaskParamsWithContext(ctx context.Context) *DeleteTaskParams {
	var ()
	return &DeleteTaskParams{

		Context: ctx,
	}
}

// NewDeleteTaskParamsWithHTTPClient creates a new DeleteTaskParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewDeleteTaskParamsWithHTTPClient(client *http.Client) *DeleteTaskParams {
	var ()
	return &DeleteTaskParams{
		HTTPClient: client,
	}
}

/*DeleteTaskParams contains all the parameters to send to the API endpoint
for the delete task operation typically these are written to a http.Request
*/
type DeleteTaskParams struct {

	/*TaskID
	  Task to delete on the server

	*/
	TaskID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the delete task params
func (o *DeleteTaskParams) WithTimeout(timeout time.Duration) *DeleteTaskParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete task params
func (o *DeleteTaskParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete task params
func (o *DeleteTaskParams) WithContext(ctx context.Context) *DeleteTaskParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete task params
func (o *DeleteTaskParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete task params
func (o *DeleteTaskParams) WithHTTPClient(client *http.Client) *DeleteTaskParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete task params
func (o *DeleteTaskParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithTaskID adds the taskID to the delete task params
func (o *DeleteTaskParams) WithTaskID(taskID string) *DeleteTaskParams {
	o.SetTaskID(taskID)
	return o
}

// SetTaskID adds the taskId to the delete task params
func (o *DeleteTaskParams) SetTaskID(taskID string) {
	o.TaskID = taskID
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteTaskParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param taskId
	if err := r.SetPathParam("taskId", o.TaskID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
