// Code generated by go-swagger; DO NOT EDIT.

package task

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/swag"

	strfmt "github.com/go-openapi/strfmt"
)

// NewListTasksParams creates a new ListTasksParams object
// with the default values initialized.
func NewListTasksParams() *ListTasksParams {
	var ()
	return &ListTasksParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewListTasksParamsWithTimeout creates a new ListTasksParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewListTasksParamsWithTimeout(timeout time.Duration) *ListTasksParams {
	var ()
	return &ListTasksParams{

		timeout: timeout,
	}
}

// NewListTasksParamsWithContext creates a new ListTasksParams object
// with the default values initialized, and the ability to set a context for a request
func NewListTasksParamsWithContext(ctx context.Context) *ListTasksParams {
	var ()
	return &ListTasksParams{

		Context: ctx,
	}
}

// NewListTasksParamsWithHTTPClient creates a new ListTasksParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewListTasksParamsWithHTTPClient(client *http.Client) *ListTasksParams {
	var ()
	return &ListTasksParams{
		HTTPClient: client,
	}
}

/*ListTasksParams contains all the parameters to send to the API endpoint
for the list tasks operation typically these are written to a http.Request
*/
type ListTasksParams struct {

	/*Filter
	  additional filters for task listing (JSON serialized)

	*/
	Filter *string
	/*Path
	  One or more node pathes

	*/
	Path []string
	/*WorkspaceID
	  Id or Alias of the workspace

	*/
	WorkspaceID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the list tasks params
func (o *ListTasksParams) WithTimeout(timeout time.Duration) *ListTasksParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list tasks params
func (o *ListTasksParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list tasks params
func (o *ListTasksParams) WithContext(ctx context.Context) *ListTasksParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list tasks params
func (o *ListTasksParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list tasks params
func (o *ListTasksParams) WithHTTPClient(client *http.Client) *ListTasksParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list tasks params
func (o *ListTasksParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the list tasks params
func (o *ListTasksParams) WithFilter(filter *string) *ListTasksParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the list tasks params
func (o *ListTasksParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithPath adds the path to the list tasks params
func (o *ListTasksParams) WithPath(path []string) *ListTasksParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the list tasks params
func (o *ListTasksParams) SetPath(path []string) {
	o.Path = path
}

// WithWorkspaceID adds the workspaceID to the list tasks params
func (o *ListTasksParams) WithWorkspaceID(workspaceID string) *ListTasksParams {
	o.SetWorkspaceID(workspaceID)
	return o
}

// SetWorkspaceID adds the workspaceId to the list tasks params
func (o *ListTasksParams) SetWorkspaceID(workspaceID string) {
	o.WorkspaceID = workspaceID
}

// WriteToRequest writes these params to a swagger request
func (o *ListTasksParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// form param filter
		var frFilter string
		if o.Filter != nil {
			frFilter = *o.Filter
		}
		fFilter := frFilter
		if fFilter != "" {
			if err := r.SetFormParam("filter", fFilter); err != nil {
				return err
			}
		}

	}

	valuesPath := o.Path

	joinedPath := swag.JoinByFormat(valuesPath, "multi")
	// form array param path
	if err := r.SetFormParam("path", joinedPath...); err != nil {
		return err
	}

	// form param workspaceId
	frWorkspaceID := o.WorkspaceID
	fWorkspaceID := frWorkspaceID
	if fWorkspaceID != "" {
		if err := r.SetFormParam("workspaceId", fWorkspaceID); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
