// Code generated by go-swagger; DO NOT EDIT.

package task

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"
)

// New creates a new task API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) *Client {
	return &Client{transport: transport, formats: formats}
}

/*
Client for task API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

/*
CreateTask Create a task on the server. This will generally trigger a server-side background "Task", which ID will be returned in the PydioResponse['tasks'] array

*/
func (a *Client) CreateTask(params *CreateTaskParams, authInfo runtime.ClientAuthInfoWriter) (*CreateTaskOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateTaskParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "createTask",
		Method:             "POST",
		PathPattern:        "/tasks/{taskId}",
		ProducesMediaTypes: []string{""},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateTaskReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*CreateTaskOK), nil

}

/*
DeleteTask Update a task on the server.

*/
func (a *Client) DeleteTask(params *DeleteTaskParams, authInfo runtime.ClientAuthInfoWriter) (*DeleteTaskOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteTaskParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "deleteTask",
		Method:             "DELETE",
		PathPattern:        "/tasks/{taskId}",
		ProducesMediaTypes: []string{""},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteTaskReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DeleteTaskOK), nil

}

/*
GetTaskInfo Get information about a currently running task Id

*/
func (a *Client) GetTaskInfo(params *GetTaskInfoParams, authInfo runtime.ClientAuthInfoWriter) (*GetTaskInfoOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetTaskInfoParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "getTaskInfo",
		Method:             "GET",
		PathPattern:        "/tasks/{taskId}",
		ProducesMediaTypes: []string{""},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetTaskInfoReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetTaskInfoOK), nil

}

/*
ListTasks List tasks currently running on the server (and visible to the current user).

*/
func (a *Client) ListTasks(params *ListTasksParams, authInfo runtime.ClientAuthInfoWriter) (*ListTasksOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListTasksParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "listTasks",
		Method:             "GET",
		PathPattern:        "/tasks",
		ProducesMediaTypes: []string{""},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListTasksReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ListTasksOK), nil

}

/*
UpdateTask Update a task on the server.

*/
func (a *Client) UpdateTask(params *UpdateTaskParams, authInfo runtime.ClientAuthInfoWriter) (*UpdateTaskOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateTaskParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "updateTask",
		Method:             "PATCH",
		PathPattern:        "/tasks/{taskId}",
		ProducesMediaTypes: []string{""},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateTaskReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateTaskOK), nil

}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
