// Code generated by go-swagger; DO NOT EDIT.

package task

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/pydio/pydio-sdk-go/models"
)

// NewUpdateTaskParams creates a new UpdateTaskParams object
// with the default values initialized.
func NewUpdateTaskParams() *UpdateTaskParams {
	var ()
	return &UpdateTaskParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateTaskParamsWithTimeout creates a new UpdateTaskParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewUpdateTaskParamsWithTimeout(timeout time.Duration) *UpdateTaskParams {
	var ()
	return &UpdateTaskParams{

		timeout: timeout,
	}
}

// NewUpdateTaskParamsWithContext creates a new UpdateTaskParams object
// with the default values initialized, and the ability to set a context for a request
func NewUpdateTaskParamsWithContext(ctx context.Context) *UpdateTaskParams {
	var ()
	return &UpdateTaskParams{

		Context: ctx,
	}
}

// NewUpdateTaskParamsWithHTTPClient creates a new UpdateTaskParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewUpdateTaskParamsWithHTTPClient(client *http.Client) *UpdateTaskParams {
	var ()
	return &UpdateTaskParams{
		HTTPClient: client,
	}
}

/*UpdateTaskParams contains all the parameters to send to the API endpoint
for the update task operation typically these are written to a http.Request
*/
type UpdateTaskParams struct {

	/*RequestBody
	  JSON Diff describing the patches to apply on the task object

	*/
	RequestBody *models.Task
	/*TaskID
	  Task to update on the server

	*/
	TaskID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the update task params
func (o *UpdateTaskParams) WithTimeout(timeout time.Duration) *UpdateTaskParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update task params
func (o *UpdateTaskParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update task params
func (o *UpdateTaskParams) WithContext(ctx context.Context) *UpdateTaskParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update task params
func (o *UpdateTaskParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update task params
func (o *UpdateTaskParams) WithHTTPClient(client *http.Client) *UpdateTaskParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update task params
func (o *UpdateTaskParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithRequestBody adds the requestBody to the update task params
func (o *UpdateTaskParams) WithRequestBody(requestBody *models.Task) *UpdateTaskParams {
	o.SetRequestBody(requestBody)
	return o
}

// SetRequestBody adds the requestBody to the update task params
func (o *UpdateTaskParams) SetRequestBody(requestBody *models.Task) {
	o.RequestBody = requestBody
}

// WithTaskID adds the taskID to the update task params
func (o *UpdateTaskParams) WithTaskID(taskID string) *UpdateTaskParams {
	o.SetTaskID(taskID)
	return o
}

// SetTaskID adds the taskId to the update task params
func (o *UpdateTaskParams) SetTaskID(taskID string) {
	o.TaskID = taskID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateTaskParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.RequestBody != nil {
		if err := r.SetBodyParam(o.RequestBody); err != nil {
			return err
		}
	}

	// path param taskId
	if err := r.SetPathParam("taskId", o.TaskID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
