// Code generated by go-swagger; DO NOT EDIT.

package workspace

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/swag"

	strfmt "github.com/go-openapi/strfmt"
)

// NewChangesParams creates a new ChangesParams object
// with the default values initialized.
func NewChangesParams() *ChangesParams {
	var ()
	return &ChangesParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewChangesParamsWithTimeout creates a new ChangesParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewChangesParamsWithTimeout(timeout time.Duration) *ChangesParams {
	var ()
	return &ChangesParams{

		timeout: timeout,
	}
}

// NewChangesParamsWithContext creates a new ChangesParams object
// with the default values initialized, and the ability to set a context for a request
func NewChangesParamsWithContext(ctx context.Context) *ChangesParams {
	var ()
	return &ChangesParams{

		Context: ctx,
	}
}

// NewChangesParamsWithHTTPClient creates a new ChangesParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewChangesParamsWithHTTPClient(client *http.Client) *ChangesParams {
	var ()
	return &ChangesParams{
		HTTPClient: client,
	}
}

/*ChangesParams contains all the parameters to send to the API endpoint
for the changes operation typically these are written to a http.Request
*/
type ChangesParams struct {

	/*SequenceID
	  File to upload

	*/
	SequenceID int64
	/*WorkspaceID
	  Id or Alias of the workspace

	*/
	WorkspaceID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the changes params
func (o *ChangesParams) WithTimeout(timeout time.Duration) *ChangesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the changes params
func (o *ChangesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the changes params
func (o *ChangesParams) WithContext(ctx context.Context) *ChangesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the changes params
func (o *ChangesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the changes params
func (o *ChangesParams) WithHTTPClient(client *http.Client) *ChangesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the changes params
func (o *ChangesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithSequenceID adds the sequenceID to the changes params
func (o *ChangesParams) WithSequenceID(sequenceID int64) *ChangesParams {
	o.SetSequenceID(sequenceID)
	return o
}

// SetSequenceID adds the sequenceId to the changes params
func (o *ChangesParams) SetSequenceID(sequenceID int64) {
	o.SequenceID = sequenceID
}

// WithWorkspaceID adds the workspaceID to the changes params
func (o *ChangesParams) WithWorkspaceID(workspaceID string) *ChangesParams {
	o.SetWorkspaceID(workspaceID)
	return o
}

// SetWorkspaceID adds the workspaceId to the changes params
func (o *ChangesParams) SetWorkspaceID(workspaceID string) {
	o.WorkspaceID = workspaceID
}

// WriteToRequest writes these params to a swagger request
func (o *ChangesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param sequenceId
	if err := r.SetPathParam("sequenceId", swag.FormatInt64(o.SequenceID)); err != nil {
		return err
	}

	// path param workspaceId
	if err := r.SetPathParam("workspaceId", o.WorkspaceID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
