// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Node Node
//
// A file or folder represented as a generic resource, including metadata and children. Properties before children are part of the "standard" metadat set, properties after are returned by the "extended" metadata set.
// swagger:model Node
type Node struct {

	// ajxp description
	AjxpDescription string `json:"ajxp_description,omitempty"`

	// ajxp modiftime
	AjxpModiftime int64 `json:"ajxp_modiftime,omitempty"`

	// ajxp readonly
	AjxpReadonly bool `json:"ajxp_readonly,omitempty"`

	// ajxp relativetime
	AjxpRelativetime string `json:"ajxp_relativetime,omitempty"`

	// ajxp roles
	AjxpRoles interface{} `json:"ajxp_roles,omitempty"`

	// bytesize
	Bytesize int64 `json:"bytesize,omitempty"`

	// children
	Children *NodeList `json:"children,omitempty"`

	// file perms
	FilePerms string `json:"file_perms,omitempty"`

	// filesize
	Filesize string `json:"filesize,omitempty"`

	// icon
	Icon string `json:"icon,omitempty"`

	// is leaf
	IsLeaf bool `json:"is_leaf,omitempty"`

	// json merged role
	JSONMergedRole *Role `json:"json_merged_role,omitempty"`

	// label
	Label string `json:"label,omitempty"`

	// mimestring id
	MimestringID string `json:"mimestring_id,omitempty"`

	// path
	Path string `json:"path,omitempty"`

	// repo has recycle
	RepoHasRecycle bool `json:"repo_has_recycle,omitempty"`

	// stat
	Stat interface{} `json:"stat,omitempty"`

	// type
	// Enum: [collection leaf]
	Type string `json:"type,omitempty"`
}

// Validate validates this node
func (m *Node) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateChildren(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJSONMergedRole(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Node) validateChildren(formats strfmt.Registry) error {

	if swag.IsZero(m.Children) { // not required
		return nil
	}

	if m.Children != nil {
		if err := m.Children.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("children")
			}
			return err
		}
	}

	return nil
}

func (m *Node) validateJSONMergedRole(formats strfmt.Registry) error {

	if swag.IsZero(m.JSONMergedRole) { // not required
		return nil
	}

	if m.JSONMergedRole != nil {
		if err := m.JSONMergedRole.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("json_merged_role")
			}
			return err
		}
	}

	return nil
}

var nodeTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["collection","leaf"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeTypeTypePropEnum = append(nodeTypeTypePropEnum, v)
	}
}

const (

	// NodeTypeCollection captures enum value "collection"
	NodeTypeCollection string = "collection"

	// NodeTypeLeaf captures enum value "leaf"
	NodeTypeLeaf string = "leaf"
)

// prop value enum
func (m *Node) validateTypeEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, nodeTypeTypePropEnum); err != nil {
		return err
	}
	return nil
}

func (m *Node) validateType(formats strfmt.Registry) error {

	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Node) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Node) UnmarshalBinary(b []byte) error {
	var res Node
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
