package archive

import (
	"github.com/pydio/services/common/proto/jobs"
	. "github.com/smartystreets/goconvey/convey"
	"testing"
)

func TestRpcAction_GetName(t *testing.T) {
	Convey("Test GetName", t, func() {
		metaAction := &CompressAction{}
		So(metaAction.GetName(), ShouldEqual, compressActionName)
	})
}

func TestRpcAction_Init(t *testing.T) {

	Convey("", t, func() {

		action := &CompressAction{}
		job := &jobs.Job{}
		// Missing Parameters
		e := action.Init(job, nil, &jobs.Action{})
		So(action.Format, ShouldEqual, "zip")

		// Valid Cmd
		e = action.Init(job, nil, &jobs.Action{
			Parameters: map[string]string{
				"format": "tar.gz",
				"target": "path",
			},
		})
		So(e, ShouldBeNil)
		So(action.Format, ShouldEqual, "tar.gz")
		So(action.TargetName, ShouldEqual, "path")

	})
}
