package archive

import (
	"github.com/pydio/services/common/views"
	"github.com/pydio/services/common/proto/jobs"
	"github.com/micro/go-micro/client"
	"golang.org/x/net/context"
	"github.com/micro/go-micro/errors"
	"github.com/pydio/services/common"
)

var (
	extractActionName = "actions.archive.extract"
)

type ExtractAction struct{
	Router *views.Router
	Format string
	TargetName string
}

// Unique identifier
func (e *ExtractAction) GetName() string {
	return extractActionName
}

// Pass parameters
func (e *ExtractAction) Init(job *jobs.Job, cl client.Client, action *jobs.Action) error {
	e.Router = views.NewStandardRouter(true)
	if format, ok := action.Parameters["format"]; ok {
		e.Format = format
	} else {
		e.Format = "zip"
	}
	if target, ok := action.Parameters["target"]; ok {
		e.TargetName = target
	}
	return nil
}


// Run
func (e *ExtractAction) Run(ctx context.Context, input jobs.ActionMessage) (jobs.ActionMessage, error) {
	er := errors.BadRequest(common.SERVICE_JOBS, "Not Implemented")
	return input.WithError(er), er
}