package cmd

import (
	"github.com/micro/go-micro/client"
	"github.com/micro/go-micro/errors"
	"github.com/pydio/services/common/proto/jobs"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
	"testing"
)

func TestRpcAction_GetName(t *testing.T) {
	Convey("Test GetName", t, func() {
		metaAction := &RpcAction{}
		So(metaAction.GetName(), ShouldEqual, rpcActionName)
	})
}

func TestRpcAction_Init(t *testing.T) {

	Convey("", t, func() {

		action := &RpcAction{}
		job := &jobs.Job{}
		// Missing Parameters
		e := action.Init(job, nil, &jobs.Action{})
		So(e, ShouldNotBeNil)

		// Valid Cmd
		e = action.Init(job, nil, &jobs.Action{
			Parameters: map[string]string{
				"service": "pydio.service.test",
				"method":  "MethodName",
				"request": `{"parameter1":"value1"}`,
			},
		})
		So(e, ShouldBeNil)
		So(action.ServiceName, ShouldEqual, "pydio.service.test")
		So(action.MethodName, ShouldEqual, "MethodName")
		So(action.JsonRequest, ShouldResemble, map[string]interface{}{"parameter1": "value1"})

	})
}

func TestRpcAction_Run(t *testing.T) {

	Convey("", t, func() {

		action := &RpcAction{}
		job := &jobs.Job{}
		action.Init(job, client.DefaultClient, &jobs.Action{
			Parameters: map[string]string{
				"service": "pydio.service.test",
				"method":  "MethodName",
				"request": `{"parameter1":"value1"}`,
			},
		})

		outputMessage, err := action.Run(context.Background(), jobs.ActionMessage{})
		So(err, ShouldNotBeNil)
		output := outputMessage.GetLastOutput()
		So(output.ErrorString, ShouldEqual, err.Error())
		So(errors.Parse(err.Error()).Code, ShouldEqual, 500)
		So(errors.Parse(err.Error()).Detail, ShouldEqual, "none available")

	})

}
