package actions

import (
	. "github.com/smartystreets/goconvey/convey"
	"testing"
)

func TestGetActionsManager(t *testing.T) {

	Convey("Test GetActionsManager", t, func() {

		manager := GetActionsManager()
		So(manager, ShouldNotBeNil)
		So(manager.registeredActions, ShouldHaveLength, 1)

		manager.Register("fakeAction", func() ConcreteAction {
			return &FakeAction{}
		})
		So(manager.registeredActions, ShouldHaveLength, 2)

		act, ok := manager.ActionById("fakeAction")
		So(ok, ShouldBeTrue)
		So(act, ShouldResemble, &FakeAction{})

		act, ok = manager.ActionById("otherAction")
		So(ok, ShouldBeFalse)
		So(act, ShouldBeNil)

	})

}
