package tree

import (
	"github.com/pydio/services/common/proto/jobs"
	"github.com/pydio/services/common/proto/tree"
	"github.com/pydio/services/common/views"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
	"testing"
)

func TestMetaAction_GetName(t *testing.T) {
	Convey("Test GetName", t, func() {
		metaAction := &MetaAction{}
		So(metaAction.GetName(), ShouldEqual, metaActionName)
	})
}

func TestMetaAction_Init(t *testing.T) {
	Convey("", t, func() {
		metaAction := &MetaAction{}
		job := &jobs.Job{}
		action := &jobs.Action{
			Parameters: map[string]string{
				"metaName":  "key",
				"metaValue": "value",
			},
		}
		metaAction.Init(job, nil, action)
		So(metaAction.MetaNamespace, ShouldEqual, "key")
		So(metaAction.MetaValue, ShouldEqual, "value")
	})
}

func TestMetaAction_Run(t *testing.T) {
	Convey("", t, func() {
		metaAction := &MetaAction{}
		job := &jobs.Job{}
		action := &jobs.Action{
			Parameters: map[string]string{
				"metaName":  "key",
				"metaValue": "value",
			},
		}
		metaAction.Init(job, nil, action)
		mock := views.NewHandlerMock()
		metaAction.Client = mock

		ignored, err := metaAction.Run(context.Background(), jobs.ActionMessage{
			Nodes: []*tree.Node{},
		})
		So(ignored.GetLastOutput(), ShouldResemble, &jobs.ActionOutput{Ignored: true})

		output, err := metaAction.Run(context.Background(), jobs.ActionMessage{
			Nodes: []*tree.Node{&tree.Node{
				Path: "test",
			}},
		})
		So(err, ShouldBeNil)
		So(output.Nodes, ShouldHaveLength, 1)
		So(output.Nodes[0].GetStringMeta("key"), ShouldEqual, "value")
		So(output.GetLastOutput().Success, ShouldBeTrue)

		So(mock.Nodes, ShouldHaveLength, 2)
		So(mock.Nodes["from"].GetStringMeta("key"), ShouldEqual, "value")
		So(mock.Nodes["to"].GetStringMeta("key"), ShouldEqual, "value")
	})
}
