// Copyright 2019 Yunion
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package handler

import "testing"

func TestFindExtUserId(t *testing.T) {
	cases := []struct {
		in   string
		want string
	}{
		{
			in:   "authUserByCASV3: Authenticate: idp.SyncOrCreateDomainAndUser: qiujian: UserNotFound",
			want: "qiujian",
		},
	}
	for _, c := range cases {
		got := findExtUserId(c.in)
		if got != c.want {
			t.Errorf("want %s got %s", c.want, got)
		}
	}
}
