// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by model-api-gen. DO NOT EDIT.

package cloudprovider

import "yunion.io/x/onecloud/pkg/cloudprovider"

// DefaultAction is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.DefaultAction.
type DefaultAction struct {
	// Allow, Block, Log, Count, Alert, Detection, Prevention
	Action string `json:"action"`
	// 仅Action为Allow时生效
	InsertHeaders map[string]string `json:"insert_headers"`
	// 仅Action为Block时生效
	Response string `json:"response"`
	// 仅Action为Block时生效
	ResponseCode *int `json:"response_code"`
	// 仅Action为Block时生效
	ResponseHeaders map[string]string `json:"response_headers"`
}

// SCdnDomain is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.SCdnDomain.
type SCdnDomain struct {
	// cdn加速域名
	Domain string `json:"domain"`
	// 状态 rejected(域名未审核)|processing(部署中)|online|offline
	Status string `json:"status"`
	// 区域 mainland|overseas|global
	Area string `json:"area"`
	// cdn Cname
	Cname string `json:"cname"`
	// 源站
	Origin string `json:"origin"`
	// 源站类型 domain|ip|bucket
	OriginType string `json:"origin_type"`
}

// SCdnOrigin is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.SCdnOrigin.
type SCdnOrigin struct {
	Type       string `json:"type"`
	Origin     string `json:"origin"`
	ServerName string `json:"server_name"`
	Protocol   string `json:"protocol"`
	Path       string `json:"path"`
	Port       int    `json:"port"`
	Enabled    string `json:"enabled"`
	Priority   int    `json:"priority"`
}

// SCdnOrigins is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.SCdnOrigins.
type SCdnOrigins []SCdnOrigin

// SExcludeRule is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.SExcludeRule.
type SExcludeRule struct {
	Name string `json:"name"`
}

// SExcludeRules is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.SExcludeRules.
type SExcludeRules []SExcludeRule

// SGeographicInfo is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.SGeographicInfo.
type SGeographicInfo struct {
	// 纬度
	// example: 26.647003
	Latitude float32 `json:"latitude"`
	// 经度
	// example: 106.630211
	Longitude float32 `json:"longitude"`
	// 城市
	// example: Guiyang
	City string `json:"city"`
	// 国家代码
	// example: CN
	CountryCode string `json:"country_code"`
}

// SSubAccount is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.SSubAccount.
type SSubAccount struct {
	// 若Account不为空，可不传
	Name string `json:"name"`
	// 输入必填，若为空，需要指定子账号名称
	Account      string `json:"account"`
	HealthStatus string `json:"health_status"`
	// 云端服务健康状态。例如欠费、项目冻结都属于不健康状态。
	DefaultProjectId string `json:"default_project_id"`
}

// SWafStatement is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.SWafStatement.
type SWafStatement struct {
	// 管理规则组名称
	ManagedRuleGroupName string `json:"managed_rule_group_name"`
	// 不包含的规则列表
	ExcludeRules *SExcludeRules `json:"exclude_rules"`
	// 表达式类别
	// enmu: ByteMatch, GeoMatch, IPSet, LabelMatch, ManagedRuleGroup, Rate, RegexSet, RuleGroup, Size, SqliMatch, XssMatch
	Type string `json:"type"`
	// 是否取反操作, 仅对Azure生效
	Negation bool `json:"negation"`
	// 操作类型
	// enum: EQ, NE, LE, LT, GE, GT
	Operator string `json:"operator"`
	// 匹配字段
	// enmu: Body, JsonBody, Query, Method, Header, UriPath, PostArgs, Cookie
	MatchField string `json:"match_field"`
	// 匹配字段的key
	MatchFieldKey string `json:"match_field_key"`
	// 匹配字段的值列表
	MatchFieldValues *TWafMatchFieldValues `json:"match_field_values"`
	// 进行转换操作
	// enmu: CompressWithSpace, HtmlEntityDecode, Lowercase, CmdLine, UrlDecode, Trim, UrlEncode, RemoveNulls
	Transformations   *TextTransformations `json:"transformations"`
	ForwardedIPHeader string               `json:"forwarded_ip_header"`
	// 搜索字段, 仅Aws有用
	SearchString string `json:"search_string"`
	IPSetId      string `json:"ip_set_id"`
	// 正则表达式Id, 目前只读
	RegexSetId string `json:"regex_set_id"`
	// 自定义规则组Id, 目前只读
	RuleGroupId string `json:"rule_group_id"`
}

// ServerVncInput is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.ServerVncInput.
type ServerVncInput struct {
	// 是否使用原生vnc控制台，此选项仅对openstack有效
	// default: false
	Origin bool `json:"origin"`
}

// ServerVncOutput is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.ServerVncOutput.
type ServerVncOutput struct {
	Id string `json:"id"`
	// baremetal
	HostId string `json:"host_id"`
	Zone   string `json:"zone"`
	// kvm host ip
	Host         string `json:"host"`
	Protocol     string `json:"protocol"`
	Port         int64  `json:"port"`
	Url          string `json:"url"`
	InstanceId   string `json:"instance_id"`
	InstanceName string `json:"instance_name"`
	Password     string `json:"password"`
	VncPassword  string `json:"vnc_password"`
	OsName       string `json:"os_name"`
	// cloudpods
	ApiServer     string `json:"api_server"`
	ConnectParams string `json:"connect_params"`
	Session       string `json:"session"`
	Hypervisor    string `json:"hypervisor"`
}

// SubAccounts is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.SubAccounts.
type SubAccounts struct {
	// 若输出则是全量子账号列表，若输入，代表允许同步的子账号
	Accounts []cloudprovider.SSubAccount `json:"accounts"`
	// 若输出是云账号查询到的区域列表，若输入，代表允许同步的区域
	Cloudregions []struct {
		Id     string
		Name   string
		Status string
	} `json:"cloudregions"`
}

// TWafAction is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.TWafAction.
type TWafAction string

// TWafMatchField is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.TWafMatchField.
type TWafMatchField string

// TWafMatchFieldValues is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.TWafMatchFieldValues.
type TWafMatchFieldValues []string

// TWafOperator is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.TWafOperator.
type TWafOperator string

// TWafStatementType is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.TWafStatementType.
type TWafStatementType string

// TWafTextTransformation is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.TWafTextTransformation.
type TWafTextTransformation string

// TextTransformations is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.TextTransformations.
type TextTransformations []TWafTextTransformation

// WafAddresses is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.WafAddresses.
type WafAddresses []string

// WafRegexPatterns is an autogenerated struct via yunion.io/x/onecloud/pkg/cloudprovider.WafRegexPatterns.
type WafRegexPatterns []string
