// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by model-api-gen. DO NOT EDIT.

package compute

import (
	time "time"

	jsonutils "yunion.io/x/jsonutils"

	"yunion.io/x/onecloud/pkg/apis"
	"yunion.io/x/onecloud/pkg/apis/cloudprovider"
)

// SAccessGroup is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SAccessGroup.
type SAccessGroup struct {
	apis.SStatusInfrasResourceBase
	IsDirty bool `json:"is_dirty"`
}

// SAccessGroupCache is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SAccessGroupCache.
type SAccessGroupCache struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SCloudregionResourceBase
	SManagedResourceBase
	SAccessGroupResourceBase
	// 已关联的挂载点数量
	MountTargetCount int    `json:"mount_target_count"`
	FileSystemType   string `json:"file_system_type"`
	NetworkType      string `json:"network_type"`
}

// SAccessGroupResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SAccessGroupResourceBase.
type SAccessGroupResourceBase struct {
	// 权限组Id
	AccessGroupId string `json:"access_group_id"`
}

// SAccessGroupRule is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SAccessGroupRule.
type SAccessGroupRule struct {
	apis.SResourceBase
	SAccessGroupResourceBase
	Id             string `json:"id"`
	Priority       int    `json:"priority"`
	Source         string `json:"source"`
	RWAccessType   string `json:"rw_access_type"`
	UserAccessType string `json:"user_access_type"`
	Description    string `json:"description"`
}

// SApp is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SApp.
type SApp struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	apis.SEnabledResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	Type      string `json:"type"`
	TechStack string `json:"tech_stack"`
	Kind      string `json:"kind"`
}

// SAppEnvironment is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SAppEnvironment.
type SAppEnvironment struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	AppId          string `json:"app_id"`
	InstanceType   string `json:"instance_type"`
	InstanceNumber int    `json:"instance_number"`
}

// SAwsCachedLb is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SAwsCachedLb.
type SAwsCachedLb struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	BackendServerId string `json:"backend_server_id"`
	// 后端服务器 实例ID
	BackendId string `json:"backend_id"`
	// 本地loadbalancebackend id
	CachedBackendGroupId string `json:"cached_backend_group_id"`
}

// SAwsCachedLbbg is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SAwsCachedLbbg.
type SAwsCachedLbbg struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	LoadbalancerId string `json:"loadbalancer_id"`
	BackendGroupId string `json:"backend_group_id"`
	TargetType     string `json:"target_type"`
	// 后端服务器类型
	ProtocolType string `json:"protocol_type"`
	// 监听协议类型
	Port int `json:"port"`
	// 监听端口
	HealthCheckProtocol string `json:"health_check_protocol"`
	// 健康检查协议类型
	HealthCheckInterval int `json:"health_check_interval"`
}

// SBackupDiskConfig is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SBackupDiskConfig.
type SBackupDiskConfig struct {
	DiskConfig
	Name string `json:"name"`
}

// SBackupStorage is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SBackupStorage.
type SBackupStorage struct {
	apis.SEnabledStatusInfrasResourceBase
	AccessInfo  *SBackupStorageAccessInfo `json:"access_info"`
	StorageType string                    `json:"storage_type"`
	CapacityMb  int                       `json:"capacity_mb"`
}

// SBackupStorageAccessInfo is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SBackupStorageAccessInfo.
type SBackupStorageAccessInfo struct {
	NfsHost      string `json:"nfs_host"`
	NfsSharedDir string `json:"nfs_shared_dir"`
}

// SBaremetalagent is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SBaremetalagent.
type SBaremetalagent struct {
	apis.SStandaloneResourceBase
	SZoneResourceBase
	Status         string `json:"status"`
	AccessIp       string `json:"access_ip"`
	ManagerUri     string `json:"manager_uri"`
	AgentType      string `json:"agent_type"`
	Version        string `json:"version"`
	StoragecacheId string `json:"storagecache_id"`
}

// SBillingResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SBillingResourceBase.
type SBillingResourceBase struct {
	// 计费类型, 按量、包年包月
	// example: postpaid
	BillingType string `json:"billing_type"`
	// 过期时间
	ExpiredAt time.Time `json:"expired_at"`
	// 计费周期
	BillingCycle string `json:"billing_cycle"`
	// 是否自动续费
	AutoRenew bool `json:"auto_renew"`
}

// SBillingResourceCheck is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SBillingResourceCheck.
type SBillingResourceCheck struct {
	apis.SResourceBase
	ResourceId   string `json:"resource_id"`
	ResourceType string `json:"resource_type"`
	AdvanceDays  int    `json:"advance_days"`
	NotifyNumber int    `json:"notify_number"`
}

// SBucket is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SBucket.
type SBucket struct {
	apis.SSharableVirtualResourceBase
	apis.SExternalizedResourceBase
	SCloudregionResourceBase
	SManagedResourceBase
	StorageClass   string               `json:"storage_class"`
	Location       string               `json:"location"`
	Acl            string               `json:"acl"`
	SizeBytes      int64                `json:"size_bytes"`
	ObjectCnt      int                  `json:"object_cnt"`
	SizeBytesLimit int64                `json:"size_bytes_limit"`
	ObjectCntLimit int                  `json:"object_cnt_limit"`
	AccessUrls     jsonutils.JSONObject `json:"access_urls"`
}

// SCDNDomain is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SCDNDomain.
type SCDNDomain struct {
	apis.SEnabledStatusInfrasResourceBase
	apis.SExternalizedResourceBase
	SDeletePreventableResourceBase
	SManagedResourceBase
	Cname string `json:"cname"`
	// 源站信息
	Origins *cloudprovider.SCdnOrigins `json:"origins"`
	// 服务类别
	ServiceType string `json:"service_type"`
	// 加速区域
	Area string `json:"area"`
}

// SCachedLoadbalancerAcl is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SCachedLoadbalancerAcl.
type SCachedLoadbalancerAcl struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	SLoadbalancerAclResourceBase
	ListenerId string `json:"listener_id"`
}

// SCachedLoadbalancerCertificate is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SCachedLoadbalancerCertificate.
type SCachedLoadbalancerCertificate struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	// 云账号ID
	SCloudregionResourceBase
	SLoadbalancerCertificateResourceBase
}

// SCachedimage is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SCachedimage.
type SCachedimage struct {
	apis.SSharableVirtualResourceBase
	apis.SExternalizedResourceBase
	// 镜像大小单位: Byte
	// example: 53687091200
	Size int64 `json:"size"`
	// 镜像详情信息
	// example: {"deleted":false,"disk_format":"qcow2","id":"img-a6uucnfl","is_public":true,"min_disk":51200,"min_ram":0,"name":"FreeBSD 11.1 64bit","properties":{"os_arch":"x86_64","os_distribution":"FreeBSD","os_type":"FreeBSD","os_version":"11"},"protected":true,"size":53687091200,"status":"active"}
	Info jsonutils.JSONObject `json:"info"`
	// 上此同步时间
	// example: 2020-01-17T05:28:54.000000Z
	LastSync time.Time `json:"last_sync"`
	// 最近一次缓存引用时间
	// 2020-01-17T05:20:54.000000Z
	LastRef time.Time `json:"last_ref"`
	// 引用次数
	// example: 0
	RefCount int `json:"ref_count"`
	// 是否支持UEFI
	// example: false
	UEFI *bool `json:"uefi,omitempty"`
	// 镜像类型, system: 公有云镜像, customized: 自定义镜像
	// example: system
	ImageType string `json:"image_type"`
}

// SCloudaccount is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SCloudaccount.
type SCloudaccount struct {
	apis.SEnabledStatusInfrasResourceBase
	SSyncableBaseResource
	// 项目Id
	ProjectId string `json:"tenant_id"`
	// 云环境连接地址
	AccessUrl string `json:"access_url"`
	// 云账号
	Account string `json:"account"`
	// 云账号密码
	Secret string `json:"secret"`
	// 云环境唯一标识
	AccountId string `json:"account_id"`
	// 是否是公有云账号
	// example: true
	IsPublicCloud *bool `json:"is_public_cloud,omitempty"`
	// 是否是本地IDC账号
	// example: false
	IsOnPremise bool `json:"is_on_premise"`
	// 云平台类型
	// example: google
	Provider string `json:"provider"`
	// 账户余额
	// example: 124.2
	Balance float64 `json:"balance"`
	// 上次账号探测时间
	ProbeAt time.Time `json:"probe_at"`
	// 账号健康状态
	// example: normal
	HealthStatus string `json:"health_status"`
	// 账号探测异常错误次数
	ErrorCount int `json:"error_count"`
	// 是否根据云上项目自动在本地创建对应项目
	// example: false
	AutoCreateProject bool `json:"auto_create_project"`
	// 云API版本
	Version string `json:"version"`
	// 云系统信息
	Sysinfo jsonutils.JSONObject `json:"sysinfo"`
	// 品牌信息, 一般和provider相同
	// example: DStack
	Brand string `json:"brand"`
	// 额外信息
	Options *jsonutils.JSONDict `json:"options"`
	// for backward compatiblity, keep is_public field, but not usable
	// IsPublic bool `default:"false" nullable:"false"`
	// add share_mode field to indicate the share range of this account
	ShareMode string `json:"share_mode"`
	// 默认值proxyapi.ProxySettingId_DIRECT
	ProxySettingId string `json:"proxy_setting_id"`
	// 公有云子账号登录地址
	IamLoginUrl string `json:"iam_login_url"`
	SAMLAuth    *bool  `json:"saml_auth,omitempty"`
	SProjectMappingResourceBase
	ReadOnly bool `json:"read_only"`
	// 设置允许同步的账号及订阅
	SubAccounts *cloudprovider.SubAccounts `json:"sub_accounts"`
	// 缺失的权限，云账号操作资源时自动更新
	LakeOfPermissions *SAccountPermissions `json:"lake_of_permissions"`
}

// SCloudimage is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SCloudimage.
type SCloudimage struct {
	apis.SStandaloneResourceBase
	apis.SExternalizedResourceBase
	SCloudregionResourceBase
}

// SCloudprovider is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SCloudprovider.
type SCloudprovider struct {
	apis.SEnabledStatusStandaloneResourceBase
	apis.SProjectizedResourceBase
	SSyncableBaseResource
	// 云端服务健康状态。例如欠费、项目冻结都属于不健康状态。
	// | HealthStatus  | 说明                 |
	// |---------------|----------------------|
	// | normal        | 远端处于健康状态     |
	// | insufficient  | 不足按需资源余额     |
	// | suspended     | 远端处于冻结状态     |
	// | arrears       | 远端处于欠费状态     |
	// | unknown       | 未知状态，查询失败   |
	// | no permission | 没有权限获取账单信息 |
	HealthStatus string `json:"health_status"`
	AccessUrl    string `json:"access_url"`
	// 云账号的用户信息，例如用户名，access key等
	Account string `json:"account"`
	// 云账号的密码信息，例如密码，access key secret等。该字段在数据库加密存储。Google需要存储秘钥证书,需要此字段比较长
	Secret string `json:"secret"`
	// 归属云账号ID
	CloudaccountId string `json:"cloudaccount_id"`
	// 云账号的平台信息
	Provider string `json:"provider"`
	SProjectMappingResourceBase
}

// SCloudproviderCapability is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SCloudproviderCapability.
type SCloudproviderCapability struct {
	apis.SResourceBase
	CloudproviderId string `json:"cloudprovider_id"`
	CloudregionId   string `json:"cloudregion_id"`
	Capability      string `json:"capability"`
}

// SCloudproviderQuota is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SCloudproviderQuota.
type SCloudproviderQuota struct {
	apis.SStandaloneResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	// 配额范围
	// cloudregion: 区域级别
	// cloudprovider: 云订阅级别
	QuotaRange string `json:"quota_range"`
	// 已使用的配额
	// -1代表未从云平台拿到已使用配额信息
	UsedCount int `json:"used_count"`
	// 最大配额限制
	MaxCount int `json:"max_count"`
	// 配额类型
	QuotaType string `json:"quota_type"`
}

// SCloudproviderResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SCloudproviderResourceBase.
type SCloudproviderResourceBase struct {
	CloudproviderId string `json:"cloudprovider_id"`
}

// SCloudproviderregion is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SCloudproviderregion.
type SCloudproviderregion struct {
	apis.SJointResourceBase
	SSyncableBaseResource
	SCloudregionResourceBase
	// 云订阅ID
	CloudproviderId string `json:"cloudprovider_id"`
	Enabled         bool   `json:"enabled"`
	// SyncIntervalSeconds int `list:"domain"`
	SyncResults    jsonutils.JSONObject `json:"sync_results"`
	LastDeepSyncAt time.Time            `json:"last_deep_sync_at"`
	LastAutoSyncAt time.Time            `json:"last_auto_sync_at"`
}

// SCloudproviderschedtag is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SCloudproviderschedtag.
type SCloudproviderschedtag struct {
	SSchedtagJointsBase
	SCloudproviderResourceBase
}

// SCloudregion is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SCloudregion.
type SCloudregion struct {
	apis.SEnabledStatusStandaloneResourceBase
	SI18nResourceBase
	SManagedResourceBase
	apis.SExternalizedResourceBase
	cloudprovider.SGeographicInfo
	// 云环境
	// example: ChinaCloud
	Environment string `json:"environment"`
	// 云平台
	// example: Huawei
	Provider string `json:"provider"`
}

// SCloudregionResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SCloudregionResourceBase.
type SCloudregionResourceBase struct {
	// 归属区域ID
	CloudregionId string `json:"cloudregion_id"`
}

// SCloudregionschedtag is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SCloudregionschedtag.
type SCloudregionschedtag struct {
	SSchedtagJointsBase
	SCloudregionResourceBase
}

// SDBInstance is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDBInstance.
type SDBInstance struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SBillingResourceBase
	SCloudregionResourceBase
	SDeletePreventableResourceBase
	// 主实例Id
	MasterInstanceId string `json:"master_instance_id"`
	// CPU数量
	// example: 1
	VcpuCount int `json:"vcpu_count"`
	// 内存大小
	// example: 1024
	VmemSizeMb int `json:"vmem_size_mb"`
	// 存储类型
	// example: local_ssd
	StorageType string `json:"storage_type"`
	// 存储大小
	// example: 10240
	DiskSizeGB int `json:"disk_size_gb"`
	// 端口
	// example: 3306
	Port int `json:"port"`
	// 实例类型
	// example: ha
	Category string `json:"category"`
	// 引擎
	// example: MySQL
	Engine string `json:"engine"`
	// 引擎版本
	// example: 5.7
	EngineVersion string `json:"engine_version"`
	// 套餐名称
	// example: mysql.x4.large.2c
	InstanceType string `json:"instance_type"`
	// 维护时间
	MaintainTime string `json:"maintain_time"`
	// 虚拟私有网络Id
	// example: ed20d84e-3158-41b1-870c-1725e412e8b6
	VpcId string `json:"vpc_id"`
	// 外部连接地址
	ConnectionStr string `json:"connection_str"`
	// 内部连接地址
	InternalConnectionStr string `json:"internal_connection_str"`
	// 可用区1
	Zone1 string `json:"zone1"`
	// 可用区2
	Zone2 string `json:"zone2"`
	// 可用区3
	Zone3 string `json:"zone3"`
	// 从备份创建新实例
	DBInstancebackupId string `json:"dbinstancebackup_id"`
}

// SDBInstanceAccount is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDBInstanceAccount.
type SDBInstanceAccount struct {
	apis.SStatusStandaloneResourceBase
	Host string `json:"host"`
	SDBInstanceResourceBase
	// 数据库密码
	Secret string `json:"secret"`
}

// SDBInstanceBackup is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDBInstanceBackup.
type SDBInstanceBackup struct {
	apis.SVirtualResourceBase
	SCloudregionResourceBase
	SManagedResourceBase
	apis.SExternalizedResourceBase
	SDBInstanceResourceBase
	// RDS引擎
	// example: MySQL
	Engine string `json:"engine"`
	// RDS引擎版本
	// example: 5.7
	EngineVersion string `json:"engine_version"`
	// 备份开始时间
	StartTime time.Time `json:"start_time"`
	// 备份结束时间
	EndTime time.Time `json:"end_time"`
	// 备份模式
	BackupMode string `json:"backup_mode"`
	// 备份数据库名称
	DBNames string `json:"db_names"`
	// 备份大小
	// example: 32
	BackupSizeMb int `json:"backup_size_mb"`
	// 备份方式 Logical|Physical
	BackupMethod string `json:"backup_method"`
}

// SDBInstanceDatabase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDBInstanceDatabase.
type SDBInstanceDatabase struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SDBInstanceResourceBase
	// 字符集
	// example: utf-8
	CharacterSet string `json:"character_set"`
}

// SDBInstanceJointsBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDBInstanceJointsBase.
type SDBInstanceJointsBase struct {
	apis.SVirtualJointResourceBase
	SDBInstanceResourceBase
}

// SDBInstanceNetwork is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDBInstanceNetwork.
type SDBInstanceNetwork struct {
	SDBInstanceJointsBase
	NetworkId string `json:"network_id"`
	IpAddr    string `json:"ip_addr"`
}

// SDBInstanceParameter is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDBInstanceParameter.
type SDBInstanceParameter struct {
	apis.SStandaloneResourceBase
	apis.SExternalizedResourceBase
	SDBInstanceResourceBase
	// 数据库参数名称
	Key string `json:"key"`
	// 数据库参数值
	Value string `json:"value"`
}

// SDBInstancePrivilege is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDBInstancePrivilege.
type SDBInstancePrivilege struct {
	apis.SResourceBase
	apis.SExternalizedResourceBase
	Id                   string `json:"id"`
	Privilege            string `json:"privilege"`
	DBInstanceaccountId  string `json:"dbinstanceaccount_id"`
	DBInstancedatabaseId string `json:"dbinstancedatabase_id"`
}

// SDBInstanceResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDBInstanceResourceBase.
type SDBInstanceResourceBase struct {
	DBInstanceId string `json:"dbinstance_id"`
}

// SDBInstanceSecgroup is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDBInstanceSecgroup.
type SDBInstanceSecgroup struct {
	SDBInstanceJointsBase
	SSecurityGroupResourceBase
}

// SDBInstanceSku is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDBInstanceSku.
type SDBInstanceSku struct {
	apis.SEnabledStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SCloudregionResourceBase
	Provider     string `json:"provider"`
	StorageType  string `json:"storage_type"`
	DiskSizeStep int    `json:"disk_size_step"`
	// 步长
	MaxDiskSizeGb  int    `json:"max_disk_size_gb"`
	MinDiskSizeGb  int    `json:"min_disk_size_gb"`
	IOPS           int    `json:"iops"`
	TPS            int    `json:"tps"`
	QPS            int    `json:"qps"`
	MaxConnections int    `json:"max_connections"`
	VcpuCount      int    `json:"vcpu_count"`
	VmemSizeMb     int    `json:"vmem_size_mb"`
	Category       string `json:"category"`
	Engine         string `json:"engine"`
	EngineVersion  string `json:"engine_version"`
	Zone1          string `json:"zone1"`
	Zone2          string `json:"zone2"`
	Zone3          string `json:"zone3"`
	ZoneId         string `json:"zone_id"`
	MultiAZ        *bool  `json:"multi_az,omitempty"`
}

// SDeletePreventableResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDeletePreventableResourceBase.
type SDeletePreventableResourceBase struct {
	// 是否开启删除保护
	// example: true
	DisableDelete *bool `json:"disable_delete,omitempty"`
}

// SDisk is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDisk.
type SDisk struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SBillingResourceBase
	SStorageResourceBase
	apis.SMultiArchResourceBase
	apis.SAutoDeleteResourceBase
	apis.SEncryptedResource
	// 磁盘存储类型
	// example: qcow2
	DiskFormat string `json:"disk_format"`
	// 磁盘大小, 单位Mb
	// example: 10240
	DiskSize int `json:"disk_size"`
	// 磁盘路径
	AccessPath string `json:"access_path"`
	// 备份磁盘实例的存储ID
	BackupStorageId string `json:"backup_storage_id"`
	// 镜像Id
	TemplateId string `json:"template_id"`
	// 快照Id
	SnapshotId string `json:"snapshot_id"`
	// 备份Id
	BackupId string `json:"backup_id"`
	// 文件系统
	FsFormat string `json:"fs_format"`
	// 磁盘类型
	// sys: 系统盘
	// data: 数据盘
	// swap: 交换盘
	// example: sys
	DiskType string `json:"disk_type"`
	// # is persistent
	Nonpersistent bool `json:"nonpersistent"`
	// 是否标记为SSD磁盘
	IsSsd bool `json:"is_ssd"`
}

// SDiskBackup is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDiskBackup.
type SDiskBackup struct {
	apis.SVirtualResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	apis.SMultiArchResourceBase
	apis.SEncryptedResource
	DiskId          string `json:"disk_id"`
	BackupStorageId string `json:"backup_storage_id"`
	StorageId       string `json:"storage_id"`
	// 备份大小
	SizeMb     int    `json:"size_mb"`
	DiskSizeMb int    `json:"disk_size_mb"`
	DiskType   string `json:"disk_type"`
	// 操作系统类型
	OsType     string             `json:"os_type"`
	DiskConfig *SBackupDiskConfig `json:"disk_config"`
}

// SDiskResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDiskResourceBase.
type SDiskResourceBase struct {
	DiskId string `json:"disk_id"`
}

// SDnsRecord is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDnsRecord.
type SDnsRecord struct {
	apis.SAdminSharableVirtualResourceBase
	apis.SEnabledResourceBase
	// DNS记录的过期时间，单位为秒
	// example: 60
	Ttl int `json:"ttl"`
}

// SDnsRecordSet is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDnsRecordSet.
type SDnsRecordSet struct {
	apis.SEnabledStatusStandaloneResourceBase
	SDnsZoneResourceBase
	DnsType    string `json:"dns_type"`
	DnsValue   string `json:"dns_value"`
	TTL        int64  `json:"ttl"`
	MxPriority int64  `json:"mx_priority"`
}

// SDnsRecordSetTrafficPolicy is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDnsRecordSetTrafficPolicy.
type SDnsRecordSetTrafficPolicy struct {
	apis.SJointResourceBase
	DnsRecordsetId     string `json:"dns_recordset_id"`
	DnsTrafficPolicyId string `json:"dns_traffic_policy_id"`
}

// SDnsTrafficPolicy is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDnsTrafficPolicy.
type SDnsTrafficPolicy struct {
	apis.SEnabledStatusInfrasResourceBase
	Provider    string              `json:"provider"`
	PolicyType  string              `json:"policy_type"`
	PolicyValue string              `json:"policy_value"`
	Options     *jsonutils.JSONDict `json:"options"`
}

// SDnsZone is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDnsZone.
type SDnsZone struct {
	apis.SEnabledStatusInfrasResourceBase
	IsDirty  bool                `json:"is_dirty"`
	ZoneType string              `json:"zone_type"`
	Options  *jsonutils.JSONDict `json:"options"`
}

// SDnsZoneCache is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDnsZoneCache.
type SDnsZoneCache struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SDnsZoneResourceBase
	// 归属云账号ID
	CloudaccountId string `json:"cloudaccount_id"`
	ProductType    string `json:"product_type"`
}

// SDnsZoneResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDnsZoneResourceBase.
type SDnsZoneResourceBase struct {
	DnsZoneId string `json:"dns_zone_id"`
}

// SDnsZoneVpc is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDnsZoneVpc.
type SDnsZoneVpc struct {
	apis.SJointResourceBase
	SDnsZoneResourceBase
	VpcId string `json:"vpc_id"`
}

// SDynamicschedtag is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SDynamicschedtag.
type SDynamicschedtag struct {
	apis.SStandaloneResourceBase
	SSchedtagResourceBase
	// 动态调度标间的匹配条件
	// example: host.sys_load > 1.5 || host.mem_used_percent > 0.7 => "high_load"
	Condition string `json:"condition"`
	Enabled   *bool  `json:"enabled,omitempty"`
}

// SElasticSearch is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SElasticSearch.
type SElasticSearch struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SBillingResourceBase
	SCloudregionResourceBase
	SDeletePreventableResourceBase
	// 版本
	Version string `json:"version"`
	// 套餐名称
	// example: elasticsearch.sn2ne.xlarge
	InstanceType string `json:"instance_type"`
	// CPU数量
	// example: 1
	VcpuCount int `json:"vcpu_count"`
	// 内存大小
	// example: 1024
	VmemSizeGb int `json:"vmem_size_gb"`
	// 存储类型
	// example: local_ssd
	StorageType string `json:"storage_type"`
	// 存储大小
	// example: 1024
	DiskSizeGb int `json:"disk_size_gb"`
	// 实例类型
	// example: ha
	Category  string `json:"category"`
	VpcId     string `json:"vpc_id"`
	NetworkId string `json:"network_id"`
	// 可用区Id
	ZoneId string `json:"zone_id"`
	// 是否是多可用区部署
	IsMultiAz bool `json:"is_multi_az"`
}

// SElasticcache is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SElasticcache.
type SElasticcache struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SBillingResourceBase
	SDeletePreventableResourceBase
	SVpcResourceBase
	SZoneResourceBase
	// 备可用区
	SlaveZones string `json:"slave_zones"`
	// 实例规格
	// example: redis.master.micro.default
	InstanceType string `json:"instance_type"`
	// 容量
	// example: 1024
	CapacityMB int `json:"capacity_mb"`
	// 对应Sku
	LocalCategory string `json:"local_category"`
	// 类型
	// single（单副本） | double（双副本) | readone (单可读) | readthree （3可读） | readfive（5只读）
	NodeType string `json:"node_type"`
	// 后端存储引擎
	// Redis | Memcache
	// example: redis
	Engine string `json:"engine"`
	// 后端存储引擎版本
	// example: 4.0
	EngineVersion string `json:"engine_version"`
	// 网络类型, CLASSIC（经典网络）  VPC（专有网络）
	// example: CLASSIC
	NetworkType string `json:"network_type"`
	// 所属网络ID
	NetworkId string `json:"network_id"`
	// 安全组
	SecurityGroupId string `json:"security_group_id"`
	//  内网DNS
	PrivateDNS string `json:"private_dns"`
	//  内网IP地址
	PrivateIpAddr string `json:"private_ip_addr"`
	// 内网访问端口
	PrivateConnectPort int `json:"private_connect_port"`
	// 公网DNS
	PublicDNS string `json:"public_dns"`
	// 公网IP地址
	PublicIpAddr string `json:"public_ip_addr"`
	// 外网访问端口
	PublicConnectPort int `json:"public_connect_port"`
	// 维护开始时间，格式为HH:mmZ
	// example: 02:00Z
	MaintainStartTime string `json:"maintain_start_time"`
	// 维护结束时间
	MaintainEndTime string `json:"maintain_end_time"`
	// 访问密码？ on （开启密码）|off （免密码访问）
	AuthMode string `json:"auth_mode"`
}

// SElasticcacheAccount is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SElasticcacheAccount.
type SElasticcacheAccount struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SElasticcacheResourceBase
	AccountType string `json:"account_type"`
	// 账号类型 normal |admin
	AccountPrivilege string `json:"account_privilege"`
	// 账号权限 read | write | repl（复制, 复制权限支持读写，且开放SYNC/PSYNC命令）
	Password string `json:"password"`
}

// SElasticcacheAcl is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SElasticcacheAcl.
type SElasticcacheAcl struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SElasticcacheResourceBase
	// Ip地址白名单列表
	IpList string `json:"ip_list"`
}

// SElasticcacheBackup is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SElasticcacheBackup.
type SElasticcacheBackup struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SElasticcacheResourceBase
	// 备份大小
	BackupSizeMb int `json:"backup_size_mb"`
	// 备份类型, 全量|增量额
	BackupType string `json:"backup_type"`
	// 备份模式，自动|手动
	BackupMode string `json:"backup_mode"`
	// 下载地址
	DownloadURL string `json:"download_url"`
	// 开始备份时间
	StartTime time.Time `json:"start_time"`
	// 结束备份时间
	EndTime time.Time `json:"end_time"`
}

// SElasticcacheJointsBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SElasticcacheJointsBase.
type SElasticcacheJointsBase struct {
	apis.SVirtualJointResourceBase
	SElasticcacheResourceBase
}

// SElasticcacheParameter is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SElasticcacheParameter.
type SElasticcacheParameter struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SElasticcacheResourceBase
	// Parameter KEY
	Key string `json:"key"`
	// Parameter Value
	Value string `json:"value"`
	// 校验代码，参数的可选范围。
	ValueRange string `json:"value_range"`
	// True（可修改）   False（不可修改）
	Modifiable bool `json:"modifiable"`
	// True（重启生效） False（无需重启，提交后即生效）
	ForceRestart bool `json:"force_restart"`
}

// SElasticcacheResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SElasticcacheResourceBase.
type SElasticcacheResourceBase struct {
	// 弹性缓存ID
	ElasticcacheId string `json:"elasticcache_id"`
}

// SElasticcacheSku is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SElasticcacheSku.
type SElasticcacheSku struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SCloudregionResourceBase
	// 区域
	SZoneResourceBase
	SlaveZoneId    string `json:"slave_zone_id"`
	InstanceSpec   string `json:"instance_spec"`
	EngineArch     string `json:"engine_arch"`
	LocalCategory  string `json:"local_category"`
	PrepaidStatus  string `json:"prepaid_status"`
	PostpaidStatus string `json:"postpaid_status"`
	// 引擎	redis|memcached
	Engine string `json:"engine"`
	// 引擎版本	3.0
	EngineVersion string `json:"engine_version"`
	// CPU 架构 x86|ARM
	CpuArch string `json:"cpu_arch"`
	// 存储类型	DRAM|SCM
	StorageType string `json:"storage_type"`
	// standrad|enhanced
	PerformanceType string `json:"performance_type"`
	// single（单副本） | double（双副本) | readone (单可读) | readthree （3可读） | readfive（5只读）
	NodeType string `json:"node_type"`
	// 内存容量
	MemorySizeMB int `json:"memory_size_mb"`
	// 套餐附带硬盘容量
	DiskSizeGB int `json:"disk_size_gb"`
	// 最小分片数量
	ShardNum int `json:"shard_num"`
	// 最大分片数量
	MaxShardNum int `json:"max_shard_num"`
	// 最小副本数量
	ReplicasNum int `json:"replicas_num"`
	// 最大副本数量
	MaxReplicasNum int `json:"max_replicas_num"`
	// 最大客户端数
	MaxClients int `json:"max_clients"`
	// 最大连接数
	MaxConnections int `json:"max_connections"`
	// 最大内网带宽
	MaxInBandwidthMb int `json:"max_in_bandwidth_mb"`
	// 实际可使用的最大内存
	MaxMemoryMB int `json:"max_memory_mb"`
	// QPS参考值
	QPS int `json:"qps"`
	// 公有云厂商	Aliyun/Azure/AWS/Qcloud/...
	Provider string `json:"provider"`
}

// SElasticcachesecgroup is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SElasticcachesecgroup.
type SElasticcachesecgroup struct {
	SElasticcacheJointsBase
	SSecurityGroupResourceBase
}

// SElasticip is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SElasticip.
type SElasticip struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	SBillingResourceBase
	// IP子网Id, 仅私有云不为空
	NetworkId string `json:"network_id"`
	// 标识弹性或非弹性
	// | Mode       | 说明       |
	// |------------|------------|
	// | public_ip  | 公网IP     |
	// | elastic_ip | 弹性公网IP |
	// example: elastic_ip
	Mode string `json:"mode"`
	// IP地址
	IpAddr string `json:"ip_addr"`
	// 绑定资源类型
	AssociateType string `json:"associate_type"`
	// 绑定资源Id
	AssociateId string `json:"associate_id"`
	// 带宽大小
	Bandwidth int `json:"bandwidth"`
	// 计费类型: 流量、带宽
	// example: bandwidth
	ChargeType string `json:"charge_type"`
	// 线路类型
	BgpType string `json:"bgp_type"`
	// 是否跟随主机删除而自动释放
	AutoDellocate *bool `json:"auto_dellocate,omitempty"`
}

// SExternalProject is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SExternalProject.
type SExternalProject struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	ExternalDomainId string `json:"external_domain_id"`
	// 归属云账号ID
	CloudaccountId string `json:"cloudaccount_id"`
}

// SFileSystem is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SFileSystem.
type SFileSystem struct {
	apis.SStatusInfrasResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SBillingResourceBase
	SCloudregionResourceBase
	SZoneResourceBase
	SDeletePreventableResourceBase
	// 文件系统类型
	// enmu: extreme, standard, cpfs
	FileSystemType string `json:"file_system_type"`
	// 存储类型
	// enmu: performance, capacity, standard, advance, advance_100, advance_200
	StorageType string `json:"storage_type"`
	// 协议类型
	// enum: NFS, SMB, cpfs
	Protocol string `json:"protocol"`
	// 容量, 单位Gb
	Capacity int64 `json:"capacity"`
	// 已使用容量, 单位Gb
	UsedCapacity int64 `json:"used_capacity"`
	// 最多支持挂载点数量, -1代表无限制
	MountTargetCountLimit int `json:"mount_target_count_limit"`
}

// SGlobalVpc is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SGlobalVpc.
type SGlobalVpc struct {
	apis.SEnabledStatusInfrasResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
}

// SGlobalVpcResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SGlobalVpcResourceBase.
type SGlobalVpcResourceBase struct {
	GlobalvpcId string `json:"globalvpc_id"`
}

// SGroup is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SGroup.
type SGroup struct {
	apis.SVirtualResourceBase
	SZoneResourceBase
	apis.SEnabledResourceBase
	// 服务类型
	ServiceType string `json:"service_type"`
	ParentId    string `json:"parent_id"`
	// 调度策略
	SchedStrategy string `json:"sched_strategy"`
	// the upper limit number of guests with this group in a host
	Granularity     int   `json:"granularity"`
	ForceDispersion *bool `json:"force_dispersion,omitempty"`
}

// SGroupJointsBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SGroupJointsBase.
type SGroupJointsBase struct {
	apis.SVirtualJointResourceBase
	GroupId string `json:"group_id"`
}

// SGroupResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SGroupResourceBase.
type SGroupResourceBase struct {
	// 实例组ID
	GroupId string `json:"group_id"`
}

// SGroupguest is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SGroupguest.
type SGroupguest struct {
	SGroupJointsBase
	Tag         string `json:"tag"`
	GuestId     string `json:"guest_id"`
	GuestStatus string `json:"guest_status"`
}

// SGroupnetwork is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SGroupnetwork.
type SGroupnetwork struct {
	SGroupJointsBase
	NetworkId string `json:"network_id"`
	IpAddr    string `json:"ip_addr"`
	Index     byte   `json:"index"`
	EipId     string `json:"eip_id"`
}

// SGuest is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SGuest.
type SGuest struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SBillingResourceBase
	SDeletePreventableResourceBase
	apis.SMultiArchResourceBase
	apis.SRecordChecksumResourceBase
	SHostnameResourceBase
	SHostResourceBase
	apis.SEncryptedResource
	// CPU大小
	VcpuCount int `json:"vcpu_count"`
	// 内存大小, 单位Mb
	VmemSize int `json:"vmem_size"`
	// 启动顺序
	BootOrder string `json:"boot_order"`
	// 关机操作类型
	// example: stop
	ShutdownBehavior string `json:"shutdown_behavior"`
	// 秘钥对Id
	KeypairId string `json:"keypair_id"`
	// 备份机所在宿主机Id
	BackupHostId string `json:"backup_host_id"`
	// 迁移或克隆的速度
	ProgressMbps float64 `json:"progress_mbps"`
	Vga          string  `json:"vga"`
	Vdi          string  `json:"vdi"`
	Machine      string  `json:"machine"`
	Bios         string  `json:"bios"`
	// 操作系统类型
	OsType   string `json:"os_type"`
	FlavorId string `json:"flavor_id"`
	// 安全组Id
	// example: default
	SecgrpId string `json:"secgrp_id"`
	// 管理员可见安全组Id
	AdminSecgrpId string `json:"admin_secgrp_id"`
	SrcIpCheck    *bool  `json:"src_ip_check,omitempty"`
	SrcMacCheck   *bool  `json:"src_mac_check,omitempty"`
	// 虚拟化技术
	// example: kvm
	Hypervisor string `json:"hypervisor"`
	// 套餐名称
	InstanceType     string `json:"instance_type"`
	SshableLastState *bool  `json:"sshable_last_state,omitempty"`
	IsDaemon         *bool  `json:"is_daemon,omitempty"`
}

// SGuestJointsBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SGuestJointsBase.
type SGuestJointsBase struct {
	apis.SVirtualJointResourceBase
	GuestId string `json:"guest_id"`
}

// SGuestTemplate is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SGuestTemplate.
type SGuestTemplate struct {
	apis.SSharableVirtualResourceBase
	SCloudregionResourceBase
	SVpcResourceBase
	// 虚拟机CPU数量
	VcpuCount int `json:"vcpu_count"`
	// 虚拟机内存大小（MB）
	VmemSize int `json:"vmem_size"`
	// 虚拟机操作系统类型
	// pattern:Linux|Windows|VMWare
	OsType string `json:"os_type"`
	// 镜像类型
	ImageType string `json:"image_type"`
	// 镜像ID
	ImageId string `json:"image_id"`
	// 虚拟机技术
	Hypervisor string `json:"hypervisor"`
	// 计费方式
	BillingType string `json:"billing_type"`
	// 其他配置信息
	Content jsonutils.JSONObject `json:"content"`
}

// SGuestTemplateResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SGuestTemplateResourceBase.
type SGuestTemplateResourceBase struct {
	// 主机模板ID
	GuestTemplateId string `json:"guest_template_id"`
}

// SGuestdisk is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SGuestdisk.
type SGuestdisk struct {
	SGuestJointsBase
	SDiskResourceBase
	ImagePath string `json:"image_path"`
	Driver    string `json:"driver"`
	// Column(VARCHAR(32, charset='ascii'), nullable=True)
	CacheMode string `json:"cache_mode"`
	// Column(VARCHAR(32, charset='ascii'), nullable=True)
	AioMode string `json:"aio_mode"`
	// Column(VARCHAR(32, charset='ascii'), nullable=True)
	Iops       int    `json:"iops"`
	Bps        int    `json:"bps"`
	Mountpoint string `json:"mountpoint"`
	Index      byte   `json:"index"`
}

// SGuestnetwork is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SGuestnetwork.
type SGuestnetwork struct {
	SGuestJointsBase
	NetworkId string `json:"network_id"`
	// MAC地址
	MacAddr string `json:"mac_addr"`
	// IPv4地址
	IpAddr string `json:"ip_addr"`
	// IPv6地址
	Ip6Addr string `json:"ip6_addr"`
	// 虚拟网卡驱动
	Driver string `json:"driver"`
	// 带宽限制，单位mbps
	BwLimit int `json:"bw_limit"`
	// 网卡序号
	Index byte `json:"index"`
	// 是否为虚拟接口（无IP）
	Virtual bool `json:"virtual"`
	// 虚拟网卡设备名称
	Ifname string `json:"ifname"`
	// bind配对网卡MAC地址
	TeamWith string `json:"team_with"`
	// IPv4映射地址，当子网属于私有云vpc的时候分配，用于访问外网
	MappedIpAddr string `json:"mapped_ip_addr"`
	// 网卡关联的Eip实例
	EipId string `json:"eip_id"`
}

// SGuestsecgroup is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SGuestsecgroup.
type SGuestsecgroup struct {
	SGuestJointsBase
	SSecurityGroupResourceBase
}

// SHost is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SHost.
type SHost struct {
	apis.SEnabledStatusInfrasResourceBase
	apis.SExternalizedResourceBase
	SZoneResourceBase
	SManagedResourceBase
	SBillingResourceBase
	SHostnameResourceBase
	// 机架
	Rack string `json:"rack"`
	// 机位
	Slots string `json:"slots"`
	// 管理口MAC
	AccessMac string `json:"access_mac"`
	// 管理口Ip地址
	AccessIp string `json:"access_ip"`
	// 管理地址
	ManagerUri string `json:"manager_uri"`
	// 系统信息
	SysInfo jsonutils.JSONObject `json:"sys_info"`
	// 物理机序列号信息
	SN string `json:"sn"`
	// CPU核数
	CpuCount int `json:"cpu_count"`
	// 物理CPU颗数
	NodeCount byte `json:"node_count"`
	// CPU描述信息
	CpuDesc string `json:"cpu_desc"`
	// CPU频率
	CpuMhz int `json:"cpu_mhz"`
	// CPU缓存大小,单位KB
	CpuCache int `json:"cpu_cache"`
	// 预留CPU大小
	CpuReserved int `json:"cpu_reserved"`
	// CPU超分比
	CpuCmtbound float32 `json:"cpu_cmtbound"`
	// CPUMicrocode
	CpuMicrocode string `json:"cpu_microcode"`
	// CPU架构
	CpuArchitecture string `json:"cpu_architecture"`
	// 内存大小,单位Mb
	MemSize int `json:"mem_size"`
	// 预留内存大小
	MemReserved int `json:"mem_reserved"`
	// 内存超分比
	MemCmtbound float32 `json:"mem_cmtbound"`
	// 存储大小,单位Mb
	StorageSize int `json:"storage_size"`
	// 存储类型
	StorageType string `json:"storage_type"`
	// 存储驱动类型
	StorageDriver string `json:"storage_driver"`
	// 存储详情
	StorageInfo jsonutils.JSONObject `json:"storage_info"`
	// IPMI地址
	IpmiIp string `json:"ipmi_ip"`
	// IPMI详情
	IpmiInfo jsonutils.JSONObject `json:"ipmi_info"`
	// 宿主机状态
	// example: online
	HostStatus string `json:"host_status"`
	// 宿主机类型
	HostType string `json:"host_type"`
	// host服务软件版本
	Version string `json:"version"`
	// OVN软件版本
	OvnVersion  string `json:"ovn_version"`
	IsBaremetal bool   `json:"is_baremetal"`
	// 是否处于维护状态
	IsMaintenance     bool   `json:"is_maintenance"`
	EnableHealthCheck bool   `json:"enable_health_check"`
	ResourceType      string `json:"resource_type"`
	RealExternalId    string `json:"real_external_id"`
	// 是否为导入的宿主机
	IsImport bool `json:"is_import"`
	// 是否允许PXE启动
	EnablePxeBoot *bool `json:"enable_pxe_boot,omitempty"`
	// 主机UUID
	Uuid string `json:"uuid"`
	// 主机启动模式, 可能值为PXE和ISO
	BootMode string `json:"boot_mode"`
	// IPv4地址，作为私有云vpc访问外网时的网关
	OvnMappedIpAddr string `json:"ovn_mapped_ip_addr"`
	// UEFI详情
	UefiInfo jsonutils.JSONObject `json:"uefi_info"`
}

// SHostJointsBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SHostJointsBase.
type SHostJointsBase struct {
	apis.SJointResourceBase
}

// SHostResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SHostResourceBase.
type SHostResourceBase struct {
	HostId string `json:"host_id"`
}

// SHostnameResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SHostnameResourceBase.
type SHostnameResourceBase struct {
	Hostname string `json:"hostname"`
}

// SHostnetwork is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SHostnetwork.
type SHostnetwork struct {
	SHostJointsBase
	// 宿主机ID
	BaremetalId string `json:"baremetal_id"`
	// 网络ID
	NetworkId string `json:"network_id"`
	// IP地址
	IpAddr string `json:"ip_addr"`
	// MAC地址
	MacAddr string `json:"mac_addr"`
}

// SHostschedtag is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SHostschedtag.
type SHostschedtag struct {
	SSchedtagJointsBase
	HostId string `json:"host_id"`
}

// SHoststorage is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SHoststorage.
type SHoststorage struct {
	SHostJointsBase
	// 宿主机Id
	HostId string `json:"host_id"`
	// 存储Id
	StorageId string `json:"storage_id"`
	// 挂载点
	MountPoint string `json:"mount_point"`
	// 是否是根分区
	IsRootPartition bool `json:"is_root_partition"`
	// 配置信息
	Config *jsonutils.JSONArray `json:"config"`
	// 真实容量大小
	RealCapacity int64 `json:"real_capacity"`
}

// SHostwire is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SHostwire.
type SHostwire struct {
	SHostJointsBase
	Bridge string `json:"bridge"`
	// 接口名称
	Interface string `json:"interface"`
	// 是否是主地址
	IsMaster bool `json:"is_master"`
	// MAC地址
	MacAddr string `json:"mac_addr"`
	// 宿主机Id
	HostId string `json:"host_id"`
	// 二层网络Id
	WireId string `json:"wire_id"`
}

// SHuaweiCachedLb is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SHuaweiCachedLb.
type SHuaweiCachedLb struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	BackendServerId string `json:"backend_server_id"`
	// 后端服务器 实例ID
	BackendId string `json:"backend_id"`
	// 本地loadbalancebackend id
	CachedBackendGroupId string `json:"cached_backend_group_id"`
}

// SHuaweiCachedLbbg is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SHuaweiCachedLbbg.
type SHuaweiCachedLbbg struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	LoadbalancerId string `json:"loadbalancer_id"`
	BackendGroupId string `json:"backend_group_id"`
	AssociatedId   string `json:"associated_id"`
	// 关联ID
	AssociatedType string `json:"associated_type"`
	// 关联类型， listener || rule
	ProtocolType string `json:"protocol_type"`
}

// SI18nResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SI18nResourceBase.
type SI18nResourceBase struct {
}

// SIPv6Gateway is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SIPv6Gateway.
type SIPv6Gateway struct {
	apis.SSharableVirtualResourceBase
	apis.SExternalizedResourceBase
	SVpcResourceBase
	InstanceType string `json:"instance_type"`
}

// SInstanceBackup is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SInstanceBackup.
type SInstanceBackup struct {
	apis.SVirtualResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	apis.SMultiArchResourceBase
	apis.SEncryptedResource
	BackupStorageId string `json:"backup_storage_id"`
	GuestId         string `json:"guest_id"`
	// 云主机配置 corresponds to api.ServerCreateInput
	ServerConfig jsonutils.JSONObject `json:"server_config"`
	// 云主机标签
	ServerMetadata jsonutils.JSONObject `json:"server_metadata"`
	// 安全组
	SecGroups jsonutils.JSONObject `json:"sec_groups"`
	// 秘钥Id
	KeypairId string `json:"keypair_id"`
	// 操作系统类型
	OsType string `json:"os_type"`
	// 套餐名称
	InstanceType string `json:"instance_type"`
	// 主机备份容量和
	SizeMb int `json:"size_mb"`
}

// SInstanceSnapshot is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SInstanceSnapshot.
type SInstanceSnapshot struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	apis.SMultiArchResourceBase
	apis.SEncryptedResource
	// 云主机Id
	GuestId string `json:"guest_id"`
	// 云主机配置
	ServerConfig jsonutils.JSONObject `json:"server_config"`
	// 云主机标签
	ServerMetadata jsonutils.JSONObject `json:"server_metadata"`
	// 是否自动删除
	AutoDelete bool `json:"auto_delete"`
	// 引用次数
	RefCount int `json:"ref_count"`
	// 安全组
	SecGroups jsonutils.JSONObject `json:"sec_groups"`
	// 秘钥Id
	KeypairId string `json:"keypair_id"`
	// 操作系统类型
	OsType string `json:"os_type"`
	// 套餐名称
	InstanceType string `json:"instance_type"`
	// 主机快照磁盘容量和
	SizeMb int `json:"size_mb"`
	// 镜像ID
	ImageId string `json:"image_id"`
	// 是否保存内存
	WithMemory bool `json:"with_memory"`
	// 内存文件大小
	MemorySizeMB int `json:"memory_size_mb"`
	// 内存文件所在宿主机
	MemoryFileHostId string `json:"memory_file_host_id"`
	// 内存文件路径
	MemoryFilePath string `json:"memory_file_path"`
	// 内存文件校验和
	MemoryFileChecksum string `json:"memory_file_checksum"`
}

// SInterVpcNetwork is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SInterVpcNetwork.
type SInterVpcNetwork struct {
	apis.SEnabledStatusInfrasResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
}

// SInterVpcNetworkResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SInterVpcNetworkResourceBase.
type SInterVpcNetworkResourceBase struct {
	InterVpcNetworkId string `json:"inter_vpc_network_id"`
}

// SInterVpcNetworkRouteSet is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SInterVpcNetworkRouteSet.
type SInterVpcNetworkRouteSet struct {
	apis.SEnabledStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SVpcResourceBase
	InterVpcNetworkId   string `json:"inter_vpc_network_id"`
	Cidr                string `json:"cidr"`
	ExtInstanceId       string `json:"ext_instance_id"`
	ExtInstanceType     string `json:"ext_instance_type"`
	ExtInstanceRegionId string `json:"ext_instance_region_id"`
}

// SInterVpcNetworkVpc is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SInterVpcNetworkVpc.
type SInterVpcNetworkVpc struct {
	apis.SJointResourceBase
	SInterVpcNetworkResourceBase
	VpcId string `json:"vpc_id"`
}

// SIsolatedDevice is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SIsolatedDevice.
type SIsolatedDevice struct {
	apis.SStandaloneResourceBase
	SHostResourceBase
	// # PCI / GPU-HPC / GPU-VGA / USB / NIC
	// 设备类型
	DevType string `json:"dev_type"`
	// # Specific device name read from lspci command, e.g. `Tesla K40m` ...
	Model string `json:"model"`
	// 云主机Id
	GuestId string `json:"guest_id"`
	// # pci address of `Bus:Device.Function` format, or usb bus address of `bus.addr`
	Addr           string `json:"addr"`
	VendorDeviceId string `json:"vendor_device_id"`
	// reserved memory size for isolated device
	ReservedMemory int `json:"reserved_memory"`
	// reserved cpu count for isolated device
	ReservedCpu int `json:"reserved_cpu"`
	// reserved storage size for isolated device
	ReservedStorage int `json:"reserved_storage"`
}

// SKafka is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SKafka.
type SKafka struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SBillingResourceBase
	SCloudregionResourceBase
	SDeletePreventableResourceBase
	// 版本
	Version string `json:"version"`
	// 套餐名称
	// example: elasticsearch.sn2ne.xlarge
	InstanceType string `json:"instance_type"`
	// 存储类型
	// example: local_ssd
	StorageType string `json:"storage_type"`
	// 存储大小
	// example: 1024
	DiskSizeGb int `json:"disk_size_gb"`
	// 带宽峰值
	// example: 1024
	BandwidthMb int `json:"bandwidth_mb"`
	// 消息保留时长
	MsgRetentionMinute int `json:"msg_retention_minute"`
	// 连接端点
	Endpoint  string `json:"endpoint"`
	VpcId     string `json:"vpc_id"`
	NetworkId string `json:"network_id"`
	// 可用区Id
	ZoneId string `json:"zone_id"`
	// 是否是多可用区部署
	IsMultiAz bool `json:"is_multi_az"`
}

// SKeypair is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SKeypair.
type SKeypair struct {
	apis.SUserResourceBase
	// 加密类型
	// example: RSA
	Scheme string `json:"scheme"`
	// 指纹信息
	// example: 1d:3a:83:4a:a1:f3:75:97:ec:d1:ef:f8:3f:a7:5d:9e
	Fingerprint string `json:"fingerprint"`
	// 私钥
	PrivateKey string `json:"private_key"`
	// 公钥
	PublicKey string `json:"public_key"`
}

// SKubeCluster is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SKubeCluster.
type SKubeCluster struct {
	apis.SEnabledStatusInfrasResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	// 本地KubeserverId
	ExternalClusterId string `json:"external_cluster_id"`
}

// SKubeNode is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SKubeNode.
type SKubeNode struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	CloudKubeNodePoolId string `json:"cloud_kube_node_pool_id"`
	CloudKubeClusterId  string `json:"cloud_kube_cluster_id"`
}

// SKubeNodePool is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SKubeNodePool.
type SKubeNodePool struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	CloudKubeClusterId string `json:"cloud_kube_cluster_id"`
}

// SLoadbalancer is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancer.
type SLoadbalancer struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	SDeletePreventableResourceBase
	// LB might optionally be in a VPC, vpc_id, manager_id, cloudregion_id
	SVpcResourceBase
	// zone_id
	SZoneResourceBase
	// optional network_id
	SNetworkResourceBase
	SLoadbalancerRateLimiter
	// 备可用区
	Zone1 string `json:"zone_1"`
	// IP地址
	Address string `json:"address"`
	// 地址类型
	AddressType string `json:"address_type"`
	// 网络类型
	NetworkType string `json:"network_type"`
	SLoadbalancerClusterResourceBase
	// 计费类型
	ChargeType string `json:"charge_type"`
	// 套餐名称
	LoadbalancerSpec string `json:"loadbalancer_spec"`
	// 默认后端服务器组Id
	BackendGroupId string `json:"backend_group_id"`
	// LB的其他配置信息
	LBInfo jsonutils.JSONObject `json:"lb_info"`
}

// SLoadbalancerAcl is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerAcl.
type SLoadbalancerAcl struct {
	apis.SSharableVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	AclEntries  *SLoadbalancerAclEntries `json:"acl_entries"`
	Fingerprint string                   `json:"fingerprint"`
}

// SLoadbalancerAclEntries is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerAclEntries.
type SLoadbalancerAclEntries []*SLoadbalancerAclEntry

// SLoadbalancerAclEntry is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerAclEntry.
type SLoadbalancerAclEntry struct {
	Cidr    string `json:"cidr"`
	Comment string `json:"comment"`
}

// SLoadbalancerAclResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerAclResourceBase.
type SLoadbalancerAclResourceBase struct {
	// 本地Acl ID
	AclId string `json:"acl_id"`
}

// SLoadbalancerAgent is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerAgent.
type SLoadbalancerAgent struct {
	apis.SStandaloneResourceBase
	SLoadbalancerClusterResourceBase
	Version string `json:"version"`
	IP      string `json:"ip"`
	HaState string `json:"ha_state"`
	// LB_HA_STATE_UNKNOWN
	HbLastSeen                time.Time                     `json:"hb_last_seen"`
	HbTimeout                 int                           `json:"hb_timeout"`
	Params                    *SLoadbalancerAgentParams     `json:"params"`
	Networks                  time.Time                     `json:"networks"`
	LoadbalancerNetworks      time.Time                     `json:"loadbalancer_networks"`
	Loadbalancers             time.Time                     `json:"loadbalancers"`
	LoadbalancerListeners     time.Time                     `json:"loadbalancer_listeners"`
	LoadbalancerListenerRules time.Time                     `json:"loadbalancer_listener_rules"`
	LoadbalancerBackendGroups time.Time                     `json:"loadbalancer_backend_groups"`
	LoadbalancerBackends      time.Time                     `json:"loadbalancer_backends"`
	LoadbalancerAcls          time.Time                     `json:"loadbalancer_acls"`
	LoadbalancerCertificates  time.Time                     `json:"loadbalancer_certificates"`
	Deployment                *SLoadbalancerAgentDeployment `json:"deployment"`
}

// SLoadbalancerAgentDeployment is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerAgentDeployment.
type SLoadbalancerAgentDeployment struct {
	Host                        string `json:"host"`
	AnsiblePlaybook             string `json:"ansible_playbook"`
	AnsiblePlaybookUndeployment string `json:"ansible_playbook_undeployment"`
}

// SLoadbalancerAgentParams is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerAgentParams.
type SLoadbalancerAgentParams struct {
	KeepalivedConfTmpl string `json:"keepalived_conf_tmpl"`
	HaproxyConfTmpl    string `json:"haproxy_conf_tmpl"`
	TelegrafConfTmpl   string `json:"telegraf_conf_tmpl"`
}

// SLoadbalancerAgentParamsHaproxy is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerAgentParamsHaproxy.
type SLoadbalancerAgentParamsHaproxy struct {
	GlobalLog      string `json:"global_log"`
	GlobalNbthread int    `json:"global_nbthread"`
	LogHttp        bool   `json:"log_http"`
	LogTcp         bool   `json:"log_tcp"`
	LogNormal      bool   `json:"log_normal"`
	TuneHttpMaxhdr int    `json:"tune_http_maxhdr"`
}

// SLoadbalancerAgentParamsTelegraf is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerAgentParamsTelegraf.
type SLoadbalancerAgentParamsTelegraf struct {
	InfluxDbOutputUrl       string `json:"influx_db_output_url"`
	InfluxDbOutputName      string `json:"influx_db_output_name"`
	InfluxDbOutputUnsafeSsl bool   `json:"influx_db_output_unsafe_ssl"`
	HaproxyInputInterval    int    `json:"haproxy_input_interval"`
}

// SLoadbalancerAgentParamsVrrp is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerAgentParamsVrrp.
type SLoadbalancerAgentParamsVrrp struct {
	Priority          int    `json:"priority"`
	VirtualRouterId   int    `json:"virtual_router_id"`
	GarpMasterRefresh int    `json:"garp_master_refresh"`
	Preempt           bool   `json:"preempt"`
	Interface         string `json:"interface"`
	AdvertInt         int    `json:"advert_int"`
	Pass              string `json:"pass"`
}

// SLoadbalancerBackend is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerBackend.
type SLoadbalancerBackend struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	// SManagedResourceBase
	// SCloudregionResourceBase
	SLoadbalancerBackendgroupResourceBase
	// BackendGroupId string `width:"36" charset:"ascii" nullable:"true" list:"user" create:"optional"`
	BackendId   string `json:"backend_id"`
	BackendType string `json:"backend_type"`
	BackendRole string `json:"backend_role"`
	Weight      int    `json:"weight"`
	Address     string `json:"address"`
	Port        int    `json:"port"`
	SendProxy   string `json:"send_proxy"`
	Ssl         string `json:"ssl"`
}

// SLoadbalancerBackendGroup is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerBackendGroup.
type SLoadbalancerBackendGroup struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SLoadbalancerResourceBase
	Type string `json:"type"`
}

// SLoadbalancerBackendgroupResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerBackendgroupResourceBase.
type SLoadbalancerBackendgroupResourceBase struct {
	// 负载均衡后端组ID
	BackendGroupId string `json:"backend_group_id"`
}

// SLoadbalancerCertificate is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerCertificate.
type SLoadbalancerCertificate struct {
	apis.SSharableVirtualResourceBase
	apis.SExternalizedResourceBase
	apis.SCertificateResourceBase
}

// SLoadbalancerCertificateResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerCertificateResourceBase.
type SLoadbalancerCertificateResourceBase struct {
	// 本地负载均衡证书ID
	CertificateId string `json:"certificate_id"`
}

// SLoadbalancerCluster is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerCluster.
type SLoadbalancerCluster struct {
	apis.SStandaloneResourceBase
	SZoneResourceBase
	SWireResourceBase
}

// SLoadbalancerClusterResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerClusterResourceBase.
type SLoadbalancerClusterResourceBase struct {
	// 归属LB集群
	ClusterId string `json:"cluster_id"`
}

// SLoadbalancerHTTPListener is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerHTTPListener.
type SLoadbalancerHTTPListener struct {
	StickySession string `json:"sticky_session"`
	// 会话保持开启状态 on|off
	StickySessionType string `json:"sticky_session_type"`
	// Cookie处理方式 insert(植入cookie)|server(重写cookie)
	StickySessionCookie string `json:"sticky_session_cookie"`
	// Cookie名称
	StickySessionCookieTimeout int  `json:"sticky_session_cookie_timeout"`
	XForwardedFor              bool `json:"xforwarded_for"`
	// 获取客户端真实IP
	Gzip bool `json:"gzip"`
}

// SLoadbalancerHTTPRateLimiter is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerHTTPRateLimiter.
type SLoadbalancerHTTPRateLimiter struct {
	HTTPRequestRate int `json:"http_request_rate"`
	// 限定监听接收请示速率
	HTTPRequestRatePerSrc int `json:"http_request_rate_per_src"`
}

// SLoadbalancerHTTPRedirect is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerHTTPRedirect.
type SLoadbalancerHTTPRedirect struct {
	Redirect string `json:"redirect"`
	// 跳转类型
	RedirectCode int `json:"redirect_code"`
	// 跳转HTTP code
	RedirectScheme string `json:"redirect_scheme"`
	// 跳转uri scheme
	RedirectHost string `json:"redirect_host"`
	// 跳转时变更Host
	RedirectPath string `json:"redirect_path"`
}

// SLoadbalancerHTTPSListener is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerHTTPSListener.
type SLoadbalancerHTTPSListener struct {
	SLoadbalancerCertificateResourceBase
	CachedCertificateId string `json:"cached_certificate_id"`
	TLSCipherPolicy     string `json:"tls_cipher_policy"`
	EnableHttp2         bool   `json:"enable_http2"`
}

// SLoadbalancerHealthCheck is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerHealthCheck.
type SLoadbalancerHealthCheck struct {
	HealthCheck string `json:"health_check"`
	// 健康检查开启状态 on|off
	HealthCheckType   string `json:"health_check_type"`
	HealthCheckDomain string `json:"health_check_domain"`
	// 健康检查域名 yunion.cn
	HealthCheckURI string `json:"health_check_uri"`
	// 健康检查路径 /
	HealthCheckHttpCode string `json:"health_check_http_code"`
	HealthCheckRise     int    `json:"health_check_rise"`
	//  健康检查健康阈值 3秒
	HealthCheckFall int `json:"health_check_fall"`
	//  健康检查不健康阈值 15秒
	HealthCheckTimeout int `json:"health_check_timeout"`
	// 健康检查超时时间 10秒
	HealthCheckInterval int    `json:"health_check_interval"`
	HealthCheckReq      string `json:"health_check_req"`
	// UDP监听健康检查的请求串
	HealthCheckExp string `json:"health_check_exp"`
}

// SLoadbalancerListener is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerListener.
type SLoadbalancerListener struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SLoadbalancerResourceBase
	ListenerType         string `json:"listener_type"`
	ListenerPort         int    `json:"listener_port"`
	BackendGroupId       string `json:"backend_group_id"`
	BackendServerPort    int    `json:"backend_server_port"`
	Scheduler            string `json:"scheduler"`
	SendProxy            string `json:"send_proxy"`
	ClientRequestTimeout int    `json:"client_request_timeout"`
	// 连接请求超时时间
	ClientIdleTimeout int `json:"client_idle_timeout"`
	// 连接空闲超时时间
	BackendConnectTimeout int `json:"backend_connect_timeout"`
	// 后端连接超时时间
	BackendIdleTimeout int    `json:"backend_idle_timeout"`
	AclStatus          string `json:"acl_status"`
	AclType            string `json:"acl_type"`
	SLoadbalancerAclResourceBase
	CachedAclId string `json:"cached_acl_id"`
	SLoadbalancerRateLimiter
	SLoadbalancerTCPListener
	SLoadbalancerUDPListener
	SLoadbalancerHTTPListener
	SLoadbalancerHTTPSListener
	SLoadbalancerHealthCheck
	SLoadbalancerHTTPRateLimiter
	SLoadbalancerHTTPRedirect
}

// SLoadbalancerListenerResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerListenerResourceBase.
type SLoadbalancerListenerResourceBase struct {
	// 负载均衡监听器ID
	ListenerId string `json:"listener_id"`
}

// SLoadbalancerListenerRule is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerListenerRule.
type SLoadbalancerListenerRule struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SLoadbalancerListenerResourceBase
	// 默认转发策略，目前只有aws用到其它云都是false
	IsDefault      bool   `json:"is_default"`
	BackendGroupId string `json:"backend_group_id"`
	Domain         string `json:"domain"`
	Path           string `json:"path"`
	Condition      string `json:"condition"`
	SLoadbalancerHealthCheck
	// 目前只有腾讯云HTTP、HTTPS类型的健康检查是和规则绑定的。
	SLoadbalancerHTTPRateLimiter
	SLoadbalancerHTTPRedirect
}

// SLoadbalancerNetwork is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerNetwork.
type SLoadbalancerNetwork struct {
	apis.SVirtualJointResourceBase
	LoadbalancerId string `json:"loadbalancer_id"`
	NetworkId      string `json:"network_id"`
	IpAddr         string `json:"ip_addr"`
	MacAddr        string `json:"mac_addr"`
}

// SLoadbalancerRateLimiter is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerRateLimiter.
type SLoadbalancerRateLimiter struct {
	EgressMbps int `json:"egress_mbps"`
}

// SLoadbalancerResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerResourceBase.
type SLoadbalancerResourceBase struct {
	// 负载均衡ID
	LoadbalancerId string `json:"loadbalancer_id"`
}

// SLoadbalancerTCPListener is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerTCPListener.
type SLoadbalancerTCPListener struct {
}

// SLoadbalancerUDPListener is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SLoadbalancerUDPListener.
type SLoadbalancerUDPListener struct {
}

// SManagedResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SManagedResourceBase.
type SManagedResourceBase struct {
	// 云订阅ID
	ManagerId string `json:"manager_id"`
}

// SMongoDB is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SMongoDB.
type SMongoDB struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SBillingResourceBase
	SCloudregionResourceBase
	SZoneResourceBase
	SDeletePreventableResourceBase
	// CPU数量
	// example: 1
	VcpuCount int `json:"vcpu_count"`
	// 内存大小
	// example: 1024
	VmemSizeMb int `json:"vmem_size_mb"`
	// 存储大小, 单位Mb
	// example: 10240
	DiskSizeMb int `json:"disk_size_mb"`
	// 端口
	// example: 3306
	Port int `json:"port"`
	// 实例类型
	// example: ha
	Category string `json:"category"`
	// 分片数量
	// example: 3
	ReplicationNum int `json:"replication_num"`
	// 实例IP地址
	IpAddr string `json:"ip_addr"`
	// 引擎
	// example: MySQL
	Engine string `json:"engine"`
	// 引擎版本
	// example: 5.7
	EngineVersion string `json:"engine_version"`
	// 套餐名称
	// example: mysql.x4.large.2c
	InstanceType string `json:"instance_type"`
	// 维护时间
	MaintainTime string `json:"maintain_time"`
	// 虚拟私有网络Id
	// example: ed20d84e-3158-41b1-870c-1725e412e8b6
	VpcId string `json:"vpc_id"`
	// 所属网络ID
	NetworkId string `json:"network_id"`
}

// SMountTarget is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SMountTarget.
type SMountTarget struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SVpcResourceBase
	SNetworkResourceBase
	SAccessGroupResourceBase
	NetworkType  string `json:"network_type"`
	DomainName   string `json:"domain_name"`
	FileSystemId string `json:"file_system_id"`
}

// SNasSku is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SNasSku.
type SNasSku struct {
	apis.SEnabledStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SCloudregionResourceBase
	PrepaidStatus string `json:"prepaid_status"`
	// 预付费资源状态   available|soldout
	PostpaidStatus string `json:"postpaid_status"`
	StorageType    string `json:"storage_type"`
	DiskSizeStep   int    `json:"disk_size_step"`
	// 步长
	MaxDiskSizeGb  int    `json:"max_disk_size_gb"`
	MinDiskSizeGb  int    `json:"min_disk_size_gb"`
	NetworkTypes   string `json:"network_types"`
	FileSystemType string `json:"file_system_type"`
	Protocol       string `json:"protocol"`
	Provider       string `json:"provider"`
	ZoneIds        string `json:"zone_ids"`
}

// SNatDEntry is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SNatDEntry.
type SNatDEntry struct {
	SNatEntry
	ExternalIP   string `json:"external_ip"`
	ExternalPort int    `json:"external_port"`
	InternalIP   string `json:"internal_ip"`
	InternalPort int    `json:"internal_port"`
	IpProtocol   string `json:"ip_protocol"`
}

// SNatEntry is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SNatEntry.
type SNatEntry struct {
	apis.SStatusInfrasResourceBase
	apis.SExternalizedResourceBase
	SNatgatewayResourceBase
}

// SNatGateway is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SNatGateway.
type SNatGateway struct {
	apis.SStatusInfrasResourceBase
	apis.SExternalizedResourceBase
	SBillingResourceBase
	SVpcResourceBase
	SDeletePreventableResourceBase
	NetworkId   string `json:"network_id"`
	IpAddr      string `json:"ip_addr"`
	BandwidthMb int    `json:"bandwidth_mb"`
	NatSpec     string `json:"nat_spec"`
}

// SNatSEntry is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SNatSEntry.
type SNatSEntry struct {
	SNatEntry
	SNetworkResourceBase
	IP         string `json:"ip"`
	SourceCIDR string `json:"source_cidr"`
}

// SNatSku is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SNatSku.
type SNatSku struct {
	apis.SEnabledStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SCloudregionResourceBase
	PrepaidStatus string `json:"prepaid_status"`
	// 预付费资源状态   available|soldout
	PostpaidStatus string `json:"postpaid_status"`
	Provider       string `json:"provider"`
	ZoneIds        string `json:"zone_ids"`
}

// SNatgatewayResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SNatgatewayResourceBase.
type SNatgatewayResourceBase struct {
	NatgatewayId string `json:"natgateway_id"`
}

// SNetwork is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SNetwork.
type SNetwork struct {
	apis.SSharableVirtualResourceBase
	apis.SExternalizedResourceBase
	SWireResourceBase
	IfnameHint string `json:"ifname_hint"`
	// 起始IP地址
	GuestIpStart string `json:"guest_ip_start"`
	// 结束IP地址
	GuestIpEnd string `json:"guest_ip_end"`
	// 掩码
	GuestIpMask byte `json:"guest_ip_mask"`
	// 网关地址
	GuestGateway string `json:"guest_gateway"`
	// DNS, allow multiple dns, seperated by ","
	GuestDns string `json:"guest_dns"`
	// allow multiple dhcp, seperated by ","
	GuestDhcp string `json:"guest_dhcp"`
	// allow mutiple ntp, seperated by ","
	GuestNtp      string `json:"guest_ntp"`
	GuestDomain   string `json:"guest_domain"`
	GuestIp6Start string `json:"guest_ip6_start"`
	GuestIp6End   string `json:"guest_ip6_end"`
	GuestIp6Mask  byte   `json:"guest_ip6_mask"`
	GuestGateway6 string `json:"guest_gateway6"`
	GuestDns6     string `json:"guest_dns6"`
	GuestDomain6  string `json:"guest_domain6"`
	VlanId        int    `json:"vlan_id"`
	// 服务器类型
	// example: server
	ServerType string `json:"server_type"`
	// 分配策略
	AllocPolicy        string `json:"alloc_policy"`
	AllocTimoutSeconds int    `json:"alloc_timout_seconds"`
	// 该网段是否用于自动分配IP地址，如果为false，则用户需要明确选择该网段，才会使用该网段分配IP，
	// 如果为true，则用户不指定网段时，则自动从该值为true的网络中选择一个分配地址
	IsAutoAlloc *bool `json:"is_auto_alloc,omitempty"`
	// 线路类型
	BgpType string `json:"bgp_type"`
}

// SNetworkAddress is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SNetworkAddress.
type SNetworkAddress struct {
	apis.SStandaloneAnonResourceBase
	Type       string `json:"type"`
	ParentType string `json:"parent_type"`
	ParentId   string `json:"parent_id"`
	SNetworkResourceBase
	IpAddr    string `json:"ip_addr"`
	SubCtrVid int    `json:"sub_ctr_vid"`
}

// SNetworkInterface is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SNetworkInterface.
type SNetworkInterface struct {
	apis.SStatusInfrasResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	// MAC地址
	Mac string `json:"mac"`
	// 绑定资源类型
	AssociateType string `json:"associate_type"`
	// 绑定资源Id
	AssociateId string `json:"associate_id"`
}

// SNetworkResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SNetworkResourceBase.
type SNetworkResourceBase struct {
	NetworkId string `json:"network_id"`
}

// SNetworkinterfacenetwork is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SNetworkinterfacenetwork.
type SNetworkinterfacenetwork struct {
	apis.SJointResourceBase
	Primary            bool   `json:"primary"`
	IpAddr             string `json:"ip_addr"`
	NetworkinterfaceId string `json:"networkinterface_id"`
	// Column(VARCHAR(36, charset='ascii'), nullable=False)
	NetworkId string `json:"network_id"`
}

// SNetworkschedtag is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SNetworkschedtag.
type SNetworkschedtag struct {
	SSchedtagJointsBase
	NetworkId string `json:"network_id"`
}

// SOpenstackCachedLb is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SOpenstackCachedLb.
type SOpenstackCachedLb struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	BackendServerId string `json:"backend_server_id"`
	// 后端服务器 实例ID
	BackendId string `json:"backend_id"`
	// 本地loadbalancebackend id
	CachedBackendGroupId string `json:"cached_backend_group_id"`
}

// SOpenstackCachedLbbg is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SOpenstackCachedLbbg.
type SOpenstackCachedLbbg struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	LoadbalancerId string `json:"loadbalancer_id"`
	BackendGroupId string `json:"backend_group_id"`
	AssociatedId   string `json:"associated_id"`
	// 关联ID
	AssociatedType string `json:"associated_type"`
	// 关联类型， listener || rule
	ProtocolType string `json:"protocol_type"`
}

// SPolicyAssignment is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SPolicyAssignment.
type SPolicyAssignment struct {
	apis.SDomainLevelResourceBase
	SPolicyDefinitionResourceBase
}

// SPolicyDefinition is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SPolicyDefinition.
type SPolicyDefinition struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	// 参数
	Parameters *jsonutils.JSONDict `json:"parameters"`
	// 条件
	Condition string `json:"condition"`
	// 类别
	Category string `json:"category"`
}

// SPolicyDefinitionResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SPolicyDefinitionResourceBase.
type SPolicyDefinitionResourceBase struct {
	// 策略Id
	PolicydefinitionId string `json:"policydefinition_id"`
}

// SProjectMapping is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SProjectMapping.
type SProjectMapping struct {
	apis.SEnabledStatusInfrasResourceBase
	Rules *MappingRules `json:"rules"`
}

// SProjectMappingResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SProjectMappingResourceBase.
type SProjectMappingResourceBase struct {
	ProjectMappingId string `json:"project_mapping_id"`
}

// SQcloudCachedLb is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SQcloudCachedLb.
type SQcloudCachedLb struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	BackendServerId string `json:"backend_server_id"`
	// 后端服务器 实例ID
	BackendId string `json:"backend_id"`
	// 本地loadbalancebackend id
	CachedBackendGroupId string `json:"cached_backend_group_id"`
}

// SQcloudCachedLbbg is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SQcloudCachedLbbg.
type SQcloudCachedLbbg struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	LoadbalancerId string `json:"loadbalancer_id"`
	BackendGroupId string `json:"backend_group_id"`
	AssociatedId   string `json:"associated_id"`
	// 关联ID
	AssociatedType string `json:"associated_type"`
}

// SReservedip is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SReservedip.
type SReservedip struct {
	apis.SResourceBase
	SNetworkResourceBase
	// 自增Id
	Id int64 `json:"id"`
	// IP地址
	IpAddr string `json:"ip_addr"`
	// 预留原因或描述
	Notes string `json:"notes"`
	// 过期时间
	ExpiredAt time.Time `json:"expired_at"`
	// 状态
	Status string `json:"status"`
}

// SRouteTable is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SRouteTable.
type SRouteTable struct {
	apis.SStatusInfrasResourceBase
	apis.SExternalizedResourceBase
	SVpcResourceBase
	Type   string   `json:"type"`
	Routes *SRoutes `json:"routes"`
}

// SRouteTableAssociation is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SRouteTableAssociation.
type SRouteTableAssociation struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SRouteTableResourceBase
	AssociationType         string `json:"association_type"`
	AssociatedResourceId    string `json:"associated_resource_id"`
	ExtAssociatedResourceId string `json:"ext_associated_resource_id"`
}

// SRouteTableResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SRouteTableResourceBase.
type SRouteTableResourceBase struct {
	RouteTableId string `json:"route_table_id"`
}

// SRouteTableRouteSet is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SRouteTableRouteSet.
type SRouteTableRouteSet struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SRouteTableResourceBase
	Type         string `json:"type"`
	Cidr         string `json:"cidr"`
	NextHopType  string `json:"next_hop_type"`
	NextHopId    string `json:"next_hop_id"`
	ExtNextHopId string `json:"ext_next_hop_id"`
}

// SScalingActivity is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SScalingActivity.
type SScalingActivity struct {
	apis.SStatusStandaloneResourceBase
	SScalingGroupResourceBase
	InstanceNumber int `json:"instance_number"`
	// 起因描述
	TriggerDesc string `json:"trigger_desc"`
	// 行为描述
	ActionDesc string    `json:"action_desc"`
	StartTime  time.Time `json:"start_time"`
	EndTime    time.Time `json:"end_time"`
	Reason     string    `json:"reason"`
}

// SScalingAlarm is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SScalingAlarm.
type SScalingAlarm struct {
	apis.SStandaloneResourceBase
	SScalingPolicyBase
	// ID of alarm config in alarm service
	AlarmId string `json:"alarm_id"`
	// Trigger when the cumulative count is reached
	Cumulate  int    `json:"cumulate"`
	Cycle     int    `json:"cycle"`
	Indicator string `json:"indicator"`
	// Wrapper instruct how to calculate collective data based on individual data
	Wrapper  string  `json:"wrapper"`
	Operator string  `json:"operator"`
	Value    float64 `json:"value"`
	// Real-time cumulate number
	RealCumulate int `json:"real_cumulate"`
}

// SScalingGroup is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SScalingGroup.
type SScalingGroup struct {
	apis.SVirtualResourceBase
	SCloudregionResourceBase
	SVpcResourceBase
	SLoadbalancerBackendgroupResourceBase
	// GuestGroupId represent the guest gropu related to this scaling group.
	// Every scaling group will have only one guest group related to itself.
	SGroupResourceBase
	SGuestTemplateResourceBase
	apis.SEnabledResourceBase
	Hypervisor        string `json:"hypervisor"`
	MinInstanceNumber int    `json:"min_instance_number"`
	MaxInstanceNumber int    `json:"max_instance_number"`
	// DesireInstanceNumber represent the number of instances that should exist in the scaling group.
	// Scaling controller will monitor and ensure this in real time.
	// Scaling activities triggered by various policies will also modify this value.
	// This value should between MinInstanceNumber and MaxInstanceNumber
	DesireInstanceNumber int `json:"desire_instance_number"`
	// ExpansionPrinciple represent the principle when creating new instance to join in.
	ExpansionPrinciple string `json:"expansion_principle"`
	// ShrinkPrinciple represent the principle when removing instance from scaling group.
	ShrinkPrinciple           string `json:"shrink_principle"`
	HealthCheckMode           string `json:"health_check_mode"`
	HealthCheckCycle          int    `json:"health_check_cycle"`
	HealthCheckGov            int    `json:"health_check_gov"`
	LoadbalancerBackendPort   int    `json:"loadbalancer_backend_port"`
	LoadbalancerBackendWeight int    `json:"loadbalancer_backend_weight"`
}

// SScalingGroupGuest is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SScalingGroupGuest.
type SScalingGroupGuest struct {
	SGuestJointsBase
	ScalingGroupId string `json:"scaling_group_id"`
	GuestStatus    string `json:"guest_status"`
	Manual         *bool  `json:"manual,omitempty"`
}

// SScalingGroupNetwork is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SScalingGroupNetwork.
type SScalingGroupNetwork struct {
	apis.SVirtualJointResourceBase
	ScalingGroupId string `json:"scaling_group_id"`
	NetworkId      string `json:"network_id"`
}

// SScalingGroupResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SScalingGroupResourceBase.
type SScalingGroupResourceBase struct {
	// ScalingGroupId
	ScalingGroupId string `json:"scaling_group_id"`
}

// SScalingPolicy is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SScalingPolicy.
type SScalingPolicy struct {
	apis.SVirtualResourceBase
	SScalingGroupResourceBase
	apis.SEnabledResourceBase
	TriggerType string `json:"trigger_type"`
	TriggerId   string `json:"trigger_id"`
	// Action of scaling activity
	Action string `json:"action"`
	Number int    `json:"number"`
	// Unit of Number
	Unit string `json:"unit"`
	// Scaling activity triggered by alarms will be rejected during this period about CoolingTime
	CoolingTime int `json:"cooling_time"`
}

// SScalingPolicyBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SScalingPolicyBase.
type SScalingPolicyBase struct {
	ScalingPolicyId string `json:"scaling_policy_id"`
}

// SScalingTimer is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SScalingTimer.
type SScalingTimer struct {
	apis.SStandaloneResourceBase
	SScalingPolicyBase
	STimer
}

// SSchedpolicy is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SSchedpolicy.
type SSchedpolicy struct {
	apis.SStandaloneResourceBase
	SSchedtagResourceBase
	Condition string `json:"condition"`
	Strategy  string `json:"strategy"`
	Enabled   *bool  `json:"enabled,omitempty"`
}

// SSchedtag is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SSchedtag.
type SSchedtag struct {
	apis.SStandaloneResourceBase
	apis.SScopedResourceBase
	DefaultStrategy string `json:"default_strategy"`
	// Column(VARCHAR(16, charset='ascii'), nullable=True, default='')
	ResourceType string `json:"resource_type"`
}

// SSchedtagJointsBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SSchedtagJointsBase.
type SSchedtagJointsBase struct {
	apis.SJointResourceBase
	SchedtagId string `json:"schedtag_id"`
}

// SSchedtagResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SSchedtagResourceBase.
type SSchedtagResourceBase struct {
	// 归属调度标签ID
	SchedtagId string `json:"schedtag_id"`
}

// SSecurityGroup is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SSecurityGroup.
type SSecurityGroup struct {
	apis.SSharableVirtualResourceBase
	IsDirty bool `json:"is_dirty"`
}

// SSecurityGroupCache is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SSecurityGroupCache.
type SSecurityGroupCache struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SCloudregionResourceBase
	SManagedResourceBase
	SSecurityGroupResourceBase
	// 被其他安全组引用的次数
	ReferenceCount int `json:"reference_count"`
	// 虚拟私有网络外部Id
	VpcId             string `json:"vpc_id"`
	ExternalProjectId string `json:"external_project_id"`
}

// SSecurityGroupResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SSecurityGroupResourceBase.
type SSecurityGroupResourceBase struct {
	// 本地安全组ID
	SecgroupId string `json:"secgroup_id"`
}

// SSecurityGroupRule is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SSecurityGroupRule.
type SSecurityGroupRule struct {
	apis.SResourceBase
	SSecurityGroupResourceBase
	Id             string `json:"id"`
	Priority       int64  `json:"priority"`
	Protocol       string `json:"protocol"`
	Ports          string `json:"ports"`
	Direction      string `json:"direction"`
	CIDR           string `json:"cidr"`
	Action         string `json:"action"`
	Description    string `json:"description"`
	PeerSecgroupId string `json:"peer_secgroup_id"`
}

// SServerSku is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SServerSku.
type SServerSku struct {
	apis.SEnabledStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SCloudregionResourceBase
	SZoneResourceBase
	// SkuId       string `width:"64" charset:"ascii" nullable:"false" list:"user" create:"admin_required"`                 // x2.large
	InstanceTypeFamily string `json:"instance_type_family"`
	// x2
	InstanceTypeCategory string `json:"instance_type_category"`
	// 通用型
	LocalCategory string `json:"local_category"`
	PrepaidStatus string `json:"prepaid_status"`
	// 预付费资源状态   available|soldout
	PostpaidStatus string `json:"postpaid_status"`
	CpuArch        string `json:"cpu_arch"`
	// CPU 架构 x86|xarm
	CpuCoreCount     int    `json:"cpu_core_count"`
	MemorySizeMB     int    `json:"memory_size_mb"`
	OsName           string `json:"os_name"`
	SysDiskResizable *bool  `json:"sys_disk_resizable,omitempty"`
	SysDiskType      string `json:"sys_disk_type"`
	SysDiskMinSizeGB int    `json:"sys_disk_min_size_gb"`
	// not required。 windows比较新的版本都是50G左右。
	SysDiskMaxSizeGB   int    `json:"sys_disk_max_size_gb"`
	AttachedDiskType   string `json:"attached_disk_type"`
	AttachedDiskSizeGB int    `json:"attached_disk_size_gb"`
	AttachedDiskCount  int    `json:"attached_disk_count"`
	DataDiskTypes      string `json:"data_disk_types"`
	DataDiskMaxCount   int    `json:"data_disk_max_count"`
	NicType            string `json:"nic_type"`
	NicMaxCount        int    `json:"nic_max_count"`
	GpuAttachable      *bool  `json:"gpu_attachable,omitempty"`
	GpuSpec            string `json:"gpu_spec"`
	GpuCount           int    `json:"gpu_count"`
	GpuMaxCount        int    `json:"gpu_max_count"`
	Provider           string `json:"provider"`
}

// SServiceCatalog is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SServiceCatalog.
type SServiceCatalog struct {
	apis.SSharableVirtualResourceBase
	IconUrl         string `json:"icon_url"`
	GuestTemplateID string `json:"guest_template_id"`
}

// SSnapshot is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SSnapshot.
type SSnapshot struct {
	apis.SVirtualResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	apis.SMultiArchResourceBase
	apis.SEncryptedResource
	// 磁盘Id
	DiskId string `json:"disk_id"`
	// Only onecloud has StorageId
	StorageId string `json:"storage_id"`
	CreatedBy string `json:"created_by"`
	Location  string `json:"location"`
	// 快照大小,单位Mb
	Size        int    `json:"size"`
	OutOfChain  bool   `json:"out_of_chain"`
	FakeDeleted bool   `json:"fake_deleted"`
	DiskType    string `json:"disk_type"`
	// 操作系统类型
	OsType string `json:"os_type"`
	// create disk from snapshot, snapshot as disk backing file
	RefCount      int       `json:"ref_count"`
	BackingDiskId string    `json:"backing_disk_id"`
	ExpiredAt     time.Time `json:"expired_at"`
}

// SSnapshotPolicy is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SSnapshotPolicy.
type SSnapshotPolicy struct {
	apis.SVirtualResourceBase
	RetentionDays int `json:"retention_days"`
	// 1~7, 1 is Monday
	RepeatWeekdays byte `json:"repeat_weekdays"`
	// 0~23
	TimePoints  uint32 `json:"time_points"`
	IsActivated *bool  `json:"is_activated,omitempty"`
}

// SSnapshotPolicyCache is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SSnapshotPolicyCache.
type SSnapshotPolicyCache struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SCloudregionResourceBase
	SManagedResourceBase
	SSnapshotPolicyResourceBase
}

// SSnapshotPolicyDisk is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SSnapshotPolicyDisk.
type SSnapshotPolicyDisk struct {
	apis.SVirtualJointResourceBase
	SSnapshotPolicyResourceBase
	SDiskResourceBase
	Status string `json:"status"`
}

// SSnapshotPolicyResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SSnapshotPolicyResourceBase.
type SSnapshotPolicyResourceBase struct {
	// 本地快照策略ID
	SnapshotpolicyId string `json:"snapshotpolicy_id"`
}

// SStorage is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SStorage.
type SStorage struct {
	apis.SEnabledStatusInfrasResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SZoneResourceBase
	// 容量大小,单位Mb
	Capacity int64 `json:"capacity"`
	// 实际容量大小，单位Mb
	// we always expect actual capacity great or equal than zero, otherwise something wrong
	ActualCapacityUsed int64 `json:"actual_capacity_used"`
	// 预留容量大小
	Reserved int64 `json:"reserved"`
	// 存储类型
	// example: local
	StorageType string `json:"storage_type"`
	// 介质类型
	// example: ssd
	MediumType string `json:"medium_type"`
	// 超售比
	Cmtbound float32 `json:"cmtbound"`
	// 存储配置信息
	StorageConf jsonutils.JSONObject `json:"storage_conf"`
	// 存储缓存Id
	StoragecacheId string `json:"storagecache_id"`
	// indicating whether system disk can be allocated in this storage
	// 是否可以用作系统盘存储
	// example: true
	IsSysDiskStore *bool `json:"is_sys_disk_store,omitempty"`
}

// SStorageResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SStorageResourceBase.
type SStorageResourceBase struct {
	StorageId string `json:"storage_id"`
}

// SStoragecache is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SStoragecache.
type SStoragecache struct {
	apis.SStandaloneResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	// 镜像存储地址
	Path string `json:"path"`
}

// SStoragecacheResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SStoragecacheResourceBase.
type SStoragecacheResourceBase struct {
	// 存储缓存Id
	StoragecacheId string `json:"storagecache_id"`
}

// SStoragecachedimage is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SStoragecachedimage.
type SStoragecachedimage struct {
	apis.SJointResourceBase
	apis.SExternalizedResourceBase
	SStoragecacheResourceBase
	// 镜像缓存Id
	CachedimageId string `json:"cachedimage_id"`
	// 镜像状态
	Status string `json:"status"`
	Path   string `json:"path"`
	// 上次下载时间
	LastDownload time.Time `json:"last_download"`
	// 下载引用次数
	DownloadRefcnt int `json:"download_refcnt"`
}

// SStorageschedtag is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SStorageschedtag.
type SStorageschedtag struct {
	SSchedtagJointsBase
	StorageId string `json:"storage_id"`
}

// SSyncableBaseResource is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SSyncableBaseResource.
type SSyncableBaseResource struct {
	SyncStatus string    `json:"sync_status"`
	LastSync   time.Time `json:"last_sync"`
	// = Column(DateTime, nullable=True)
	LastSyncEndAt time.Time `json:"last_sync_end_at"`
}

// STimer is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.STimer.
type STimer struct {
	// Cycle type
	Type string `json:"type"`
	// 0-59
	Minute int `json:"minute"`
	// 0-23
	Hour int `json:"hour"`
	// 0-7 1 is Monday 0 is unlimited
	WeekDays byte `json:"week_days"`
	// 0-31 0 is unlimited
	MonthDays uint32 `json:"month_days"`
	IsExpired bool   `json:"is_expired"`
}

// SVpc is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SVpc.
type SVpc struct {
	apis.SEnabledStatusInfrasResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	SGlobalVpcResourceBase
	// 是否是默认VPC
	// example: true
	IsDefault bool `json:"is_default"`
	// CIDR地址段
	// example: 192.168.222.0/24
	CidrBlock string `json:"cidr_block"`
	// Vpc外网访问模式
	ExternalAccessMode string `json:"external_access_mode"`
	// Can it be connected directly
	Direct bool `json:"direct"`
}

// SVpcPeeringConnection is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SVpcPeeringConnection.
type SVpcPeeringConnection struct {
	apis.SEnabledStatusInfrasResourceBase
	apis.SExternalizedResourceBase
	SVpcResourceBase
	ExtPeerVpcId     string `json:"ext_peer_vpc_id"`
	ExtPeerAccountId string `json:"ext_peer_account_id"`
	PeerVpcId        string `json:"peer_vpc_id"`
	PeerAccountId    string `json:"peer_account_id"`
	Bandwidth        int    `json:"bandwidth"`
}

// SVpcResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SVpcResourceBase.
type SVpcResourceBase struct {
	VpcId string `json:"vpc_id"`
}

// SWafIPSet is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SWafIPSet.
type SWafIPSet struct {
	apis.SStatusInfrasResourceBase
	Addresses *cloudprovider.WafAddresses `json:"addresses"`
}

// SWafIPSetCache is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SWafIPSetCache.
type SWafIPSetCache struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	Type       string `json:"type"`
	WafIPSetId string `json:"waf_ip_set_id"`
}

// SWafInstance is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SWafInstance.
type SWafInstance struct {
	apis.SEnabledStatusInfrasResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	Type          string                       `json:"type"`
	DefaultAction *cloudprovider.DefaultAction `json:"default_action"`
}

// SWafRegexSet is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SWafRegexSet.
type SWafRegexSet struct {
	apis.SStatusInfrasResourceBase
	RegexPatterns *cloudprovider.WafRegexPatterns `json:"regex_patterns"`
}

// SWafRegexSetCache is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SWafRegexSetCache.
type SWafRegexSetCache struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	Type          string `json:"type"`
	WafRegexSetId string `json:"waf_regex_set_id"`
}

// SWafRule is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SWafRule.
type SWafRule struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	// 规则优先级
	Priority int `json:"priority"`
	// 规则默认行为
	Action *cloudprovider.DefaultAction `json:"action"`
	// 条件
	StatementConditon string `json:"statement_conditon"`
	// 规则组的id
	WafRuleGroupId string `json:"waf_rule_group_id"`
	// 所属waf实例id
	WafInstanceId string `json:"waf_instance_id"`
}

// SWafRuleGroup is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SWafRuleGroup.
type SWafRuleGroup struct {
	apis.SStatusInfrasResourceBase
	apis.SExternalizedResourceBase
	// 支持的WAF类型,仅is_system=true时有效
	WafType  string `json:"waf_type"`
	Provider string `json:"provider"`
	CloudEnv string `json:"cloud_env"`
	IsSystem bool   `json:"is_system"`
}

// SWafRuleGroupCache is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SWafRuleGroupCache.
type SWafRuleGroupCache struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SManagedResourceBase
	SCloudregionResourceBase
	Type           string `json:"type"`
	WafRuleGroupId string `json:"waf_rule_group_id"`
}

// SWafRuleStatement is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SWafRuleStatement.
type SWafRuleStatement struct {
	apis.SResourceBase
	Id string `json:"id"`
	cloudprovider.SWafStatement
	WafRuleId string `json:"waf_rule_id"`
}

// SWire is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SWire.
type SWire struct {
	apis.SStatusInfrasResourceBase
	apis.SExternalizedResourceBase
	SVpcResourceBase
	SZoneResourceBase
	// 带宽大小, 单位Mbps
	// example: 1000
	Bandwidth int `json:"bandwidth"`
	// MTU
	// example: 1500
	Mtu int `json:"mtu"`
	// swagger:ignore
	ScheduleRank int `json:"schedule_rank"`
}

// SWireResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SWireResourceBase.
type SWireResourceBase struct {
	// 二层网络ID
	WireId string `json:"wire_id"`
}

// SZone is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SZone.
type SZone struct {
	apis.SStatusStandaloneResourceBase
	apis.SExternalizedResourceBase
	SI18nResourceBase
	SCloudregionResourceBase
	Location   string `json:"location"`
	Contacts   string `json:"contacts"`
	NameCn     string `json:"name_cn"`
	ManagerUri string `json:"manager_uri"`
}

// SZoneResourceBase is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SZoneResourceBase.
type SZoneResourceBase struct {
	ZoneId string `json:"zone_id"`
}

// SZoneschedtag is an autogenerated struct via yunion.io/x/onecloud/pkg/compute/models.SZoneschedtag.
type SZoneschedtag struct {
	SSchedtagJointsBase
	SZoneResourceBase
}
