// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by model-api-gen. DO NOT EDIT.

package image

import (
	"yunion.io/x/onecloud/pkg/apis"
)

// SGuestImage is an autogenerated struct via yunion.io/x/onecloud/pkg/image/models.SGuestImage.
type SGuestImage struct {
	apis.SSharableVirtualResourceBase
	apis.SMultiArchResourceBase
	apis.SEncryptedResource
	Protected *bool `json:"protected,omitempty"`
}

// SGuestImageJoint is an autogenerated struct via yunion.io/x/onecloud/pkg/image/models.SGuestImageJoint.
type SGuestImageJoint struct {
	apis.SJointResourceBase
	GuestImageId string `json:"guest_image_id"`
	ImageId      string `json:"image_id"`
}

// SImage is an autogenerated struct via yunion.io/x/onecloud/pkg/image/models.SImage.
type SImage struct {
	apis.SSharableVirtualResourceBase
	apis.SMultiArchResourceBase
	apis.SEncryptedResource
	// 镜像大小, 单位Byte
	Size int64 `json:"size"`
	// 存储地址
	Location string `json:"location"`
	// 镜像格式
	DiskFormat string `json:"disk_format"`
	// 校验和
	Checksum string `json:"checksum"`
	FastHash string `json:"fast_hash"`
	// 用户Id
	Owner string `json:"owner"`
	// 最小系统盘要求
	MinDiskMB int32 `json:"min_disk"`
	// 最小内存要求
	MinRamMB int32 `json:"min_ram"`
	// 是否有删除保护
	Protected *bool `json:"protected,omitempty"`
	// 是否是标准镜像
	IsStandard *bool `json:"is_standard,omitempty"`
	// 是否是主机镜像
	IsGuestImage *bool `json:"is_guest_image,omitempty"`
	// 是否是数据盘镜像
	IsData *bool `json:"is_data,omitempty"`
	// image copy from url, save origin checksum before probe
	// 从镜像时长导入的镜像校验和
	OssChecksum string `json:"oss_checksum"`
	// 加密状态, "",encrypting,encrypted
	EncryptStatus string `json:"encrypt_status"`
}

// SImageMember is an autogenerated struct via yunion.io/x/onecloud/pkg/image/models.SImageMember.
type SImageMember struct {
	SImagePeripheral
	Member   string `json:"member"`
	CanShare bool   `json:"can_share"`
}

// SImagePeripheral is an autogenerated struct via yunion.io/x/onecloud/pkg/image/models.SImagePeripheral.
type SImagePeripheral struct {
	apis.SResourceBase
	Id      int    `json:"id"`
	ImageId string `json:"image_id"`
}

// SImageProperty is an autogenerated struct via yunion.io/x/onecloud/pkg/image/models.SImageProperty.
type SImageProperty struct {
	SImagePeripheral
	Name  string `json:"name"`
	Value string `json:"value"`
}

// SImageSubformat is an autogenerated struct via yunion.io/x/onecloud/pkg/image/models.SImageSubformat.
type SImageSubformat struct {
	SImagePeripheral
	Format          string `json:"format"`
	Size            int64  `json:"size"`
	Location        string `json:"location"`
	Checksum        string `json:"checksum"`
	FastHash        string `json:"fast_hash"`
	Status          string `json:"status"`
	TorrentSize     int64  `json:"torrent_size"`
	TorrentLocation string `json:"torrent_location"`
	TorrentChecksum string `json:"torrent_checksum"`
	TorrentStatus   string `json:"torrent_status"`
}

// SImageTag is an autogenerated struct via yunion.io/x/onecloud/pkg/image/models.SImageTag.
type SImageTag struct {
	SImagePeripheral
	Value string `json:"value"`
}
