// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by model-api-gen. DO NOT EDIT.

package notify

import (
	time "time"

	jsonutils "yunion.io/x/jsonutils"

	"yunion.io/x/onecloud/pkg/apis"
)

// SConfig is an autogenerated struct via yunion.io/x/onecloud/pkg/notify/models.SConfig.
type SConfig struct {
	apis.SStandaloneResourceBase
	apis.SDomainizedResourceBase
	Type        string               `json:"type"`
	Content     jsonutils.JSONObject `json:"content"`
	Attribution string               `json:"attribution"`
}

// SEvent is an autogenerated struct via yunion.io/x/onecloud/pkg/notify/models.SEvent.
type SEvent struct {
	apis.SStandaloneAnonResourceBase
	Message     string `json:"message"`
	Event       string `json:"event"`
	AdvanceDays int    `json:"advance_days"`
	TopicId     string `json:"topic_id"`
}

// SNotification is an autogenerated struct via yunion.io/x/onecloud/pkg/notify/models.SNotification.
type SNotification struct {
	apis.SStatusStandaloneResourceBase
	ContactType string `json:"contact_type"`
	// swagger:ignore
	Topic    string `json:"topic"`
	Priority string `json:"priority"`
	// swagger:ignore
	Message    string    `json:"message"`
	ReceivedAt time.Time `json:"received_at"`
	EventId    string    `json:"event_id"`
	SendTimes  int       `json:"send_times"`
	Tag        string    `json:"tag"`
}

// SReceiver is an autogenerated struct via yunion.io/x/onecloud/pkg/notify/models.SReceiver.
type SReceiver struct {
	apis.SStatusStandaloneResourceBase
	apis.SDomainizedResourceBase
	apis.SEnabledResourceBase
	Email string `json:"email"`
	// swagger:ignore
	Mobile string `json:"mobile"`
	Lang   string `json:"lang"`
	// swagger:ignore
	EnabledEmail *bool `json:"enabled_email,omitempty"`
	// swagger:ignore
	VerifiedEmail *bool `json:"verified_email,omitempty"`
	// swagger:ignore
	EnabledMobile *bool `json:"enabled_mobile,omitempty"`
	// swagger:ignore
	VerifiedMobile *bool `json:"verified_mobile,omitempty"`
}

// SRobot is an autogenerated struct via yunion.io/x/onecloud/pkg/notify/models.SRobot.
type SRobot struct {
	apis.SSharableVirtualResourceBase
	apis.SEnabledResourceBase
	Type    string `json:"type"`
	Address string `json:"address"`
	Lang    string `json:"lang"`
}

// SSubscriber is an autogenerated struct via yunion.io/x/onecloud/pkg/notify/models.SSubscriber.
type SSubscriber struct {
	apis.SStandaloneAnonResourceBase
	apis.SEnabledResourceBase
	TopicID                 string `json:"topic_id"`
	Type                    string `json:"type"`
	Identification          string `json:"identification"`
	RoleScope               string `json:"role_scope"`
	ResourceScope           string `json:"resource_scope"`
	ResourceAttributionId   string `json:"resource_attribution_id"`
	ResourceAttributionName string `json:"resource_attribution_name"`
	Scope                   string `json:"scope"`
	DomainId                string `json:"domain_id"`
}

// SSubscriberDis is an autogenerated struct via yunion.io/x/onecloud/pkg/notify/models.SSubscriberDis.
type SSubscriberDis struct {
	SSubscriber
	ReceiverName string `json:"receiver_name"`
	RoleName     string `json:"role_name"`
}

// SSubscriberReceiver is an autogenerated struct via yunion.io/x/onecloud/pkg/notify/models.SSubscriberReceiver.
type SSubscriberReceiver struct {
	apis.SJointResourceBase
	SubscriberId string `json:"subscriber_id"`
	ReceiverId   string `json:"receiver_id"`
}

// STemplate is an autogenerated struct via yunion.io/x/onecloud/pkg/notify/models.STemplate.
type STemplate struct {
	apis.SStandaloneAnonResourceBase
	ContactType string `json:"contact_type"`
	Topic       string `json:"topic"`
	// title | content | remote
	TemplateType string `json:"template_type"`
	Content      string `json:"content"`
	Lang         string `json:"lang"`
	Example      string `json:"example"`
}

// STopic is an autogenerated struct via yunion.io/x/onecloud/pkg/notify/models.STopic.
type STopic struct {
	apis.SStandaloneResourceBase
	apis.SEnabledResourceBase
	Type              string `json:"type"`
	Resources         uint64 `json:"resources"`
	Actions           uint32 `json:"actions"`
	Results           byte   `json:"results"`
	AdvanceDays       int    `json:"advance_days"`
	WebconsoleDisable *bool  `json:"webconsole_disable,omitempty"`
}
