// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by model-api-gen. DO NOT EDIT.

package scheduledtask

import (
	time "time"

	"yunion.io/x/onecloud/pkg/apis"
)

// SScheduledTask is an autogenerated struct via yunion.io/x/onecloud/pkg/scheduledtask/models.SScheduledTask.
type SScheduledTask struct {
	apis.SVirtualResourceBase
	apis.SEnabledResourceBase
	ScheduledType string `json:"scheduled_type"`
	STimer
	ResourceType string `json:"resource_type"`
	Operation    string `json:"operation"`
	LabelType    string `json:"label_type"`
}

// SScheduledTaskActivity is an autogenerated struct via yunion.io/x/onecloud/pkg/scheduledtask/models.SScheduledTaskActivity.
type SScheduledTaskActivity struct {
	apis.SStatusStandaloneResourceBase
	ScheduledTaskId string    `json:"scheduled_task_id"`
	StartTime       time.Time `json:"start_time"`
	EndTime         time.Time `json:"end_time"`
	Reason          string    `json:"reason"`
}

// SScheduledTaskLabel is an autogenerated struct via yunion.io/x/onecloud/pkg/scheduledtask/models.SScheduledTaskLabel.
type SScheduledTaskLabel struct {
	apis.SResourceBase
	ScheduledTaskId string `json:"scheduled_task_id"`
	Label           string `json:"label"`
}

// STimer is an autogenerated struct via yunion.io/x/onecloud/pkg/scheduledtask/models.STimer.
type STimer struct {
	// Cycle type
	Type string `json:"type"`
	// 0-59
	Minute int `json:"minute"`
	// 0-23
	Hour int `json:"hour"`
	// 0-7 1 is Monday 0 is unlimited
	WeekDays byte `json:"week_days"`
	// 0-31 0 is unlimited
	MonthDays uint32 `json:"month_days"`
	IsExpired bool   `json:"is_expired"`
}
