package common

const (
	PERIOD             = 60
	UNIT_AVERAGE       = "Average"
	DEFAULT_STATISTICS = "Average,Minimum,Maximum"
	UNIT_PERCENT       = "Percent"
	UNIT_BPS           = "bps"
	UNIT_MBPS          = "Mbps"
	UNIT_BYTEPS        = "Bps"
	UNIT_CPS           = "cps"
	UNIT_COUNT         = "count"
	UNIT_MEM           = "byte"
	UNIT_MSEC          = "ms"
	UNIT_COUNT_SEC     = "count/s"
	UNIT_BYTES         = "byte"

	SERVER_METRIC_NAMESPACE = "QCE/CVM"
	REDIS_METRIC_NAMESPACE  = "QCE/REDIS"
	RDS_METRIC_NAMESPACE    = "QCE/CDB"

	//ESC监控指标
	INFLUXDB_FIELD_CPU_USAGE           = "vm_cpu.usage_active"
	INFLUXDB_FIELD_MEM_USAGE           = "vm_mem.used_percent"
	INFLUXDB_FIELD_DISK_USAGE          = "vm_disk.used_percent"
	INFLUXDB_FIELD_DISK_READ_BPS       = "vm_diskio.read_bps"
	INFLUXDB_FIELD_DISK_WRITE_BPS      = "vm_diskio.write_bps"
	INFLUXDB_FIELD_DISK_READ_IOPS      = "vm_diskio.read_iops"
	INFLUXDB_FIELD_DISK_WRITE_IOPS     = "vm_diskio.write_iops"
	INFLUXDB_FIELD_NET_BPS_RX          = "vm_netio.bps_recv"
	INFLUXDB_FIELD_NET_BPS_RX_INTERNET = INFLUXDB_FIELD_NET_BPS_RX + ",net_type=internet"
	INFLUXDB_FIELD_NET_BPS_RX_INTRANET = INFLUXDB_FIELD_NET_BPS_RX + ",net_type=intranet"
	INFLUXDB_FIELD_NET_BPS_TX          = "vm_netio.bps_sent"
	INFLUXDB_FIELD_NET_BPS_TX_INTERNET = INFLUXDB_FIELD_NET_BPS_TX + ",net_type=internet"
	INFLUXDB_FIELD_NET_BPS_TX_INTRANET = INFLUXDB_FIELD_NET_BPS_TX + ",net_type=intranet"
	INFLUXDB_FIELD_WANOUTTRAFFIC       = "vm_eipio.bps_out"
	INFLUXDB_FIELD_WANINTRAFFIC        = "vm_eipio.bps_in"
	INFLUXDB_FIELD_WANOUTPKG           = "vm_eipio.pps_out"
	INFLUXDB_FIELD_WANINPKG            = "vm_eipio.pps_in"

	//RDS监控指标
	INFLUXDB_FIELD_RDS_CPU_USAGE            = "rds_cpu.usage_active"
	INFLUXDB_FIELD_RDS_MEM_USAGE            = "rds_mem.used_percent"
	INFLUXDB_FIELD_RDS_NET_BPS_RX           = "rds_netio.bps_recv"
	INFLUXDB_FIELD_RDS_NET_BPS_RX_INTRANET  = INFLUXDB_FIELD_RDS_NET_BPS_RX + ",net_type=intranet"
	INFLUXDB_FIELD_RDS_NET_BPS_RX_MYSQL     = INFLUXDB_FIELD_RDS_NET_BPS_RX + ",server_type=mysql"
	INFLUXDB_FIELD_RDS_NET_BPS_RX_SQLSERVER = INFLUXDB_FIELD_RDS_NET_BPS_RX + ",server_type=sqlserver"
	INFLUXDB_FIELD_RDS_NET_BPS_TX           = "rds_netio.bps_sent"
	INFLUXDB_FIELD_RDS_NET_BPS_TX_INTRANET  = INFLUXDB_FIELD_RDS_NET_BPS_TX + ",net_type=intranet"
	INFLUXDB_FIELD_RDS_NET_BPS_TX_MYSQL     = INFLUXDB_FIELD_RDS_NET_BPS_TX + ",server_type=mysql"
	INFLUXDB_FIELD_RDS_NET_BPS_TX_SQLSERVER = INFLUXDB_FIELD_RDS_NET_BPS_TX + ",server_type=sqlserver"
	INFLUXDB_FIELD_RDS_DISK_USAGE           = "rds_disk.used_percent"
	INFLUXDB_FIELD_RDS_DISK_READ_BPS        = "rds_diskio.read_bps"
	INFLUXDB_FIELD_RDS_DISK_WRITE_BPS       = "rds_diskio.write_bps"
	INFLUXDB_FIELD_RDS_DISK_IO_PERSENT      = "rds_diskio.used_percent"
	INFLUXDB_FIELD_RDS_CONN_COUNT           = "rds_conn.used_count"
	INFLUXDB_FIELD_RDS_CONN_ACTIVE          = "rds_conn.active_count"
	INFLUXDB_FIELD_RDS_CONN_USAGE           = "rds_conn.used_percent"
	INFLUXDB_FIELD_RDS_CONN_FAILED          = "rds_conn.failed_count"

	INFLUXDB_FIELD_RDS_QPS              = "rds_qps.query_qps"
	INFLUXDB_FIELD_RDS_TPS              = "rds_tps.trans_qps"
	INFLUXDB_FIELD_RDS_INNODB_REDA_BPS  = "rds_innodb.read_bps"
	INFLUXDB_FIELD_RDS_INNODB_WRITE_BPS = "rds_innodb.write_bps"

	//REDIS监控指标
	INFLUXDB_FIELD_REDIS_CPU_USAGE      = "dcs_cpu.usage_active"
	INFLUXDB_FIELD_REDIS_MEM_USAGE      = "dcs_mem.used_percent"
	INFLUXDB_FIELD_REDIS_NET_BPS_RX     = "dcs_netio.bps_recv"
	INFLUXDB_FIELD_REDIS_NET_BPS_TX     = "dcs_netio.bps_sent"
	INFLUXDB_FIFLD_REDIS_CONN_USAGE     = "dcs_conn.used_percent"
	INFLUXDB_FIFLD_REDIS_OPT_SES        = "dcs_instantopt.opt_sec"
	INFLUXDB_FIFLD_REDIS_CACHE_KEYS     = "dcs_cachekeys.key_count"
	INFLUXDB_FIFLD_REDIS_CACHE_EXP_KEYS = INFLUXDB_FIFLD_REDIS_CACHE_KEYS + ",exp=expire"
	INFLUXDB_FIFLD_REDIS_DATA_MEM_USAGE = "dcs_datamem.used_byte"
	INFLUXDB_FIFLD_REDIS_SERVER_LOAD    = "dcs_cpu.server_load"
	INFLUXDB_FIFLD_REDIS_CONN_ERRORS    = "dcs_conn.errors"

	//对象存储OSS监控指标
	INFLUXDB_FIELD_OSS_NET_BPS_RX          = "oss_netio.bps_recv"
	INFLUXDB_FIELD_OSS_NET_BPS_RX_INTERNET = INFLUXDB_FIELD_OSS_NET_BPS_RX + ",net_type=internet"
	INFLUXDB_FIELD_OSS_NET_BPS_RX_INTRANET = INFLUXDB_FIELD_OSS_NET_BPS_RX + ",net_type=intranet"
	INFLUXDB_FIELD_OSS_NET_BPS_TX          = "oss_netio.bps_sent"
	INFLUXDB_FIELD_OSS_NET_BPS_TX_INTERNET = INFLUXDB_FIELD_OSS_NET_BPS_TX + ",net_type=internet"
	INFLUXDB_FIELD_OSS_NET_BPS_TX_INTRANET = INFLUXDB_FIELD_OSS_NET_BPS_TX + ",net_type=intranet"
	INFLUXDB_FIELD_OSS_LATECY              = "oss_latency.req_late"
	INFLUXDB_FIELD_OSS_LATECY_GET          = INFLUXDB_FIELD_OSS_LATECY + ",request=get"
	INFLUXDB_FIELD_OSS_LATECY_POST         = INFLUXDB_FIELD_OSS_LATECY + ",request=post"
	INFLUXDB_FIELD_OSS_REQ_COUNT           = "oss_req.req_count"
	INFLUXDB_FIELD_OSS_REQ_COUNT_GET       = INFLUXDB_FIELD_OSS_REQ_COUNT + ",request=get"
	INFLUXDB_FIELD_OSS_REQ_COUNT_POST      = INFLUXDB_FIELD_OSS_REQ_COUNT + ",request=post"
	INFLUXDB_FIELD_OSS_REQ_COUNT_5XX       = INFLUXDB_FIELD_OSS_REQ_COUNT + ",request=5xx"
	INFLUXDB_FIELD_OSS_REQ_COUNT_4XX       = INFLUXDB_FIELD_OSS_REQ_COUNT + ",request=4xx"

	//负载均衡监控指标
	INFLUXDB_FIELD_ELB_NET_BPS_RX      = "haproxy.bin"
	INFLUXDB_FIELD_ELB_NET_BPS_TX      = "haproxy.bout"
	INFLUXDB_FIELD_ELB_REQ_RATE        = "haproxy.req_rate,request=http"
	INFLUXDB_FIELD_ELB_CONN_RATE       = "haproxy.conn_rate,request=tcp"
	INFLUXDB_FIELD_ELB_DREQ_COUNT      = "haproxy.dreq,request=http"
	INFLUXDB_FIELD_ELB_DCONN_COUNT     = "haproxy.dcon,request=tcp"
	INFLUXDB_FIELD_ELB_HRSP_COUNT      = "haproxy.hrsp_Nxx"
	INFLUXDB_FIELD_ELB_HRSP_COUNT_2XX  = INFLUXDB_FIELD_ELB_HRSP_COUNT + ",request=2xx"
	INFLUXDB_FIELD_ELB_HRSP_COUNT_3XX  = INFLUXDB_FIELD_ELB_HRSP_COUNT + ",request=3xx"
	INFLUXDB_FIELD_ELB_HRSP_COUNT_4XX  = INFLUXDB_FIELD_ELB_HRSP_COUNT + ",request=4xx"
	INFLUXDB_FIELD_ELB_HRSP_COUNT_5XX  = INFLUXDB_FIELD_ELB_HRSP_COUNT + ",request=5xx"
	INFLUXDB_FIELD_ELB_CHC_STATUS      = "haproxy.check_status"
	INFLUXDB_FIELD_ELB_CHC_CODE        = "haproxy.check_code"
	INFLUXDB_FIELD_ELB_LAST_CHC        = "haproxy.last_chk"
	INFLUXDB_FIELD_ELB_SNAT_PORT       = "haproxy.used_snat_port"
	INFLUXDB_FIELD_ELB_SNAT_CONN_COUNT = "haproxy.snat_conn_count"

	INFLUXDB_FIELD_K8S_CLUSTER_CPU_USAGE       = "k8s_cluster.cpu_used_percent"
	INFLUXDB_FIELD_K8S_CLUSTER_MEM_USAGE       = "k8s_cluster.mem_used_percent"
	INFLUXDB_FIELD_K8S_CLUSTER_ALLOCATABLE_POD = "k8s_cluster.allocatable_pod"
	INFLUXDB_FIELD_K8S_CLUSTER_TOTAL_CPUCORE   = "k8s_cluster.total_cpu"
	INFLUXDB_FIELD_K8S_CLUSTER_CPU_ALLOCATED   = "k8s_cluster.cpu_allocated_percent"

	INFLUXDB_FIELD_K8S_DEPLOY_CPU_USAGE               = "k8s_deploy.cpu_used_percent"
	INFLUXDB_FIELD_K8S_DEPLOY_MEM_USAGE               = "k8s_deploy.mem_used_percent"
	INFLUXDB_FIELD_K8S_DEPLOY_RESTART_TOTAL           = "k8s_deploy.restart_total"
	INFLUXDB_FIELD_K8S_DEPLOY_NET_BPS_RX              = "k8s_deploy.bps_recv"
	INFLUXDB_FIELD_K8S_DEPLOY_NET_BPS_RX_INTERNET     = INFLUXDB_FIELD_NET_BPS_RX + ",net_type=internet"
	INFLUXDB_FIELD_K8S_DEPLOY_NET_BPS_RX_INTRANET     = INFLUXDB_FIELD_NET_BPS_RX + ",net_type=intranet"
	INFLUXDB_FIELD_K8S_DEPLOY_NET_BPS_TX              = "k8s_deploy.bps_sent"
	INFLUXDB_FIELD_K8S_DEPLOY_NET_BPS_TX_INTERNET     = INFLUXDB_FIELD_NET_BPS_TX + ",net_type=internet"
	INFLUXDB_FIELD_K8S_DEPLOY_NET_BPS_TX_INTRANET     = INFLUXDB_FIELD_NET_BPS_TX + ",net_type=intranet"
	INFLUXDB_FIELD_K8S_POD_OOM_CONTAINER_COUNT        = "k8s_deploy.pod_oom_total"
	INFLUXDB_FIELD_K8S_POD_RESTARTING_CONTAINER_COUNT = "k8s_deploy.pod_restarting_total"

	INFLUXDB_FIELD_K8S_POD_CPU_USAGE     = "k8s_pod.cpu_used_percent"
	INFLUXDB_FIELD_K8S_POD_MEM_USAGE     = "k8s_pod.mem_used_percent"
	INFLUXDB_FIELD_K8S_POD_RESTART_TOTAL = "k8s_pod.restart_total"

	INFLUXDB_FIELD_K8S_CONTAINER_CPU_USAGE  = "k8s_container.cpu_used_percent"
	INFLUXDB_FIELD_K8S_CONTAINER_MEM_USAGE  = "k8s_container.mem_used_percent"
	INFLUXDB_FIELD_K8S_CONTAINER_NET_BPS_RX = "k8s_container.net_bps_recv"
	INFLUXDB_FIELD_K8S_CONTAINER_NET_BPS_TX = "k8s_container.net_bps_sent"

	INFLUXDB_FIELD_K8S_NODE_CPU_USAGE           = "k8s_node.cpu_used_percent"
	INFLUXDB_FIELD_K8S_NODE_MEM_USAGE           = "k8s_node.mem_used_percent"
	INFLUXDB_FIELD_K8S_NODE_DISK_USAGE          = "k8s_node.disk_used_percent"
	INFLUXDB_FIELD_K8S_NODE_NET_BPS_RX          = "k8s_node.bps_recv"
	INFLUXDB_FIELD_K8S_NODE_NET_BPS_RX_INTERNET = INFLUXDB_FIELD_NET_BPS_RX + ",net_type=internet"
	INFLUXDB_FIELD_K8S_NODE_NET_BPS_RX_INTRANET = INFLUXDB_FIELD_NET_BPS_RX + ",net_type=intranet"
	INFLUXDB_FIELD_K8S_NODE_NET_BPS_TX          = "k8s_node.bps_sent"
	INFLUXDB_FIELD_K8S_NODE_NET_BPS_TX_INTERNET = INFLUXDB_FIELD_NET_BPS_TX + ",net_type=internet"
	INFLUXDB_FIELD_K8S_NODE_NET_BPS_TX_INTRANET = INFLUXDB_FIELD_NET_BPS_TX + ",net_type=intranet"
	INFLUXDB_FIELD_K8S_NODE_POD_RESTART_TOTAL   = "k8s_node.pod_restart_total"

	KEY_VMS   = "vms"
	KEY_CPUS  = "cpus"
	KEY_MEMS  = "mems"
	KEY_DISKS = "disks"
)
