// Copyright 2019 Yunion
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package api

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ForwarderClient is the client API for Forwarder service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ForwarderClient interface {
	Open(ctx context.Context, in *OpenRequest, opts ...grpc.CallOption) (*OpenResponse, error)
	Close(ctx context.Context, in *CloseRequest, opts ...grpc.CallOption) (*CloseResponse, error)
	ListByRemote(ctx context.Context, in *ListByRemoteRequest, opts ...grpc.CallOption) (*ListByRemoteResponse, error)
}

type forwarderClient struct {
	cc grpc.ClientConnInterface
}

func NewForwarderClient(cc grpc.ClientConnInterface) ForwarderClient {
	return &forwarderClient{cc}
}

func (c *forwarderClient) Open(ctx context.Context, in *OpenRequest, opts ...grpc.CallOption) (*OpenResponse, error) {
	out := new(OpenResponse)
	err := c.cc.Invoke(ctx, "/pb.Forwarder/Open", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *forwarderClient) Close(ctx context.Context, in *CloseRequest, opts ...grpc.CallOption) (*CloseResponse, error) {
	out := new(CloseResponse)
	err := c.cc.Invoke(ctx, "/pb.Forwarder/Close", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *forwarderClient) ListByRemote(ctx context.Context, in *ListByRemoteRequest, opts ...grpc.CallOption) (*ListByRemoteResponse, error) {
	out := new(ListByRemoteResponse)
	err := c.cc.Invoke(ctx, "/pb.Forwarder/ListByRemote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ForwarderServer is the server API for Forwarder service.
// All implementations must embed UnimplementedForwarderServer
// for forward compatibility
type ForwarderServer interface {
	Open(context.Context, *OpenRequest) (*OpenResponse, error)
	Close(context.Context, *CloseRequest) (*CloseResponse, error)
	ListByRemote(context.Context, *ListByRemoteRequest) (*ListByRemoteResponse, error)
	mustEmbedUnimplementedForwarderServer()
}

// UnimplementedForwarderServer must be embedded to have forward compatible implementations.
type UnimplementedForwarderServer struct {
}

func (*UnimplementedForwarderServer) Open(context.Context, *OpenRequest) (*OpenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Open not implemented")
}
func (*UnimplementedForwarderServer) Close(context.Context, *CloseRequest) (*CloseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Close not implemented")
}
func (*UnimplementedForwarderServer) ListByRemote(context.Context, *ListByRemoteRequest) (*ListByRemoteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListByRemote not implemented")
}
func (*UnimplementedForwarderServer) mustEmbedUnimplementedForwarderServer() {}

func RegisterForwarderServer(s *grpc.Server, srv ForwarderServer) {
	s.RegisterService(&_Forwarder_serviceDesc, srv)
}

func _Forwarder_Open_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OpenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ForwarderServer).Open(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Forwarder/Open",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ForwarderServer).Open(ctx, req.(*OpenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Forwarder_Close_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ForwarderServer).Close(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Forwarder/Close",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ForwarderServer).Close(ctx, req.(*CloseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Forwarder_ListByRemote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListByRemoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ForwarderServer).ListByRemote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Forwarder/ListByRemote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ForwarderServer).ListByRemote(ctx, req.(*ListByRemoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Forwarder_serviceDesc = grpc.ServiceDesc{
	ServiceName: "pb.Forwarder",
	HandlerType: (*ForwarderServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Open",
			Handler:    _Forwarder_Open_Handler,
		},
		{
			MethodName: "Close",
			Handler:    _Forwarder_Close_Handler,
		},
		{
			MethodName: "ListByRemote",
			Handler:    _Forwarder_ListByRemote_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "forwarder.proto",
}
