// Copyright 2019 Yunion
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package cloudnet

import (
	"yunion.io/x/onecloud/pkg/mcclient/modulebase"
)

type RuleManager struct {
	modulebase.ResourceManager
}

var (
	Rules RuleManager
)

func init() {
	Rules = RuleManager{
		NewCloudnetManager(
			"rule",
			"rules",
			[]string{
				"id",
				"name",
				"router_id",
				"match_src_net",
				"match_dest_net",
				"match_proto",
				"match_port",
				"match_in_ifname",
				"match_out_ifname",
				"action",
				"action_options",
			},
			[]string{"tenant"},
		),
	}
	registerV2(&Rules)
}
