// Copyright 2019 Yunion
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package bingocloud

type SZone struct {
	ZoneName    string
	DisplayName string
	ZoneState   string
}

func (self *SRegion) GetZones() ([]SZone, error) {
	resp, err := self.invoke("DescribeAvailabilityZones", nil)
	if err != nil {
		return nil, err
	}
	ret := []SZone{}
	return ret, resp.Unmarshal(&ret, "availabilityZoneInfo")
}
