// Copyright 2019 Yunion
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: send_server.proto

package apis

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type SendParams struct {
	Receiver             *SReceiver `protobuf:"bytes,1,opt,name=Receiver,proto3" json:"Receiver,omitempty"`
	Topic                string     `protobuf:"bytes,2,opt,name=Topic,proto3" json:"Topic,omitempty"`
	Title                string     `protobuf:"bytes,3,opt,name=Title,proto3" json:"Title,omitempty"`
	Message              string     `protobuf:"bytes,4,opt,name=Message,proto3" json:"Message,omitempty"`
	Priority             string     `protobuf:"bytes,5,opt,name=Priority,proto3" json:"Priority,omitempty"`
	RemoteTemplate       string     `protobuf:"bytes,6,opt,name=RemoteTemplate,proto3" json:"RemoteTemplate,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *SendParams) Reset()         { *m = SendParams{} }
func (m *SendParams) String() string { return proto.CompactTextString(m) }
func (*SendParams) ProtoMessage()    {}
func (*SendParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_63fdd68f7eb311f9, []int{0}
}

func (m *SendParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SendParams.Unmarshal(m, b)
}
func (m *SendParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SendParams.Marshal(b, m, deterministic)
}
func (m *SendParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SendParams.Merge(m, src)
}
func (m *SendParams) XXX_Size() int {
	return xxx_messageInfo_SendParams.Size(m)
}
func (m *SendParams) XXX_DiscardUnknown() {
	xxx_messageInfo_SendParams.DiscardUnknown(m)
}

var xxx_messageInfo_SendParams proto.InternalMessageInfo

func (m *SendParams) GetReceiver() *SReceiver {
	if m != nil {
		return m.Receiver
	}
	return nil
}

func (m *SendParams) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *SendParams) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *SendParams) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *SendParams) GetPriority() string {
	if m != nil {
		return m.Priority
	}
	return ""
}

func (m *SendParams) GetRemoteTemplate() string {
	if m != nil {
		return m.RemoteTemplate
	}
	return ""
}

type ValidateConfigInput struct {
	Configs              map[string]string `protobuf:"bytes,1,rep,name=configs,proto3" json:"configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ValidateConfigInput) Reset()         { *m = ValidateConfigInput{} }
func (m *ValidateConfigInput) String() string { return proto.CompactTextString(m) }
func (*ValidateConfigInput) ProtoMessage()    {}
func (*ValidateConfigInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_63fdd68f7eb311f9, []int{1}
}

func (m *ValidateConfigInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValidateConfigInput.Unmarshal(m, b)
}
func (m *ValidateConfigInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValidateConfigInput.Marshal(b, m, deterministic)
}
func (m *ValidateConfigInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidateConfigInput.Merge(m, src)
}
func (m *ValidateConfigInput) XXX_Size() int {
	return xxx_messageInfo_ValidateConfigInput.Size(m)
}
func (m *ValidateConfigInput) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidateConfigInput.DiscardUnknown(m)
}

var xxx_messageInfo_ValidateConfigInput proto.InternalMessageInfo

func (m *ValidateConfigInput) GetConfigs() map[string]string {
	if m != nil {
		return m.Configs
	}
	return nil
}

type AddConfigInput struct {
	Configs              map[string]string `protobuf:"bytes,1,rep,name=configs,proto3" json:"configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	DomainId             string            `protobuf:"bytes,2,opt,name=domainId,proto3" json:"domainId,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *AddConfigInput) Reset()         { *m = AddConfigInput{} }
func (m *AddConfigInput) String() string { return proto.CompactTextString(m) }
func (*AddConfigInput) ProtoMessage()    {}
func (*AddConfigInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_63fdd68f7eb311f9, []int{2}
}

func (m *AddConfigInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddConfigInput.Unmarshal(m, b)
}
func (m *AddConfigInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddConfigInput.Marshal(b, m, deterministic)
}
func (m *AddConfigInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddConfigInput.Merge(m, src)
}
func (m *AddConfigInput) XXX_Size() int {
	return xxx_messageInfo_AddConfigInput.Size(m)
}
func (m *AddConfigInput) XXX_DiscardUnknown() {
	xxx_messageInfo_AddConfigInput.DiscardUnknown(m)
}

var xxx_messageInfo_AddConfigInput proto.InternalMessageInfo

func (m *AddConfigInput) GetConfigs() map[string]string {
	if m != nil {
		return m.Configs
	}
	return nil
}

func (m *AddConfigInput) GetDomainId() string {
	if m != nil {
		return m.DomainId
	}
	return ""
}

type UpdateConfigInput struct {
	Configs              map[string]string `protobuf:"bytes,1,rep,name=configs,proto3" json:"configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	DomainId             string            `protobuf:"bytes,2,opt,name=domainId,proto3" json:"domainId,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateConfigInput) Reset()         { *m = UpdateConfigInput{} }
func (m *UpdateConfigInput) String() string { return proto.CompactTextString(m) }
func (*UpdateConfigInput) ProtoMessage()    {}
func (*UpdateConfigInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_63fdd68f7eb311f9, []int{3}
}

func (m *UpdateConfigInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateConfigInput.Unmarshal(m, b)
}
func (m *UpdateConfigInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateConfigInput.Marshal(b, m, deterministic)
}
func (m *UpdateConfigInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateConfigInput.Merge(m, src)
}
func (m *UpdateConfigInput) XXX_Size() int {
	return xxx_messageInfo_UpdateConfigInput.Size(m)
}
func (m *UpdateConfigInput) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateConfigInput.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateConfigInput proto.InternalMessageInfo

func (m *UpdateConfigInput) GetConfigs() map[string]string {
	if m != nil {
		return m.Configs
	}
	return nil
}

func (m *UpdateConfigInput) GetDomainId() string {
	if m != nil {
		return m.DomainId
	}
	return ""
}

type DeleteConfigInput struct {
	DomainId             string   `protobuf:"bytes,1,opt,name=domainId,proto3" json:"domainId,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteConfigInput) Reset()         { *m = DeleteConfigInput{} }
func (m *DeleteConfigInput) String() string { return proto.CompactTextString(m) }
func (*DeleteConfigInput) ProtoMessage()    {}
func (*DeleteConfigInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_63fdd68f7eb311f9, []int{4}
}

func (m *DeleteConfigInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteConfigInput.Unmarshal(m, b)
}
func (m *DeleteConfigInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteConfigInput.Marshal(b, m, deterministic)
}
func (m *DeleteConfigInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteConfigInput.Merge(m, src)
}
func (m *DeleteConfigInput) XXX_Size() int {
	return xxx_messageInfo_DeleteConfigInput.Size(m)
}
func (m *DeleteConfigInput) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteConfigInput.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteConfigInput proto.InternalMessageInfo

func (m *DeleteConfigInput) GetDomainId() string {
	if m != nil {
		return m.DomainId
	}
	return ""
}

type CompleteConfigInput struct {
	ConfigInput          []*AddConfigInput `protobuf:"bytes,1,rep,name=ConfigInput,proto3" json:"ConfigInput,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CompleteConfigInput) Reset()         { *m = CompleteConfigInput{} }
func (m *CompleteConfigInput) String() string { return proto.CompactTextString(m) }
func (*CompleteConfigInput) ProtoMessage()    {}
func (*CompleteConfigInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_63fdd68f7eb311f9, []int{5}
}

func (m *CompleteConfigInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompleteConfigInput.Unmarshal(m, b)
}
func (m *CompleteConfigInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompleteConfigInput.Marshal(b, m, deterministic)
}
func (m *CompleteConfigInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompleteConfigInput.Merge(m, src)
}
func (m *CompleteConfigInput) XXX_Size() int {
	return xxx_messageInfo_CompleteConfigInput.Size(m)
}
func (m *CompleteConfigInput) XXX_DiscardUnknown() {
	xxx_messageInfo_CompleteConfigInput.DiscardUnknown(m)
}

var xxx_messageInfo_CompleteConfigInput proto.InternalMessageInfo

func (m *CompleteConfigInput) GetConfigInput() []*AddConfigInput {
	if m != nil {
		return m.ConfigInput
	}
	return nil
}

type UseridByMobileParams struct {
	Mobile               string   `protobuf:"bytes,1,opt,name=mobile,proto3" json:"mobile,omitempty"`
	DomainId             string   `protobuf:"bytes,2,opt,name=domainId,proto3" json:"domainId,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UseridByMobileParams) Reset()         { *m = UseridByMobileParams{} }
func (m *UseridByMobileParams) String() string { return proto.CompactTextString(m) }
func (*UseridByMobileParams) ProtoMessage()    {}
func (*UseridByMobileParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_63fdd68f7eb311f9, []int{6}
}

func (m *UseridByMobileParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UseridByMobileParams.Unmarshal(m, b)
}
func (m *UseridByMobileParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UseridByMobileParams.Marshal(b, m, deterministic)
}
func (m *UseridByMobileParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UseridByMobileParams.Merge(m, src)
}
func (m *UseridByMobileParams) XXX_Size() int {
	return xxx_messageInfo_UseridByMobileParams.Size(m)
}
func (m *UseridByMobileParams) XXX_DiscardUnknown() {
	xxx_messageInfo_UseridByMobileParams.DiscardUnknown(m)
}

var xxx_messageInfo_UseridByMobileParams proto.InternalMessageInfo

func (m *UseridByMobileParams) GetMobile() string {
	if m != nil {
		return m.Mobile
	}
	return ""
}

func (m *UseridByMobileParams) GetDomainId() string {
	if m != nil {
		return m.DomainId
	}
	return ""
}

type Empty struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Empty) Reset()         { *m = Empty{} }
func (m *Empty) String() string { return proto.CompactTextString(m) }
func (*Empty) ProtoMessage()    {}
func (*Empty) Descriptor() ([]byte, []int) {
	return fileDescriptor_63fdd68f7eb311f9, []int{7}
}

func (m *Empty) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Empty.Unmarshal(m, b)
}
func (m *Empty) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Empty.Marshal(b, m, deterministic)
}
func (m *Empty) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Empty.Merge(m, src)
}
func (m *Empty) XXX_Size() int {
	return xxx_messageInfo_Empty.Size(m)
}
func (m *Empty) XXX_DiscardUnknown() {
	xxx_messageInfo_Empty.DiscardUnknown(m)
}

var xxx_messageInfo_Empty proto.InternalMessageInfo

type UseridByMobileReply struct {
	Userid               string   `protobuf:"bytes,1,opt,name=userid,proto3" json:"userid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UseridByMobileReply) Reset()         { *m = UseridByMobileReply{} }
func (m *UseridByMobileReply) String() string { return proto.CompactTextString(m) }
func (*UseridByMobileReply) ProtoMessage()    {}
func (*UseridByMobileReply) Descriptor() ([]byte, []int) {
	return fileDescriptor_63fdd68f7eb311f9, []int{8}
}

func (m *UseridByMobileReply) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UseridByMobileReply.Unmarshal(m, b)
}
func (m *UseridByMobileReply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UseridByMobileReply.Marshal(b, m, deterministic)
}
func (m *UseridByMobileReply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UseridByMobileReply.Merge(m, src)
}
func (m *UseridByMobileReply) XXX_Size() int {
	return xxx_messageInfo_UseridByMobileReply.Size(m)
}
func (m *UseridByMobileReply) XXX_DiscardUnknown() {
	xxx_messageInfo_UseridByMobileReply.DiscardUnknown(m)
}

var xxx_messageInfo_UseridByMobileReply proto.InternalMessageInfo

func (m *UseridByMobileReply) GetUserid() string {
	if m != nil {
		return m.Userid
	}
	return ""
}

type ValidateConfigReply struct {
	IsValid              bool     `protobuf:"varint,1,opt,name=isValid,proto3" json:"isValid,omitempty"`
	Msg                  string   `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ValidateConfigReply) Reset()         { *m = ValidateConfigReply{} }
func (m *ValidateConfigReply) String() string { return proto.CompactTextString(m) }
func (*ValidateConfigReply) ProtoMessage()    {}
func (*ValidateConfigReply) Descriptor() ([]byte, []int) {
	return fileDescriptor_63fdd68f7eb311f9, []int{9}
}

func (m *ValidateConfigReply) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValidateConfigReply.Unmarshal(m, b)
}
func (m *ValidateConfigReply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValidateConfigReply.Marshal(b, m, deterministic)
}
func (m *ValidateConfigReply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidateConfigReply.Merge(m, src)
}
func (m *ValidateConfigReply) XXX_Size() int {
	return xxx_messageInfo_ValidateConfigReply.Size(m)
}
func (m *ValidateConfigReply) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidateConfigReply.DiscardUnknown(m)
}

var xxx_messageInfo_ValidateConfigReply proto.InternalMessageInfo

func (m *ValidateConfigReply) GetIsValid() bool {
	if m != nil {
		return m.IsValid
	}
	return false
}

func (m *ValidateConfigReply) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

type SReceiver struct {
	Contact              string   `protobuf:"bytes,1,opt,name=Contact,proto3" json:"Contact,omitempty"`
	DomainId             string   `protobuf:"bytes,2,opt,name=DomainId,proto3" json:"DomainId,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SReceiver) Reset()         { *m = SReceiver{} }
func (m *SReceiver) String() string { return proto.CompactTextString(m) }
func (*SReceiver) ProtoMessage()    {}
func (*SReceiver) Descriptor() ([]byte, []int) {
	return fileDescriptor_63fdd68f7eb311f9, []int{10}
}

func (m *SReceiver) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SReceiver.Unmarshal(m, b)
}
func (m *SReceiver) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SReceiver.Marshal(b, m, deterministic)
}
func (m *SReceiver) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SReceiver.Merge(m, src)
}
func (m *SReceiver) XXX_Size() int {
	return xxx_messageInfo_SReceiver.Size(m)
}
func (m *SReceiver) XXX_DiscardUnknown() {
	xxx_messageInfo_SReceiver.DiscardUnknown(m)
}

var xxx_messageInfo_SReceiver proto.InternalMessageInfo

func (m *SReceiver) GetContact() string {
	if m != nil {
		return m.Contact
	}
	return ""
}

func (m *SReceiver) GetDomainId() string {
	if m != nil {
		return m.DomainId
	}
	return ""
}

type BatchSendParams struct {
	Receivers            []*SReceiver `protobuf:"bytes,1,rep,name=Receivers,proto3" json:"Receivers,omitempty"`
	Title                string       `protobuf:"bytes,2,opt,name=Title,proto3" json:"Title,omitempty"`
	Message              string       `protobuf:"bytes,3,opt,name=Message,proto3" json:"Message,omitempty"`
	Priority             string       `protobuf:"bytes,4,opt,name=Priority,proto3" json:"Priority,omitempty"`
	RemoteTemplate       string       `protobuf:"bytes,5,opt,name=RemoteTemplate,proto3" json:"RemoteTemplate,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *BatchSendParams) Reset()         { *m = BatchSendParams{} }
func (m *BatchSendParams) String() string { return proto.CompactTextString(m) }
func (*BatchSendParams) ProtoMessage()    {}
func (*BatchSendParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_63fdd68f7eb311f9, []int{11}
}

func (m *BatchSendParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchSendParams.Unmarshal(m, b)
}
func (m *BatchSendParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchSendParams.Marshal(b, m, deterministic)
}
func (m *BatchSendParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchSendParams.Merge(m, src)
}
func (m *BatchSendParams) XXX_Size() int {
	return xxx_messageInfo_BatchSendParams.Size(m)
}
func (m *BatchSendParams) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchSendParams.DiscardUnknown(m)
}

var xxx_messageInfo_BatchSendParams proto.InternalMessageInfo

func (m *BatchSendParams) GetReceivers() []*SReceiver {
	if m != nil {
		return m.Receivers
	}
	return nil
}

func (m *BatchSendParams) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *BatchSendParams) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *BatchSendParams) GetPriority() string {
	if m != nil {
		return m.Priority
	}
	return ""
}

func (m *BatchSendParams) GetRemoteTemplate() string {
	if m != nil {
		return m.RemoteTemplate
	}
	return ""
}

type FailedRecord struct {
	Receiver             *SReceiver `protobuf:"bytes,1,opt,name=Receiver,proto3" json:"Receiver,omitempty"`
	Reason               string     `protobuf:"bytes,2,opt,name=Reason,proto3" json:"Reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *FailedRecord) Reset()         { *m = FailedRecord{} }
func (m *FailedRecord) String() string { return proto.CompactTextString(m) }
func (*FailedRecord) ProtoMessage()    {}
func (*FailedRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_63fdd68f7eb311f9, []int{12}
}

func (m *FailedRecord) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FailedRecord.Unmarshal(m, b)
}
func (m *FailedRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FailedRecord.Marshal(b, m, deterministic)
}
func (m *FailedRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FailedRecord.Merge(m, src)
}
func (m *FailedRecord) XXX_Size() int {
	return xxx_messageInfo_FailedRecord.Size(m)
}
func (m *FailedRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_FailedRecord.DiscardUnknown(m)
}

var xxx_messageInfo_FailedRecord proto.InternalMessageInfo

func (m *FailedRecord) GetReceiver() *SReceiver {
	if m != nil {
		return m.Receiver
	}
	return nil
}

func (m *FailedRecord) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type BatchSendReply struct {
	FailedRecords        []*FailedRecord `protobuf:"bytes,1,rep,name=FailedRecords,proto3" json:"FailedRecords,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *BatchSendReply) Reset()         { *m = BatchSendReply{} }
func (m *BatchSendReply) String() string { return proto.CompactTextString(m) }
func (*BatchSendReply) ProtoMessage()    {}
func (*BatchSendReply) Descriptor() ([]byte, []int) {
	return fileDescriptor_63fdd68f7eb311f9, []int{13}
}

func (m *BatchSendReply) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchSendReply.Unmarshal(m, b)
}
func (m *BatchSendReply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchSendReply.Marshal(b, m, deterministic)
}
func (m *BatchSendReply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchSendReply.Merge(m, src)
}
func (m *BatchSendReply) XXX_Size() int {
	return xxx_messageInfo_BatchSendReply.Size(m)
}
func (m *BatchSendReply) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchSendReply.DiscardUnknown(m)
}

var xxx_messageInfo_BatchSendReply proto.InternalMessageInfo

func (m *BatchSendReply) GetFailedRecords() []*FailedRecord {
	if m != nil {
		return m.FailedRecords
	}
	return nil
}

type ReadyInput struct {
	DomainIds            []string `protobuf:"bytes,1,rep,name=DomainIds,proto3" json:"DomainIds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadyInput) Reset()         { *m = ReadyInput{} }
func (m *ReadyInput) String() string { return proto.CompactTextString(m) }
func (*ReadyInput) ProtoMessage()    {}
func (*ReadyInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_63fdd68f7eb311f9, []int{14}
}

func (m *ReadyInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadyInput.Unmarshal(m, b)
}
func (m *ReadyInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadyInput.Marshal(b, m, deterministic)
}
func (m *ReadyInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadyInput.Merge(m, src)
}
func (m *ReadyInput) XXX_Size() int {
	return xxx_messageInfo_ReadyInput.Size(m)
}
func (m *ReadyInput) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadyInput.DiscardUnknown(m)
}

var xxx_messageInfo_ReadyInput proto.InternalMessageInfo

func (m *ReadyInput) GetDomainIds() []string {
	if m != nil {
		return m.DomainIds
	}
	return nil
}

type ReadyOutput struct {
	Ok                   bool     `protobuf:"varint,1,opt,name=Ok,proto3" json:"Ok,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadyOutput) Reset()         { *m = ReadyOutput{} }
func (m *ReadyOutput) String() string { return proto.CompactTextString(m) }
func (*ReadyOutput) ProtoMessage()    {}
func (*ReadyOutput) Descriptor() ([]byte, []int) {
	return fileDescriptor_63fdd68f7eb311f9, []int{15}
}

func (m *ReadyOutput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadyOutput.Unmarshal(m, b)
}
func (m *ReadyOutput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadyOutput.Marshal(b, m, deterministic)
}
func (m *ReadyOutput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadyOutput.Merge(m, src)
}
func (m *ReadyOutput) XXX_Size() int {
	return xxx_messageInfo_ReadyOutput.Size(m)
}
func (m *ReadyOutput) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadyOutput.DiscardUnknown(m)
}

var xxx_messageInfo_ReadyOutput proto.InternalMessageInfo

func (m *ReadyOutput) GetOk() bool {
	if m != nil {
		return m.Ok
	}
	return false
}

func init() {
	proto.RegisterType((*SendParams)(nil), "apis.SendParams")
	proto.RegisterType((*ValidateConfigInput)(nil), "apis.ValidateConfigInput")
	proto.RegisterMapType((map[string]string)(nil), "apis.ValidateConfigInput.ConfigsEntry")
	proto.RegisterType((*AddConfigInput)(nil), "apis.AddConfigInput")
	proto.RegisterMapType((map[string]string)(nil), "apis.AddConfigInput.ConfigsEntry")
	proto.RegisterType((*UpdateConfigInput)(nil), "apis.UpdateConfigInput")
	proto.RegisterMapType((map[string]string)(nil), "apis.UpdateConfigInput.ConfigsEntry")
	proto.RegisterType((*DeleteConfigInput)(nil), "apis.DeleteConfigInput")
	proto.RegisterType((*CompleteConfigInput)(nil), "apis.CompleteConfigInput")
	proto.RegisterType((*UseridByMobileParams)(nil), "apis.UseridByMobileParams")
	proto.RegisterType((*Empty)(nil), "apis.Empty")
	proto.RegisterType((*UseridByMobileReply)(nil), "apis.UseridByMobileReply")
	proto.RegisterType((*ValidateConfigReply)(nil), "apis.ValidateConfigReply")
	proto.RegisterType((*SReceiver)(nil), "apis.SReceiver")
	proto.RegisterType((*BatchSendParams)(nil), "apis.BatchSendParams")
	proto.RegisterType((*FailedRecord)(nil), "apis.FailedRecord")
	proto.RegisterType((*BatchSendReply)(nil), "apis.BatchSendReply")
	proto.RegisterType((*ReadyInput)(nil), "apis.ReadyInput")
	proto.RegisterType((*ReadyOutput)(nil), "apis.ReadyOutput")
}

func init() { proto.RegisterFile("send_server.proto", fileDescriptor_63fdd68f7eb311f9) }

var fileDescriptor_63fdd68f7eb311f9 = []byte{
	// 722 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x55, 0x5d, 0x6b, 0xd4, 0x4c,
	0x14, 0x26, 0xfb, 0xd9, 0x9c, 0xed, 0xbb, 0xed, 0x4e, 0xf7, 0xed, 0x9b, 0x77, 0x51, 0xa8, 0x41,
	0x4b, 0x51, 0xbb, 0x42, 0x15, 0x59, 0x2a, 0x88, 0xdb, 0x2f, 0x69, 0xa1, 0xb4, 0x4c, 0x5b, 0x6f,
	0x65, 0xba, 0x39, 0xae, 0xa1, 0xf9, 0x22, 0x99, 0x2d, 0xe4, 0xd2, 0xdf, 0xe0, 0x6f, 0xf0, 0xca,
	0x5b, 0xff, 0x81, 0x7f, 0x4c, 0x32, 0x93, 0xc9, 0x26, 0xd9, 0x54, 0x11, 0xc1, 0xbb, 0x3c, 0x67,
	0x9e, 0x73, 0xce, 0x93, 0x93, 0x39, 0x4f, 0xa0, 0x17, 0xa1, 0x67, 0xbd, 0x8f, 0x30, 0xbc, 0xc5,
	0x70, 0x18, 0x84, 0x3e, 0xf7, 0x49, 0x83, 0x05, 0x76, 0x64, 0x7e, 0xd7, 0x00, 0x2e, 0xd0, 0xb3,
	0xce, 0x59, 0xc8, 0xdc, 0x88, 0x3c, 0x81, 0x25, 0x8a, 0x13, 0xb4, 0x6f, 0x31, 0x34, 0xb4, 0x0d,
	0x6d, 0xab, 0xb3, 0xb3, 0x32, 0x4c, 0x78, 0xc3, 0x0b, 0x15, 0xa6, 0x19, 0x81, 0xf4, 0xa1, 0x79,
	0xe9, 0x07, 0xf6, 0xc4, 0xa8, 0x6d, 0x68, 0x5b, 0x3a, 0x95, 0x40, 0x44, 0x6d, 0xee, 0xa0, 0x51,
	0x4f, 0xa3, 0x09, 0x20, 0x06, 0xb4, 0x4f, 0x31, 0x8a, 0xd8, 0x14, 0x8d, 0x86, 0x88, 0x2b, 0x48,
	0x06, 0xb0, 0x74, 0x1e, 0xda, 0x7e, 0x68, 0xf3, 0xd8, 0x68, 0x8a, 0xa3, 0x0c, 0x93, 0x4d, 0xe8,
	0x52, 0x74, 0x7d, 0x8e, 0x97, 0xe8, 0x06, 0x0e, 0xe3, 0x68, 0xb4, 0x04, 0xa3, 0x14, 0x35, 0x3f,
	0x6b, 0xb0, 0xf6, 0x8e, 0x39, 0xb6, 0xc5, 0x38, 0xee, 0xfb, 0xde, 0x07, 0x7b, 0x7a, 0xec, 0x05,
	0x33, 0x4e, 0xde, 0x40, 0x7b, 0x22, 0x60, 0x64, 0x68, 0x1b, 0xf5, 0xad, 0xce, 0xce, 0xa6, 0x7c,
	0x9b, 0x0a, 0xee, 0x50, 0x3e, 0x47, 0x87, 0x1e, 0x0f, 0x63, 0xaa, 0xd2, 0x06, 0xbb, 0xb0, 0x9c,
	0x3f, 0x20, 0xab, 0x50, 0xbf, 0xc1, 0x58, 0xcc, 0x46, 0xa7, 0xc9, 0x63, 0xf2, 0xbe, 0xb7, 0xcc,
	0x99, 0xa1, 0x9a, 0x82, 0x00, 0xbb, 0xb5, 0x91, 0x66, 0x7e, 0xd1, 0xa0, 0x3b, 0xb6, 0xac, 0xbc,
	0xa0, 0x57, 0x65, 0x41, 0x0f, 0xa4, 0xa0, 0x22, 0xad, 0x5a, 0x4b, 0x32, 0x29, 0xcb, 0x77, 0x99,
	0xed, 0x1d, 0x5b, 0x69, 0xb3, 0x0c, 0xff, 0x91, 0xce, 0xaf, 0x1a, 0xf4, 0xae, 0x82, 0xf2, 0xec,
	0x5e, 0x97, 0xa5, 0x3e, 0x94, 0x52, 0x17, 0x98, 0x7f, 0x59, 0xed, 0x33, 0xe8, 0x1d, 0xa0, 0x83,
	0x45, 0xb1, 0xf9, 0x66, 0x5a, 0xb1, 0x99, 0x79, 0x0a, 0x6b, 0xfb, 0xbe, 0x1b, 0x94, 0x53, 0x5e,
	0x42, 0x27, 0x07, 0xd3, 0x77, 0xec, 0x57, 0x7d, 0x0e, 0x9a, 0x27, 0x9a, 0x27, 0xd0, 0xbf, 0x8a,
	0x30, 0xb4, 0xad, 0xbd, 0xf8, 0xd4, 0xbf, 0xb6, 0x1d, 0x4c, 0x57, 0x67, 0x1d, 0x5a, 0xae, 0xc0,
	0xa9, 0x80, 0x14, 0xfd, 0x6c, 0x0e, 0x66, 0x1b, 0x9a, 0x87, 0x6e, 0xc0, 0x63, 0x73, 0x1b, 0xd6,
	0x8a, 0x45, 0x29, 0x06, 0x4e, 0x9c, 0xd4, 0x9c, 0x89, 0xb0, 0xaa, 0x29, 0x91, 0x39, 0x2e, 0x5f,
	0x77, 0x49, 0x37, 0xa0, 0x6d, 0x47, 0xe2, 0x40, 0xf0, 0x97, 0xa8, 0x82, 0xc9, 0x80, 0xdd, 0x68,
	0x9a, 0xf6, 0x4f, 0x1e, 0xcd, 0x31, 0xe8, 0xd9, 0x4e, 0x27, 0x89, 0xfb, 0xbe, 0xc7, 0xd9, 0x84,
	0xa7, 0x8d, 0x14, 0x4c, 0xd4, 0x1f, 0x94, 0xd4, 0x2b, 0x6c, 0x7e, 0xd3, 0x60, 0x65, 0x8f, 0xf1,
	0xc9, 0xc7, 0x9c, 0x81, 0x6c, 0x83, 0xae, 0xaa, 0xaa, 0x7b, 0xb3, 0xe0, 0x20, 0x73, 0xc6, 0xdc,
	0x2c, 0x6a, 0x77, 0x98, 0x45, 0xfd, 0x6e, 0xb3, 0x68, 0xfc, 0xd2, 0x2c, 0x9a, 0x95, 0x66, 0x71,
	0x01, 0xcb, 0x47, 0xcc, 0x76, 0xd0, 0xa2, 0x38, 0xf1, 0x43, 0xeb, 0xf7, 0x3c, 0x6f, 0x1d, 0x5a,
	0x14, 0x59, 0xe4, 0x7b, 0xa9, 0xe2, 0x14, 0x99, 0x27, 0xd0, 0xcd, 0x46, 0x21, 0x3f, 0xc6, 0x08,
	0xfe, 0xc9, 0xb7, 0x51, 0xd3, 0x20, 0xb2, 0x76, 0xfe, 0x88, 0x16, 0x89, 0xe6, 0x63, 0x00, 0x8a,
	0xcc, 0x8a, 0xe5, 0x3d, 0xbd, 0x07, 0xba, 0x9a, 0xb8, 0xac, 0xa1, 0xd3, 0x79, 0xc0, 0xbc, 0x0f,
	0x1d, 0xc1, 0x3d, 0x9b, 0xf1, 0x84, 0xdc, 0x85, 0xda, 0xd9, 0x4d, 0xfa, 0xf1, 0x6b, 0x67, 0x37,
	0x3b, 0x9f, 0x1a, 0xa0, 0x27, 0x92, 0xc6, 0x53, 0xf4, 0x38, 0x79, 0x0a, 0x4d, 0x41, 0x26, 0xab,
	0x52, 0xc4, 0xbc, 0xcb, 0xa0, 0x97, 0x8b, 0xa4, 0xb5, 0x1e, 0x41, 0x23, 0x49, 0x55, 0xe4, 0xf9,
	0x47, 0x1e, 0x74, 0x64, 0x44, 0x5c, 0x5d, 0x32, 0x04, 0x3d, 0x5b, 0x17, 0x52, 0xb9, 0x3f, 0x45,
	0xfe, 0x08, 0xba, 0xc5, 0x75, 0x24, 0xff, 0xcb, 0xe3, 0x8a, 0x25, 0x2d, 0x66, 0xbe, 0x80, 0xe5,
	0xbc, 0xf9, 0x90, 0xff, 0xee, 0x30, 0xa4, 0x85, 0xac, 0xbc, 0x5f, 0xa8, 0xac, 0x05, 0x0f, 0x29,
	0x66, 0x1d, 0x41, 0xb7, 0xb8, 0x61, 0x4a, 0x65, 0xc5, 0xaf, 0x63, 0x50, 0x79, 0x24, 0x6f, 0xc1,
	0x5b, 0xe8, 0x16, 0x17, 0x9b, 0x0c, 0x52, 0xd5, 0x15, 0x1e, 0xa2, 0x0a, 0x55, 0x59, 0xc1, 0x08,
	0xf4, 0xec, 0x82, 0x91, 0x7f, 0x25, 0xaf, 0xb4, 0x7c, 0x83, 0x7e, 0x29, 0x2c, 0x32, 0xaf, 0x5b,
	0xe2, 0x7f, 0xff, 0xfc, 0x47, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa6, 0x44, 0xad, 0xbd, 0x04, 0x08,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SendAgentClient is the client API for SendAgent service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SendAgentClient interface {
	Ready(ctx context.Context, in *ReadyInput, opts ...grpc.CallOption) (*ReadyOutput, error)
	Send(ctx context.Context, in *SendParams, opts ...grpc.CallOption) (*Empty, error)
	AddConfig(ctx context.Context, in *AddConfigInput, opts ...grpc.CallOption) (*Empty, error)
	CompleteConfig(ctx context.Context, in *CompleteConfigInput, opts ...grpc.CallOption) (*Empty, error)
	UpdateConfig(ctx context.Context, in *UpdateConfigInput, opts ...grpc.CallOption) (*Empty, error)
	DeleteConfig(ctx context.Context, in *DeleteConfigInput, opts ...grpc.CallOption) (*Empty, error)
	ValidateConfig(ctx context.Context, in *ValidateConfigInput, opts ...grpc.CallOption) (*ValidateConfigReply, error)
	UseridByMobile(ctx context.Context, in *UseridByMobileParams, opts ...grpc.CallOption) (*UseridByMobileReply, error)
	BatchSend(ctx context.Context, in *BatchSendParams, opts ...grpc.CallOption) (*BatchSendReply, error)
}

type sendAgentClient struct {
	cc *grpc.ClientConn
}

func NewSendAgentClient(cc *grpc.ClientConn) SendAgentClient {
	return &sendAgentClient{cc}
}

func (c *sendAgentClient) Ready(ctx context.Context, in *ReadyInput, opts ...grpc.CallOption) (*ReadyOutput, error) {
	out := new(ReadyOutput)
	err := c.cc.Invoke(ctx, "/apis.SendAgent/Ready", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sendAgentClient) Send(ctx context.Context, in *SendParams, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/apis.SendAgent/Send", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sendAgentClient) AddConfig(ctx context.Context, in *AddConfigInput, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/apis.SendAgent/AddConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sendAgentClient) CompleteConfig(ctx context.Context, in *CompleteConfigInput, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/apis.SendAgent/CompleteConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sendAgentClient) UpdateConfig(ctx context.Context, in *UpdateConfigInput, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/apis.SendAgent/UpdateConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sendAgentClient) DeleteConfig(ctx context.Context, in *DeleteConfigInput, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/apis.SendAgent/DeleteConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sendAgentClient) ValidateConfig(ctx context.Context, in *ValidateConfigInput, opts ...grpc.CallOption) (*ValidateConfigReply, error) {
	out := new(ValidateConfigReply)
	err := c.cc.Invoke(ctx, "/apis.SendAgent/ValidateConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sendAgentClient) UseridByMobile(ctx context.Context, in *UseridByMobileParams, opts ...grpc.CallOption) (*UseridByMobileReply, error) {
	out := new(UseridByMobileReply)
	err := c.cc.Invoke(ctx, "/apis.SendAgent/UseridByMobile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sendAgentClient) BatchSend(ctx context.Context, in *BatchSendParams, opts ...grpc.CallOption) (*BatchSendReply, error) {
	out := new(BatchSendReply)
	err := c.cc.Invoke(ctx, "/apis.SendAgent/BatchSend", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SendAgentServer is the server API for SendAgent service.
type SendAgentServer interface {
	Ready(context.Context, *ReadyInput) (*ReadyOutput, error)
	Send(context.Context, *SendParams) (*Empty, error)
	AddConfig(context.Context, *AddConfigInput) (*Empty, error)
	CompleteConfig(context.Context, *CompleteConfigInput) (*Empty, error)
	UpdateConfig(context.Context, *UpdateConfigInput) (*Empty, error)
	DeleteConfig(context.Context, *DeleteConfigInput) (*Empty, error)
	ValidateConfig(context.Context, *ValidateConfigInput) (*ValidateConfigReply, error)
	UseridByMobile(context.Context, *UseridByMobileParams) (*UseridByMobileReply, error)
	BatchSend(context.Context, *BatchSendParams) (*BatchSendReply, error)
}

// UnimplementedSendAgentServer can be embedded to have forward compatible implementations.
type UnimplementedSendAgentServer struct {
}

func (*UnimplementedSendAgentServer) Ready(ctx context.Context, req *ReadyInput) (*ReadyOutput, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Ready not implemented")
}
func (*UnimplementedSendAgentServer) Send(ctx context.Context, req *SendParams) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Send not implemented")
}
func (*UnimplementedSendAgentServer) AddConfig(ctx context.Context, req *AddConfigInput) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddConfig not implemented")
}
func (*UnimplementedSendAgentServer) CompleteConfig(ctx context.Context, req *CompleteConfigInput) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CompleteConfig not implemented")
}
func (*UnimplementedSendAgentServer) UpdateConfig(ctx context.Context, req *UpdateConfigInput) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConfig not implemented")
}
func (*UnimplementedSendAgentServer) DeleteConfig(ctx context.Context, req *DeleteConfigInput) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConfig not implemented")
}
func (*UnimplementedSendAgentServer) ValidateConfig(ctx context.Context, req *ValidateConfigInput) (*ValidateConfigReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateConfig not implemented")
}
func (*UnimplementedSendAgentServer) UseridByMobile(ctx context.Context, req *UseridByMobileParams) (*UseridByMobileReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UseridByMobile not implemented")
}
func (*UnimplementedSendAgentServer) BatchSend(ctx context.Context, req *BatchSendParams) (*BatchSendReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchSend not implemented")
}

func RegisterSendAgentServer(s *grpc.Server, srv SendAgentServer) {
	s.RegisterService(&_SendAgent_serviceDesc, srv)
}

func _SendAgent_Ready_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadyInput)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SendAgentServer).Ready(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apis.SendAgent/Ready",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SendAgentServer).Ready(ctx, req.(*ReadyInput))
	}
	return interceptor(ctx, in, info, handler)
}

func _SendAgent_Send_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendParams)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SendAgentServer).Send(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apis.SendAgent/Send",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SendAgentServer).Send(ctx, req.(*SendParams))
	}
	return interceptor(ctx, in, info, handler)
}

func _SendAgent_AddConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddConfigInput)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SendAgentServer).AddConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apis.SendAgent/AddConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SendAgentServer).AddConfig(ctx, req.(*AddConfigInput))
	}
	return interceptor(ctx, in, info, handler)
}

func _SendAgent_CompleteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteConfigInput)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SendAgentServer).CompleteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apis.SendAgent/CompleteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SendAgentServer).CompleteConfig(ctx, req.(*CompleteConfigInput))
	}
	return interceptor(ctx, in, info, handler)
}

func _SendAgent_UpdateConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConfigInput)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SendAgentServer).UpdateConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apis.SendAgent/UpdateConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SendAgentServer).UpdateConfig(ctx, req.(*UpdateConfigInput))
	}
	return interceptor(ctx, in, info, handler)
}

func _SendAgent_DeleteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConfigInput)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SendAgentServer).DeleteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apis.SendAgent/DeleteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SendAgentServer).DeleteConfig(ctx, req.(*DeleteConfigInput))
	}
	return interceptor(ctx, in, info, handler)
}

func _SendAgent_ValidateConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateConfigInput)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SendAgentServer).ValidateConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apis.SendAgent/ValidateConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SendAgentServer).ValidateConfig(ctx, req.(*ValidateConfigInput))
	}
	return interceptor(ctx, in, info, handler)
}

func _SendAgent_UseridByMobile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UseridByMobileParams)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SendAgentServer).UseridByMobile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apis.SendAgent/UseridByMobile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SendAgentServer).UseridByMobile(ctx, req.(*UseridByMobileParams))
	}
	return interceptor(ctx, in, info, handler)
}

func _SendAgent_BatchSend_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchSendParams)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SendAgentServer).BatchSend(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apis.SendAgent/BatchSend",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SendAgentServer).BatchSend(ctx, req.(*BatchSendParams))
	}
	return interceptor(ctx, in, info, handler)
}

var _SendAgent_serviceDesc = grpc.ServiceDesc{
	ServiceName: "apis.SendAgent",
	HandlerType: (*SendAgentServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Ready",
			Handler:    _SendAgent_Ready_Handler,
		},
		{
			MethodName: "Send",
			Handler:    _SendAgent_Send_Handler,
		},
		{
			MethodName: "AddConfig",
			Handler:    _SendAgent_AddConfig_Handler,
		},
		{
			MethodName: "CompleteConfig",
			Handler:    _SendAgent_CompleteConfig_Handler,
		},
		{
			MethodName: "UpdateConfig",
			Handler:    _SendAgent_UpdateConfig_Handler,
		},
		{
			MethodName: "DeleteConfig",
			Handler:    _SendAgent_DeleteConfig_Handler,
		},
		{
			MethodName: "ValidateConfig",
			Handler:    _SendAgent_ValidateConfig_Handler,
		},
		{
			MethodName: "UseridByMobile",
			Handler:    _SendAgent_UseridByMobile_Handler,
		},
		{
			MethodName: "BatchSend",
			Handler:    _SendAgent_BatchSend_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "send_server.proto",
}
