// Copyright 2019 Yunion
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package procutils

import (
	"reflect"
	"testing"
)

func Test_parseProcCmdline(t *testing.T) {
	tests := []struct {
		name    string
		content []byte
		want    []string
	}{
		{
			name:    "",
			content: []byte{0x2f, 0x75, 0x73, 0x72, 0x2f, 0x62, 0x69, 0x6e, 0x2f, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x0, 0x2f, 0x75, 0x73, 0x72, 0x2f, 0x62, 0x69, 0x6e, 0x2f, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x2d, 0x67, 0x6e, 0x6f, 0x6d, 0x65, 0x2d, 0x73, 0x68, 0x65, 0x6c, 0x6c, 0x0, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x2d, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x3a, 0x2f, 0x2f, 0x67, 0x70, 0x68, 0x68, 0x61, 0x70, 0x6d, 0x65, 0x6a, 0x6f, 0x62, 0x69, 0x6a, 0x62, 0x62, 0x68, 0x67, 0x70, 0x6a, 0x68, 0x63, 0x6a, 0x6f, 0x67, 0x6e, 0x6c, 0x61, 0x68, 0x62, 0x6c, 0x65, 0x70, 0x2f, 0x0},
			want: []string{
				"/usr/bin/python",
				"/usr/bin/chrome-gnome-shell",
				"chrome-extension://gphhapmejobijbbhgpjhcjognlahblep/",
			},
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if got := parseProcCmdline(tt.content); !reflect.DeepEqual(got, tt.want) {
				t.Errorf("parseProcCmdline() = %v, want %v", got, tt.want)
			}
		})
	}
}
