package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAutoProvisioningGroup invokes the ecs.DeleteAutoProvisioningGroup API synchronously
func (client *Client) DeleteAutoProvisioningGroup(request *DeleteAutoProvisioningGroupRequest) (response *DeleteAutoProvisioningGroupResponse, err error) {
	response = CreateDeleteAutoProvisioningGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAutoProvisioningGroupWithChan invokes the ecs.DeleteAutoProvisioningGroup API asynchronously
func (client *Client) DeleteAutoProvisioningGroupWithChan(request *DeleteAutoProvisioningGroupRequest) (<-chan *DeleteAutoProvisioningGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteAutoProvisioningGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAutoProvisioningGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAutoProvisioningGroupWithCallback invokes the ecs.DeleteAutoProvisioningGroup API asynchronously
func (client *Client) DeleteAutoProvisioningGroupWithCallback(request *DeleteAutoProvisioningGroupRequest, callback func(response *DeleteAutoProvisioningGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAutoProvisioningGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteAutoProvisioningGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAutoProvisioningGroupRequest is the request struct for api DeleteAutoProvisioningGroup
type DeleteAutoProvisioningGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId         requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TerminateInstances      requests.Boolean `position:"Query" name:"TerminateInstances"`
	ResourceOwnerAccount    string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount            string           `position:"Query" name:"OwnerAccount"`
	OwnerId                 requests.Integer `position:"Query" name:"OwnerId"`
	AutoProvisioningGroupId string           `position:"Query" name:"AutoProvisioningGroupId"`
}

// DeleteAutoProvisioningGroupResponse is the response struct for api DeleteAutoProvisioningGroup
type DeleteAutoProvisioningGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteAutoProvisioningGroupRequest creates a request to invoke DeleteAutoProvisioningGroup API
func CreateDeleteAutoProvisioningGroupRequest() (request *DeleteAutoProvisioningGroupRequest) {
	request = &DeleteAutoProvisioningGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DeleteAutoProvisioningGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteAutoProvisioningGroupResponse creates a response to parse from DeleteAutoProvisioningGroup response
func CreateDeleteAutoProvisioningGroupResponse() (response *DeleteAutoProvisioningGroupResponse) {
	response = &DeleteAutoProvisioningGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
