package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLaunchTemplateVersion invokes the ecs.DeleteLaunchTemplateVersion API synchronously
func (client *Client) DeleteLaunchTemplateVersion(request *DeleteLaunchTemplateVersionRequest) (response *DeleteLaunchTemplateVersionResponse, err error) {
	response = CreateDeleteLaunchTemplateVersionResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLaunchTemplateVersionWithChan invokes the ecs.DeleteLaunchTemplateVersion API asynchronously
func (client *Client) DeleteLaunchTemplateVersionWithChan(request *DeleteLaunchTemplateVersionRequest) (<-chan *DeleteLaunchTemplateVersionResponse, <-chan error) {
	responseChan := make(chan *DeleteLaunchTemplateVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLaunchTemplateVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLaunchTemplateVersionWithCallback invokes the ecs.DeleteLaunchTemplateVersion API asynchronously
func (client *Client) DeleteLaunchTemplateVersionWithCallback(request *DeleteLaunchTemplateVersionRequest, callback func(response *DeleteLaunchTemplateVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLaunchTemplateVersionResponse
		var err error
		defer close(result)
		response, err = client.DeleteLaunchTemplateVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLaunchTemplateVersionRequest is the request struct for api DeleteLaunchTemplateVersion
type DeleteLaunchTemplateVersionRequest struct {
	*requests.RpcRequest
	LaunchTemplateName   string           `position:"Query" name:"LaunchTemplateName"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DeleteVersion        *[]string        `position:"Query" name:"DeleteVersion"  type:"Repeated"`
	LaunchTemplateId     string           `position:"Query" name:"LaunchTemplateId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteLaunchTemplateVersionResponse is the response struct for api DeleteLaunchTemplateVersion
type DeleteLaunchTemplateVersionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLaunchTemplateVersionRequest creates a request to invoke DeleteLaunchTemplateVersion API
func CreateDeleteLaunchTemplateVersionRequest() (request *DeleteLaunchTemplateVersionRequest) {
	request = &DeleteLaunchTemplateVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DeleteLaunchTemplateVersion", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteLaunchTemplateVersionResponse creates a response to parse from DeleteLaunchTemplateVersion response
func CreateDeleteLaunchTemplateVersionResponse() (response *DeleteLaunchTemplateVersionResponse) {
	response = &DeleteLaunchTemplateVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
