package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeElasticityAssuranceInstances invokes the ecs.DescribeElasticityAssuranceInstances API synchronously
func (client *Client) DescribeElasticityAssuranceInstances(request *DescribeElasticityAssuranceInstancesRequest) (response *DescribeElasticityAssuranceInstancesResponse, err error) {
	response = CreateDescribeElasticityAssuranceInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeElasticityAssuranceInstancesWithChan invokes the ecs.DescribeElasticityAssuranceInstances API asynchronously
func (client *Client) DescribeElasticityAssuranceInstancesWithChan(request *DescribeElasticityAssuranceInstancesRequest) (<-chan *DescribeElasticityAssuranceInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeElasticityAssuranceInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeElasticityAssuranceInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeElasticityAssuranceInstancesWithCallback invokes the ecs.DescribeElasticityAssuranceInstances API asynchronously
func (client *Client) DescribeElasticityAssuranceInstancesWithCallback(request *DescribeElasticityAssuranceInstancesRequest, callback func(response *DescribeElasticityAssuranceInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeElasticityAssuranceInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeElasticityAssuranceInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeElasticityAssuranceInstancesRequest is the request struct for api DescribeElasticityAssuranceInstances
type DescribeElasticityAssuranceInstancesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NextToken            string           `position:"Query" name:"NextToken"`
	PrivatePoolOptionsId string           `position:"Query" name:"PrivatePoolOptions.Id"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	MaxResults           requests.Integer `position:"Query" name:"MaxResults"`
	PackageType          string           `position:"Query" name:"PackageType"`
}

// DescribeElasticityAssuranceInstancesResponse is the response struct for api DescribeElasticityAssuranceInstances
type DescribeElasticityAssuranceInstancesResponse struct {
	*responses.BaseResponse
	RequestId               string                                                        `json:"RequestId" xml:"RequestId"`
	NextToken               string                                                        `json:"NextToken" xml:"NextToken"`
	MaxResults              int                                                           `json:"MaxResults" xml:"MaxResults"`
	TotalCount              int                                                           `json:"TotalCount" xml:"TotalCount"`
	ElasticityAssuranceItem ElasticityAssuranceItemInDescribeElasticityAssuranceInstances `json:"ElasticityAssuranceItem" xml:"ElasticityAssuranceItem"`
}

// CreateDescribeElasticityAssuranceInstancesRequest creates a request to invoke DescribeElasticityAssuranceInstances API
func CreateDescribeElasticityAssuranceInstancesRequest() (request *DescribeElasticityAssuranceInstancesRequest) {
	request = &DescribeElasticityAssuranceInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeElasticityAssuranceInstances", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeElasticityAssuranceInstancesResponse creates a response to parse from DescribeElasticityAssuranceInstances response
func CreateDescribeElasticityAssuranceInstancesResponse() (response *DescribeElasticityAssuranceInstancesResponse) {
	response = &DescribeElasticityAssuranceInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
