package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCommand invokes the ecs.ModifyCommand API synchronously
func (client *Client) ModifyCommand(request *ModifyCommandRequest) (response *ModifyCommandResponse, err error) {
	response = CreateModifyCommandResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCommandWithChan invokes the ecs.ModifyCommand API asynchronously
func (client *Client) ModifyCommandWithChan(request *ModifyCommandRequest) (<-chan *ModifyCommandResponse, <-chan error) {
	responseChan := make(chan *ModifyCommandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCommand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCommandWithCallback invokes the ecs.ModifyCommand API asynchronously
func (client *Client) ModifyCommandWithCallback(request *ModifyCommandRequest, callback func(response *ModifyCommandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCommandResponse
		var err error
		defer close(result)
		response, err = client.ModifyCommand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCommandRequest is the request struct for api ModifyCommand
type ModifyCommandRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	WorkingDir           string           `position:"Query" name:"WorkingDir"`
	Description          string           `position:"Query" name:"Description"`
	CommandId            string           `position:"Query" name:"CommandId"`
	CommandContent       string           `position:"Query" name:"CommandContent"`
	Timeout              requests.Integer `position:"Query" name:"Timeout"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Name                 string           `position:"Query" name:"Name"`
}

// ModifyCommandResponse is the response struct for api ModifyCommand
type ModifyCommandResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyCommandRequest creates a request to invoke ModifyCommand API
func CreateModifyCommandRequest() (request *ModifyCommandRequest) {
	request = &ModifyCommandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ModifyCommand", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyCommandResponse creates a response to parse from ModifyCommand response
func CreateModifyCommandResponse() (response *ModifyCommandResponse) {
	response = &ModifyCommandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
