package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDedicatedHostsChargeType invokes the ecs.ModifyDedicatedHostsChargeType API synchronously
func (client *Client) ModifyDedicatedHostsChargeType(request *ModifyDedicatedHostsChargeTypeRequest) (response *ModifyDedicatedHostsChargeTypeResponse, err error) {
	response = CreateModifyDedicatedHostsChargeTypeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDedicatedHostsChargeTypeWithChan invokes the ecs.ModifyDedicatedHostsChargeType API asynchronously
func (client *Client) ModifyDedicatedHostsChargeTypeWithChan(request *ModifyDedicatedHostsChargeTypeRequest) (<-chan *ModifyDedicatedHostsChargeTypeResponse, <-chan error) {
	responseChan := make(chan *ModifyDedicatedHostsChargeTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDedicatedHostsChargeType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDedicatedHostsChargeTypeWithCallback invokes the ecs.ModifyDedicatedHostsChargeType API asynchronously
func (client *Client) ModifyDedicatedHostsChargeTypeWithCallback(request *ModifyDedicatedHostsChargeTypeRequest, callback func(response *ModifyDedicatedHostsChargeTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDedicatedHostsChargeTypeResponse
		var err error
		defer close(result)
		response, err = client.ModifyDedicatedHostsChargeType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDedicatedHostsChargeTypeRequest is the request struct for api ModifyDedicatedHostsChargeType
type ModifyDedicatedHostsChargeTypeRequest struct {
	*requests.RpcRequest
	DedicatedHostIds        string           `position:"Query" name:"DedicatedHostIds"`
	ResourceOwnerId         requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken             string           `position:"Query" name:"ClientToken"`
	DedicatedHostChargeType string           `position:"Query" name:"DedicatedHostChargeType"`
	Period                  requests.Integer `position:"Query" name:"Period"`
	DryRun                  requests.Boolean `position:"Query" name:"DryRun"`
	AutoPay                 requests.Boolean `position:"Query" name:"AutoPay"`
	ResourceOwnerAccount    string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount            string           `position:"Query" name:"OwnerAccount"`
	OwnerId                 requests.Integer `position:"Query" name:"OwnerId"`
	DetailFee               requests.Boolean `position:"Query" name:"DetailFee"`
	PeriodUnit              string           `position:"Query" name:"PeriodUnit"`
}

// ModifyDedicatedHostsChargeTypeResponse is the response struct for api ModifyDedicatedHostsChargeType
type ModifyDedicatedHostsChargeTypeResponse struct {
	*responses.BaseResponse
	RequestId      string                                         `json:"RequestId" xml:"RequestId"`
	OrderId        string                                         `json:"OrderId" xml:"OrderId"`
	FeeOfInstances FeeOfInstancesInModifyDedicatedHostsChargeType `json:"FeeOfInstances" xml:"FeeOfInstances"`
}

// CreateModifyDedicatedHostsChargeTypeRequest creates a request to invoke ModifyDedicatedHostsChargeType API
func CreateModifyDedicatedHostsChargeTypeRequest() (request *ModifyDedicatedHostsChargeTypeRequest) {
	request = &ModifyDedicatedHostsChargeTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ModifyDedicatedHostsChargeType", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyDedicatedHostsChargeTypeResponse creates a response to parse from ModifyDedicatedHostsChargeType response
func CreateModifyDedicatedHostsChargeTypeResponse() (response *ModifyDedicatedHostsChargeTypeResponse) {
	response = &ModifyDedicatedHostsChargeTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
