package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyStorageSetAttribute invokes the ecs.ModifyStorageSetAttribute API synchronously
func (client *Client) ModifyStorageSetAttribute(request *ModifyStorageSetAttributeRequest) (response *ModifyStorageSetAttributeResponse, err error) {
	response = CreateModifyStorageSetAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyStorageSetAttributeWithChan invokes the ecs.ModifyStorageSetAttribute API asynchronously
func (client *Client) ModifyStorageSetAttributeWithChan(request *ModifyStorageSetAttributeRequest) (<-chan *ModifyStorageSetAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyStorageSetAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyStorageSetAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyStorageSetAttributeWithCallback invokes the ecs.ModifyStorageSetAttribute API asynchronously
func (client *Client) ModifyStorageSetAttributeWithCallback(request *ModifyStorageSetAttributeRequest, callback func(response *ModifyStorageSetAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyStorageSetAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyStorageSetAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyStorageSetAttributeRequest is the request struct for api ModifyStorageSetAttribute
type ModifyStorageSetAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	Description          string           `position:"Query" name:"Description"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	StorageSetId         string           `position:"Query" name:"StorageSetId"`
	StorageSetName       string           `position:"Query" name:"StorageSetName"`
}

// ModifyStorageSetAttributeResponse is the response struct for api ModifyStorageSetAttribute
type ModifyStorageSetAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyStorageSetAttributeRequest creates a request to invoke ModifyStorageSetAttribute API
func CreateModifyStorageSetAttributeRequest() (request *ModifyStorageSetAttributeRequest) {
	request = &ModifyStorageSetAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ModifyStorageSetAttribute", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyStorageSetAttributeResponse creates a response to parse from ModifyStorageSetAttribute response
func CreateModifyStorageSetAttributeResponse() (response *ModifyStorageSetAttributeResponse) {
	response = &ModifyStorageSetAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
