// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    disk "github.com/jdcloud-api/jdcloud-sdk-go/services/disk/models"
)

type CreateDisksRequest struct {

    core.JDCloudRequest

    /* 地域ID  */
    RegionId string `json:"regionId"`

    /* 创建云硬盘规格  */
    DiskSpec *disk.DiskSpec `json:"diskSpec"`

    /* 购买实例数量；取值范围：[1,100]  */
    MaxCount int `json:"maxCount"`

    /* 用户标签 (Optional) */
    UserTags []disk.Tag `json:"userTags"`

    /* 幂等性校验参数  */
    ClientToken string `json:"clientToken"`
}

/*
 * param regionId: 地域ID (Required)
 * param diskSpec: 创建云硬盘规格 (Required)
 * param maxCount: 购买实例数量；取值范围：[1,100] (Required)
 * param clientToken: 幂等性校验参数 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewCreateDisksRequest(
    regionId string,
    diskSpec *disk.DiskSpec,
    maxCount int,
    clientToken string,
) *CreateDisksRequest {

	return &CreateDisksRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/disks",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        DiskSpec: diskSpec,
        MaxCount: maxCount,
        ClientToken: clientToken,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param diskSpec: 创建云硬盘规格 (Required)
 * param maxCount: 购买实例数量；取值范围：[1,100] (Required)
 * param userTags: 用户标签 (Optional)
 * param clientToken: 幂等性校验参数 (Required)
 */
func NewCreateDisksRequestWithAllParams(
    regionId string,
    diskSpec *disk.DiskSpec,
    maxCount int,
    userTags []disk.Tag,
    clientToken string,
) *CreateDisksRequest {

    return &CreateDisksRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/disks",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        DiskSpec: diskSpec,
        MaxCount: maxCount,
        UserTags: userTags,
        ClientToken: clientToken,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewCreateDisksRequestWithoutParam() *CreateDisksRequest {

    return &CreateDisksRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/disks",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域ID(Required) */
func (r *CreateDisksRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param diskSpec: 创建云硬盘规格(Required) */
func (r *CreateDisksRequest) SetDiskSpec(diskSpec *disk.DiskSpec) {
    r.DiskSpec = diskSpec
}

/* param maxCount: 购买实例数量；取值范围：[1,100](Required) */
func (r *CreateDisksRequest) SetMaxCount(maxCount int) {
    r.MaxCount = maxCount
}

/* param userTags: 用户标签(Optional) */
func (r *CreateDisksRequest) SetUserTags(userTags []disk.Tag) {
    r.UserTags = userTags
}

/* param clientToken: 幂等性校验参数(Required) */
func (r *CreateDisksRequest) SetClientToken(clientToken string) {
    r.ClientToken = clientToken
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r CreateDisksRequest) GetRegionId() string {
    return r.RegionId
}

type CreateDisksResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result CreateDisksResult `json:"result"`
}

type CreateDisksResult struct {
    PolicyRelations []disk.PolicyDiskRelationOpResult `json:"policyRelations"`
    DiskIds []string `json:"diskIds"`
    Tagmsg string `json:"tagmsg"`
}