// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    disk "github.com/jdcloud-api/jdcloud-sdk-go/services/disk/models"
)

type CreateSnapshotRequest struct {

    core.JDCloudRequest

    /* 地域ID  */
    RegionId string `json:"regionId"`

    /* 创建快照规格  */
    SnapshotSpec *disk.SnapshotSpec `json:"snapshotSpec"`

    /* 幂等性校验参数  */
    ClientToken string `json:"clientToken"`
}

/*
 * param regionId: 地域ID (Required)
 * param snapshotSpec: 创建快照规格 (Required)
 * param clientToken: 幂等性校验参数 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewCreateSnapshotRequest(
    regionId string,
    snapshotSpec *disk.SnapshotSpec,
    clientToken string,
) *CreateSnapshotRequest {

	return &CreateSnapshotRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/snapshots",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        SnapshotSpec: snapshotSpec,
        ClientToken: clientToken,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param snapshotSpec: 创建快照规格 (Required)
 * param clientToken: 幂等性校验参数 (Required)
 */
func NewCreateSnapshotRequestWithAllParams(
    regionId string,
    snapshotSpec *disk.SnapshotSpec,
    clientToken string,
) *CreateSnapshotRequest {

    return &CreateSnapshotRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/snapshots",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        SnapshotSpec: snapshotSpec,
        ClientToken: clientToken,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewCreateSnapshotRequestWithoutParam() *CreateSnapshotRequest {

    return &CreateSnapshotRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/snapshots",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域ID(Required) */
func (r *CreateSnapshotRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param snapshotSpec: 创建快照规格(Required) */
func (r *CreateSnapshotRequest) SetSnapshotSpec(snapshotSpec *disk.SnapshotSpec) {
    r.SnapshotSpec = snapshotSpec
}

/* param clientToken: 幂等性校验参数(Required) */
func (r *CreateSnapshotRequest) SetClientToken(clientToken string) {
    r.ClientToken = clientToken
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r CreateSnapshotRequest) GetRegionId() string {
    return r.RegionId
}

type CreateSnapshotResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result CreateSnapshotResult `json:"result"`
}

type CreateSnapshotResult struct {
    SnapshotId string `json:"snapshotId"`
}