// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    disk "github.com/jdcloud-api/jdcloud-sdk-go/services/disk/models"
)

type DeleteSnapshotsRequest struct {

    core.JDCloudRequest

    /* 地域ID  */
    RegionId string `json:"regionId"`

    /* 快照ID列表  */
    SnapshotIds []string `json:"snapshotIds"`
}

/*
 * param regionId: 地域ID (Required)
 * param snapshotIds: 快照ID列表 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDeleteSnapshotsRequest(
    regionId string,
    snapshotIds []string,
) *DeleteSnapshotsRequest {

	return &DeleteSnapshotsRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/snapshots",
			Method:  "DELETE",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        SnapshotIds: snapshotIds,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param snapshotIds: 快照ID列表 (Required)
 */
func NewDeleteSnapshotsRequestWithAllParams(
    regionId string,
    snapshotIds []string,
) *DeleteSnapshotsRequest {

    return &DeleteSnapshotsRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/snapshots",
            Method:  "DELETE",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        SnapshotIds: snapshotIds,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDeleteSnapshotsRequestWithoutParam() *DeleteSnapshotsRequest {

    return &DeleteSnapshotsRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/snapshots",
            Method:  "DELETE",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域ID(Required) */
func (r *DeleteSnapshotsRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param snapshotIds: 快照ID列表(Required) */
func (r *DeleteSnapshotsRequest) SetSnapshotIds(snapshotIds []string) {
    r.SnapshotIds = snapshotIds
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DeleteSnapshotsRequest) GetRegionId() string {
    return r.RegionId
}

type DeleteSnapshotsResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DeleteSnapshotsResult `json:"result"`
}

type DeleteSnapshotsResult struct {
    Snapshots []disk.DelSnapshot `json:"snapshots"`
    SuccessCount int `json:"successCount"`
    FailedCount int `json:"failedCount"`
}