// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type DescribeSnapshotChainRequest struct {

    core.JDCloudRequest

    /* 地域ID  */
    RegionId string `json:"regionId"`

    /* 云硬盘ID (Optional) */
    DiskId *string `json:"diskId"`

    /* 快照ID (Optional) */
    SnapshotId *string `json:"snapshotId"`
}

/*
 * param regionId: 地域ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDescribeSnapshotChainRequest(
    regionId string,
) *DescribeSnapshotChainRequest {

	return &DescribeSnapshotChainRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/snapshots:chain",
			Method:  "GET",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param diskId: 云硬盘ID (Optional)
 * param snapshotId: 快照ID (Optional)
 */
func NewDescribeSnapshotChainRequestWithAllParams(
    regionId string,
    diskId *string,
    snapshotId *string,
) *DescribeSnapshotChainRequest {

    return &DescribeSnapshotChainRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/snapshots:chain",
            Method:  "GET",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        DiskId: diskId,
        SnapshotId: snapshotId,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDescribeSnapshotChainRequestWithoutParam() *DescribeSnapshotChainRequest {

    return &DescribeSnapshotChainRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/snapshots:chain",
            Method:  "GET",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域ID(Required) */
func (r *DescribeSnapshotChainRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param diskId: 云硬盘ID(Optional) */
func (r *DescribeSnapshotChainRequest) SetDiskId(diskId string) {
    r.DiskId = &diskId
}

/* param snapshotId: 快照ID(Optional) */
func (r *DescribeSnapshotChainRequest) SetSnapshotId(snapshotId string) {
    r.SnapshotId = &snapshotId
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DescribeSnapshotChainRequest) GetRegionId() string {
    return r.RegionId
}

type DescribeSnapshotChainResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DescribeSnapshotChainResult `json:"result"`
}

type DescribeSnapshotChainResult struct {
    SnapshotChain interface{} `json:"snapshotChain"`
}