// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    disk "github.com/jdcloud-api/jdcloud-sdk-go/services/disk/models"
)

type DescribeSnapshotPolicyDiskRelationsRequest struct {

    core.JDCloudRequest

    /* 地域ID  */
    RegionId string `json:"regionId"`

    /* 磁盘ID (Optional) */
    DiskId []string `json:"diskId"`

    /* 磁盘地域ID (Optional) */
    DiskRegion []string `json:"diskRegion"`

    /* 策略ID (Optional) */
    PolicyId []string `json:"policyId"`

    /* 页码, 默认为1, 取值范围：[1,∞) (Optional) */
    PageNumber *int `json:"pageNumber"`

    /* 分页大小，默认为20，取值范围：[10,100] (Optional) */
    PageSize *int `json:"pageSize"`
}

/*
 * param regionId: 地域ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDescribeSnapshotPolicyDiskRelationsRequest(
    regionId string,
) *DescribeSnapshotPolicyDiskRelationsRequest {

	return &DescribeSnapshotPolicyDiskRelationsRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/snapshotPolicyDiskRelations:describe",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param diskId: 磁盘ID (Optional)
 * param diskRegion: 磁盘地域ID (Optional)
 * param policyId: 策略ID (Optional)
 * param pageNumber: 页码, 默认为1, 取值范围：[1,∞) (Optional)
 * param pageSize: 分页大小，默认为20，取值范围：[10,100] (Optional)
 */
func NewDescribeSnapshotPolicyDiskRelationsRequestWithAllParams(
    regionId string,
    diskId []string,
    diskRegion []string,
    policyId []string,
    pageNumber *int,
    pageSize *int,
) *DescribeSnapshotPolicyDiskRelationsRequest {

    return &DescribeSnapshotPolicyDiskRelationsRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/snapshotPolicyDiskRelations:describe",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        DiskId: diskId,
        DiskRegion: diskRegion,
        PolicyId: policyId,
        PageNumber: pageNumber,
        PageSize: pageSize,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDescribeSnapshotPolicyDiskRelationsRequestWithoutParam() *DescribeSnapshotPolicyDiskRelationsRequest {

    return &DescribeSnapshotPolicyDiskRelationsRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/snapshotPolicyDiskRelations:describe",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域ID(Required) */
func (r *DescribeSnapshotPolicyDiskRelationsRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param diskId: 磁盘ID(Optional) */
func (r *DescribeSnapshotPolicyDiskRelationsRequest) SetDiskId(diskId []string) {
    r.DiskId = diskId
}

/* param diskRegion: 磁盘地域ID(Optional) */
func (r *DescribeSnapshotPolicyDiskRelationsRequest) SetDiskRegion(diskRegion []string) {
    r.DiskRegion = diskRegion
}

/* param policyId: 策略ID(Optional) */
func (r *DescribeSnapshotPolicyDiskRelationsRequest) SetPolicyId(policyId []string) {
    r.PolicyId = policyId
}

/* param pageNumber: 页码, 默认为1, 取值范围：[1,∞)(Optional) */
func (r *DescribeSnapshotPolicyDiskRelationsRequest) SetPageNumber(pageNumber int) {
    r.PageNumber = &pageNumber
}

/* param pageSize: 分页大小，默认为20，取值范围：[10,100](Optional) */
func (r *DescribeSnapshotPolicyDiskRelationsRequest) SetPageSize(pageSize int) {
    r.PageSize = &pageSize
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DescribeSnapshotPolicyDiskRelationsRequest) GetRegionId() string {
    return r.RegionId
}

type DescribeSnapshotPolicyDiskRelationsResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DescribeSnapshotPolicyDiskRelationsResult `json:"result"`
}

type DescribeSnapshotPolicyDiskRelationsResult struct {
    TotalCount int `json:"totalCount"`
    RelationResults []disk.DescSnapshotRelationsData `json:"relationResults"`
}