// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    disk "github.com/jdcloud-api/jdcloud-sdk-go/services/disk/models"
    common "github.com/jdcloud-api/jdcloud-sdk-go/services/common/models"
)

type DescribeSnapshotsRequest struct {

    core.JDCloudRequest

    /* 地域ID  */
    RegionId string `json:"regionId"`

    /* 页码, 默认为1, 取值范围：[1,∞) (Optional) */
    PageNumber *int `json:"pageNumber"`

    /* 分页大小，默认为20，取值范围：[10,100] (Optional) */
    PageSize *int `json:"pageSize"`

    /* 查找快照的类型，可以为private，others，shared，默认为private (Optional) */
    SnapshotSource *string `json:"snapshotSource"`

    /* snapshotId - 云硬盘快照ID，支持多个
diskId - 生成快照的云硬盘ID，支持多个
status - 快照状态，精确匹配，支持多个,取值为 creating、available、copying、deleting、error_create、error_delete
name - 快照名称，模糊匹配，支持单个
 (Optional) */
    Filters []common.Filter `json:"filters"`
}

/*
 * param regionId: 地域ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDescribeSnapshotsRequest(
    regionId string,
) *DescribeSnapshotsRequest {

	return &DescribeSnapshotsRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/snapshots",
			Method:  "GET",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param pageNumber: 页码, 默认为1, 取值范围：[1,∞) (Optional)
 * param pageSize: 分页大小，默认为20，取值范围：[10,100] (Optional)
 * param snapshotSource: 查找快照的类型，可以为private，others，shared，默认为private (Optional)
 * param filters: snapshotId - 云硬盘快照ID，支持多个
diskId - 生成快照的云硬盘ID，支持多个
status - 快照状态，精确匹配，支持多个,取值为 creating、available、copying、deleting、error_create、error_delete
name - 快照名称，模糊匹配，支持单个
 (Optional)
 */
func NewDescribeSnapshotsRequestWithAllParams(
    regionId string,
    pageNumber *int,
    pageSize *int,
    snapshotSource *string,
    filters []common.Filter,
) *DescribeSnapshotsRequest {

    return &DescribeSnapshotsRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/snapshots",
            Method:  "GET",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        PageNumber: pageNumber,
        PageSize: pageSize,
        SnapshotSource: snapshotSource,
        Filters: filters,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDescribeSnapshotsRequestWithoutParam() *DescribeSnapshotsRequest {

    return &DescribeSnapshotsRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/snapshots",
            Method:  "GET",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域ID(Required) */
func (r *DescribeSnapshotsRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param pageNumber: 页码, 默认为1, 取值范围：[1,∞)(Optional) */
func (r *DescribeSnapshotsRequest) SetPageNumber(pageNumber int) {
    r.PageNumber = &pageNumber
}

/* param pageSize: 分页大小，默认为20，取值范围：[10,100](Optional) */
func (r *DescribeSnapshotsRequest) SetPageSize(pageSize int) {
    r.PageSize = &pageSize
}

/* param snapshotSource: 查找快照的类型，可以为private，others，shared，默认为private(Optional) */
func (r *DescribeSnapshotsRequest) SetSnapshotSource(snapshotSource string) {
    r.SnapshotSource = &snapshotSource
}

/* param filters: snapshotId - 云硬盘快照ID，支持多个
diskId - 生成快照的云硬盘ID，支持多个
status - 快照状态，精确匹配，支持多个,取值为 creating、available、copying、deleting、error_create、error_delete
name - 快照名称，模糊匹配，支持单个
(Optional) */
func (r *DescribeSnapshotsRequest) SetFilters(filters []common.Filter) {
    r.Filters = filters
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DescribeSnapshotsRequest) GetRegionId() string {
    return r.RegionId
}

type DescribeSnapshotsResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DescribeSnapshotsResult `json:"result"`
}

type DescribeSnapshotsResult struct {
    Snapshots []disk.Snapshot `json:"snapshots"`
    TotalCount int `json:"totalCount"`
}