// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type ExtendDiskRequest struct {

    core.JDCloudRequest

    /* 地域ID  */
    RegionId string `json:"regionId"`

    /* 云硬盘ID  */
    DiskId string `json:"diskId"`

    /* 扩容后的云硬盘大小，单位为GiB  */
    DiskSizeGB int `json:"diskSizeGB"`

    /* 修改ssd.io1型云硬盘的iops数量，当且仅当ssd.io1型的云盘类型有效，步长是10. (Optional) */
    Iops *int `json:"iops"`
}

/*
 * param regionId: 地域ID (Required)
 * param diskId: 云硬盘ID (Required)
 * param diskSizeGB: 扩容后的云硬盘大小，单位为GiB (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewExtendDiskRequest(
    regionId string,
    diskId string,
    diskSizeGB int,
) *ExtendDiskRequest {

	return &ExtendDiskRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/disks/{diskId}:extend",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        DiskId: diskId,
        DiskSizeGB: diskSizeGB,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param diskId: 云硬盘ID (Required)
 * param diskSizeGB: 扩容后的云硬盘大小，单位为GiB (Required)
 * param iops: 修改ssd.io1型云硬盘的iops数量，当且仅当ssd.io1型的云盘类型有效，步长是10. (Optional)
 */
func NewExtendDiskRequestWithAllParams(
    regionId string,
    diskId string,
    diskSizeGB int,
    iops *int,
) *ExtendDiskRequest {

    return &ExtendDiskRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/disks/{diskId}:extend",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        DiskId: diskId,
        DiskSizeGB: diskSizeGB,
        Iops: iops,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewExtendDiskRequestWithoutParam() *ExtendDiskRequest {

    return &ExtendDiskRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/disks/{diskId}:extend",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域ID(Required) */
func (r *ExtendDiskRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param diskId: 云硬盘ID(Required) */
func (r *ExtendDiskRequest) SetDiskId(diskId string) {
    r.DiskId = diskId
}

/* param diskSizeGB: 扩容后的云硬盘大小，单位为GiB(Required) */
func (r *ExtendDiskRequest) SetDiskSizeGB(diskSizeGB int) {
    r.DiskSizeGB = diskSizeGB
}

/* param iops: 修改ssd.io1型云硬盘的iops数量，当且仅当ssd.io1型的云盘类型有效，步长是10.(Optional) */
func (r *ExtendDiskRequest) SetIops(iops int) {
    r.Iops = &iops
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r ExtendDiskRequest) GetRegionId() string {
    return r.RegionId
}

type ExtendDiskResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result ExtendDiskResult `json:"result"`
}

type ExtendDiskResult struct {
}