// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    disk "github.com/jdcloud-api/jdcloud-sdk-go/services/disk/models"
)

type UpdateSnapshotPolicyRequest struct {

    core.JDCloudRequest

    /* 地域ID  */
    RegionId string `json:"regionId"`

    /* 策略ID  */
    PolicyId string `json:"policyId"`

    /* 策略名称  */
    Name string `json:"name"`

    /* 策略执行周期，单位:秒，不小于12小时  */
    Interval int `json:"interval"`

    /* 策略生效时间，格式`YYYY-MM-DDTHH:mm:ss+xx:xx`。如`2020-02-02T20:02:00+08:00`  */
    EffectiveTime string `json:"effectiveTime"`

    /* 快照保留时间，单位:秒，0:表示不删除  */
    SnapshotLifecycle int `json:"snapshotLifecycle"`

    /* 联系人信息 (Optional) */
    ContactInfo *disk.ContactInfo `json:"contactInfo"`

    /* 策略状态。1:启用 2:禁用  */
    Status int `json:"status"`
}

/*
 * param regionId: 地域ID (Required)
 * param policyId: 策略ID (Required)
 * param name: 策略名称 (Required)
 * param interval: 策略执行周期，单位:秒，不小于12小时 (Required)
 * param effectiveTime: 策略生效时间，格式`YYYY-MM-DDTHH:mm:ss+xx:xx`。如`2020-02-02T20:02:00+08:00` (Required)
 * param snapshotLifecycle: 快照保留时间，单位:秒，0:表示不删除 (Required)
 * param status: 策略状态。1:启用 2:禁用 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewUpdateSnapshotPolicyRequest(
    regionId string,
    policyId string,
    name string,
    interval int,
    effectiveTime string,
    snapshotLifecycle int,
    status int,
) *UpdateSnapshotPolicyRequest {

	return &UpdateSnapshotPolicyRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/snapshotPolicy/{policyId}",
			Method:  "PATCH",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        PolicyId: policyId,
        Name: name,
        Interval: interval,
        EffectiveTime: effectiveTime,
        SnapshotLifecycle: snapshotLifecycle,
        Status: status,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param policyId: 策略ID (Required)
 * param name: 策略名称 (Required)
 * param interval: 策略执行周期，单位:秒，不小于12小时 (Required)
 * param effectiveTime: 策略生效时间，格式`YYYY-MM-DDTHH:mm:ss+xx:xx`。如`2020-02-02T20:02:00+08:00` (Required)
 * param snapshotLifecycle: 快照保留时间，单位:秒，0:表示不删除 (Required)
 * param contactInfo: 联系人信息 (Optional)
 * param status: 策略状态。1:启用 2:禁用 (Required)
 */
func NewUpdateSnapshotPolicyRequestWithAllParams(
    regionId string,
    policyId string,
    name string,
    interval int,
    effectiveTime string,
    snapshotLifecycle int,
    contactInfo *disk.ContactInfo,
    status int,
) *UpdateSnapshotPolicyRequest {

    return &UpdateSnapshotPolicyRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/snapshotPolicy/{policyId}",
            Method:  "PATCH",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        PolicyId: policyId,
        Name: name,
        Interval: interval,
        EffectiveTime: effectiveTime,
        SnapshotLifecycle: snapshotLifecycle,
        ContactInfo: contactInfo,
        Status: status,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewUpdateSnapshotPolicyRequestWithoutParam() *UpdateSnapshotPolicyRequest {

    return &UpdateSnapshotPolicyRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/snapshotPolicy/{policyId}",
            Method:  "PATCH",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域ID(Required) */
func (r *UpdateSnapshotPolicyRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param policyId: 策略ID(Required) */
func (r *UpdateSnapshotPolicyRequest) SetPolicyId(policyId string) {
    r.PolicyId = policyId
}

/* param name: 策略名称(Required) */
func (r *UpdateSnapshotPolicyRequest) SetName(name string) {
    r.Name = name
}

/* param interval: 策略执行周期，单位:秒，不小于12小时(Required) */
func (r *UpdateSnapshotPolicyRequest) SetInterval(interval int) {
    r.Interval = interval
}

/* param effectiveTime: 策略生效时间，格式`YYYY-MM-DDTHH:mm:ss+xx:xx`。如`2020-02-02T20:02:00+08:00`(Required) */
func (r *UpdateSnapshotPolicyRequest) SetEffectiveTime(effectiveTime string) {
    r.EffectiveTime = effectiveTime
}

/* param snapshotLifecycle: 快照保留时间，单位:秒，0:表示不删除(Required) */
func (r *UpdateSnapshotPolicyRequest) SetSnapshotLifecycle(snapshotLifecycle int) {
    r.SnapshotLifecycle = snapshotLifecycle
}

/* param contactInfo: 联系人信息(Optional) */
func (r *UpdateSnapshotPolicyRequest) SetContactInfo(contactInfo *disk.ContactInfo) {
    r.ContactInfo = contactInfo
}

/* param status: 策略状态。1:启用 2:禁用(Required) */
func (r *UpdateSnapshotPolicyRequest) SetStatus(status int) {
    r.Status = status
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r UpdateSnapshotPolicyRequest) GetRegionId() string {
    return r.RegionId
}

type UpdateSnapshotPolicyResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result UpdateSnapshotPolicyResult `json:"result"`
}

type UpdateSnapshotPolicyResult struct {
    Id string `json:"id"`
    Name string `json:"name"`
    Pin string `json:"pin"`
    Interval int `json:"interval"`
    EffectiveTime string `json:"effectiveTime"`
    LastTriggerTime string `json:"lastTriggerTime"`
    NextTriggerTime string `json:"nextTriggerTime"`
    SnapshotLifecycle int `json:"snapshotLifecycle"`
    ContactInfo disk.ContactInfo `json:"contactInfo"`
    CreateTime string `json:"createTime"`
    UpdateTime string `json:"updateTime"`
    Status int `json:"status"`
    DiskCount int `json:"diskCount"`
}