// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type DeleteAlarmsRequest struct {

    core.JDCloudRequest

    /* 规则id  */
    AlarmId string `json:"alarmId"`
}

/*
 * param alarmId: 规则id (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDeleteAlarmsRequest(
    alarmId string,
) *DeleteAlarmsRequest {

	return &DeleteAlarmsRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/groupAlarms/{alarmId}",
			Method:  "DELETE",
			Header:  nil,
			Version: "v2",
		},
        AlarmId: alarmId,
	}
}

/*
 * param alarmId: 规则id (Required)
 */
func NewDeleteAlarmsRequestWithAllParams(
    alarmId string,
) *DeleteAlarmsRequest {

    return &DeleteAlarmsRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/groupAlarms/{alarmId}",
            Method:  "DELETE",
            Header:  nil,
            Version: "v2",
        },
        AlarmId: alarmId,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDeleteAlarmsRequestWithoutParam() *DeleteAlarmsRequest {

    return &DeleteAlarmsRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/groupAlarms/{alarmId}",
            Method:  "DELETE",
            Header:  nil,
            Version: "v2",
        },
    }
}

/* param alarmId: 规则id(Required) */
func (r *DeleteAlarmsRequest) SetAlarmId(alarmId string) {
    r.AlarmId = alarmId
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DeleteAlarmsRequest) GetRegionId() string {
    return ""
}

type DeleteAlarmsResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DeleteAlarmsResult `json:"result"`
}

type DeleteAlarmsResult struct {
    Success bool `json:"success"`
}