// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    monitor "github.com/jdcloud-api/jdcloud-sdk-go/services/monitor/models"
)

type DescribeAlarmContactsRequest struct {

    core.JDCloudRequest

    /* 规则id  */
    AlarmId string `json:"alarmId"`

    /* 当前所在页，默认为1 (Optional) */
    PageNumber *int `json:"pageNumber"`

    /* 页面大小，默认为20；取值范围[1, 100] (Optional) */
    PageSize *int `json:"pageSize"`

    /* 联系人类型。0,联系人分组; 1,联系人 (Optional) */
    ReferenceType *int `json:"referenceType"`
}

/*
 * param alarmId: 规则id (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDescribeAlarmContactsRequest(
    alarmId string,
) *DescribeAlarmContactsRequest {

	return &DescribeAlarmContactsRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/groupAlarms/{alarmId}/contacts",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
        AlarmId: alarmId,
	}
}

/*
 * param alarmId: 规则id (Required)
 * param pageNumber: 当前所在页，默认为1 (Optional)
 * param pageSize: 页面大小，默认为20；取值范围[1, 100] (Optional)
 * param referenceType: 联系人类型。0,联系人分组; 1,联系人 (Optional)
 */
func NewDescribeAlarmContactsRequestWithAllParams(
    alarmId string,
    pageNumber *int,
    pageSize *int,
    referenceType *int,
) *DescribeAlarmContactsRequest {

    return &DescribeAlarmContactsRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/groupAlarms/{alarmId}/contacts",
            Method:  "GET",
            Header:  nil,
            Version: "v2",
        },
        AlarmId: alarmId,
        PageNumber: pageNumber,
        PageSize: pageSize,
        ReferenceType: referenceType,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDescribeAlarmContactsRequestWithoutParam() *DescribeAlarmContactsRequest {

    return &DescribeAlarmContactsRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/groupAlarms/{alarmId}/contacts",
            Method:  "GET",
            Header:  nil,
            Version: "v2",
        },
    }
}

/* param alarmId: 规则id(Required) */
func (r *DescribeAlarmContactsRequest) SetAlarmId(alarmId string) {
    r.AlarmId = alarmId
}

/* param pageNumber: 当前所在页，默认为1(Optional) */
func (r *DescribeAlarmContactsRequest) SetPageNumber(pageNumber int) {
    r.PageNumber = &pageNumber
}

/* param pageSize: 页面大小，默认为20；取值范围[1, 100](Optional) */
func (r *DescribeAlarmContactsRequest) SetPageSize(pageSize int) {
    r.PageSize = &pageSize
}

/* param referenceType: 联系人类型。0,联系人分组; 1,联系人(Optional) */
func (r *DescribeAlarmContactsRequest) SetReferenceType(referenceType int) {
    r.ReferenceType = &referenceType
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DescribeAlarmContactsRequest) GetRegionId() string {
    return ""
}

type DescribeAlarmContactsResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DescribeAlarmContactsResult `json:"result"`
}

type DescribeAlarmContactsResult struct {
    ContactsList []monitor.DescribedNoticeContacts `json:"contactsList"`
    Total int64 `json:"total"`
}