// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    monitor "github.com/jdcloud-api/jdcloud-sdk-go/services/monitor/models"
)

type DescribeMetricsRequest struct {

    core.JDCloudRequest

    /* 资源的类型，取值vm, lb, ip, database 等。<a href="https://docs.jdcloud.com/cn/monitoring/api/describeservices?content=API&SOP=JDCloud">describeServices</a>：查询己接入云监控的产品线列表  */
    ServiceCode string `json:"serviceCode"`

    /*  (Optional) */
    Dimension *string `json:"dimension"`

    /* metric的类型，取值0(控制台展示)、1(内部使用，控制台不展示)、2(所有).默认取0 (Optional) */
    Type *int `json:"type"`
}

/*
 * param serviceCode: 资源的类型，取值vm, lb, ip, database 等。<a href="https://docs.jdcloud.com/cn/monitoring/api/describeservices?content=API&SOP=JDCloud">describeServices</a>：查询己接入云监控的产品线列表 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDescribeMetricsRequest(
    serviceCode string,
) *DescribeMetricsRequest {

	return &DescribeMetricsRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/metrics",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
        ServiceCode: serviceCode,
	}
}

/*
 * param serviceCode: 资源的类型，取值vm, lb, ip, database 等。<a href="https://docs.jdcloud.com/cn/monitoring/api/describeservices?content=API&SOP=JDCloud">describeServices</a>：查询己接入云监控的产品线列表 (Required)
 * param dimension:  (Optional)
 * param type_: metric的类型，取值0(控制台展示)、1(内部使用，控制台不展示)、2(所有).默认取0 (Optional)
 */
func NewDescribeMetricsRequestWithAllParams(
    serviceCode string,
    dimension *string,
    type_ *int,
) *DescribeMetricsRequest {

    return &DescribeMetricsRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/metrics",
            Method:  "GET",
            Header:  nil,
            Version: "v2",
        },
        ServiceCode: serviceCode,
        Dimension: dimension,
        Type: type_,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDescribeMetricsRequestWithoutParam() *DescribeMetricsRequest {

    return &DescribeMetricsRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/metrics",
            Method:  "GET",
            Header:  nil,
            Version: "v2",
        },
    }
}

/* param serviceCode: 资源的类型，取值vm, lb, ip, database 等。<a href="https://docs.jdcloud.com/cn/monitoring/api/describeservices?content=API&SOP=JDCloud">describeServices</a>：查询己接入云监控的产品线列表(Required) */
func (r *DescribeMetricsRequest) SetServiceCode(serviceCode string) {
    r.ServiceCode = serviceCode
}

/* param dimension: (Optional) */
func (r *DescribeMetricsRequest) SetDimension(dimension string) {
    r.Dimension = &dimension
}

/* param type_: metric的类型，取值0(控制台展示)、1(内部使用，控制台不展示)、2(所有).默认取0(Optional) */
func (r *DescribeMetricsRequest) SetType(type_ int) {
    r.Type = &type_
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DescribeMetricsRequest) GetRegionId() string {
    return ""
}

type DescribeMetricsResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DescribeMetricsResult `json:"result"`
}

type DescribeMetricsResult struct {
    Metrics []monitor.MetricDetail `json:"metrics"`
}