// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    monitor "github.com/jdcloud-api/jdcloud-sdk-go/services/monitor/models"
)

type DescribeProductsForAlarmRequest struct {

    core.JDCloudRequest

    /* 产品线，从产品线维度筛选 (Optional) */
    ServiceCode *string `json:"serviceCode"`

    /* 产品类型,从产品维度筛选、如redis2.8cluster\redis2.8instance。当serviceCode与product同时指定时，product优先级更高 (Optional) */
    Product *string `json:"product"`
}

/*
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDescribeProductsForAlarmRequest(
) *DescribeProductsForAlarmRequest {

	return &DescribeProductsForAlarmRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/groupAlarms:products",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
	}
}

/*
 * param serviceCode: 产品线，从产品线维度筛选 (Optional)
 * param product: 产品类型,从产品维度筛选、如redis2.8cluster\redis2.8instance。当serviceCode与product同时指定时，product优先级更高 (Optional)
 */
func NewDescribeProductsForAlarmRequestWithAllParams(
    serviceCode *string,
    product *string,
) *DescribeProductsForAlarmRequest {

    return &DescribeProductsForAlarmRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/groupAlarms:products",
            Method:  "GET",
            Header:  nil,
            Version: "v2",
        },
        ServiceCode: serviceCode,
        Product: product,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDescribeProductsForAlarmRequestWithoutParam() *DescribeProductsForAlarmRequest {

    return &DescribeProductsForAlarmRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/groupAlarms:products",
            Method:  "GET",
            Header:  nil,
            Version: "v2",
        },
    }
}

/* param serviceCode: 产品线，从产品线维度筛选(Optional) */
func (r *DescribeProductsForAlarmRequest) SetServiceCode(serviceCode string) {
    r.ServiceCode = &serviceCode
}

/* param product: 产品类型,从产品维度筛选、如redis2.8cluster\redis2.8instance。当serviceCode与product同时指定时，product优先级更高(Optional) */
func (r *DescribeProductsForAlarmRequest) SetProduct(product string) {
    r.Product = &product
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DescribeProductsForAlarmRequest) GetRegionId() string {
    return ""
}

type DescribeProductsForAlarmResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DescribeProductsForAlarmResult `json:"result"`
}

type DescribeProductsForAlarmResult struct {
    ProductList []monitor.Product `json:"productList"`
}