// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type EnableAlarmsRequest struct {

    core.JDCloudRequest

    /* 告警规则的ID列表  */
    AlarmIds []string `json:"alarmIds"`

    /* 启用:1,禁用0, (Optional) */
    State *int `json:"state"`
}

/*
 * param alarmIds: 告警规则的ID列表 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewEnableAlarmsRequest(
    alarmIds []string,
) *EnableAlarmsRequest {

	return &EnableAlarmsRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/groupAlarms:switch",
			Method:  "POST",
			Header:  nil,
			Version: "v2",
		},
        AlarmIds: alarmIds,
	}
}

/*
 * param alarmIds: 告警规则的ID列表 (Required)
 * param state: 启用:1,禁用0, (Optional)
 */
func NewEnableAlarmsRequestWithAllParams(
    alarmIds []string,
    state *int,
) *EnableAlarmsRequest {

    return &EnableAlarmsRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/groupAlarms:switch",
            Method:  "POST",
            Header:  nil,
            Version: "v2",
        },
        AlarmIds: alarmIds,
        State: state,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewEnableAlarmsRequestWithoutParam() *EnableAlarmsRequest {

    return &EnableAlarmsRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/groupAlarms:switch",
            Method:  "POST",
            Header:  nil,
            Version: "v2",
        },
    }
}

/* param alarmIds: 告警规则的ID列表(Required) */
func (r *EnableAlarmsRequest) SetAlarmIds(alarmIds []string) {
    r.AlarmIds = alarmIds
}

/* param state: 启用:1,禁用0,(Optional) */
func (r *EnableAlarmsRequest) SetState(state int) {
    r.State = &state
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r EnableAlarmsRequest) GetRegionId() string {
    return ""
}

type EnableAlarmsResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result EnableAlarmsResult `json:"result"`
}

type EnableAlarmsResult struct {
    Success bool `json:"success"`
}