// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    monitor "github.com/jdcloud-api/jdcloud-sdk-go/services/monitor/models"
)

type UpdateAlarmRequest struct {

    core.JDCloudRequest

    /* 规则id  */
    AlarmId string `json:"alarmId"`

    /* 弹性伸缩组Id。注：仅ag\asg产品线内部使用 (Optional) */
    AutoScalingPolicyId *string `json:"autoScalingPolicyId"`

    /* 告警通知联系人 (Optional) */
    BaseContact []monitor.BaseContact `json:"baseContact"`

    /* 数据所有者，1云监控控制台; 2云鼎。默认为1 (Optional) */
    DataOwner *int64 `json:"dataOwner"`

    /* 资源维度，可用的维度请使用 describeProductsForAlarm接口查询 (Optional) */
    Dimension *string `json:"dimension"`

    /* 是否启用, 1表示启用规则，0表示禁用规则，默认为1 (Optional) */
    Enabled *int64 `json:"enabled"`

    /* url回调设置数组 (Optional) */
    MultiWebHook []monitor.WebHookOption `json:"multiWebHook"`

    /* 通知策略 (Optional) */
    NoticeOption []monitor.NoticeOption `json:"noticeOption"`

    /* 资源类型, 可用的资源类型列表请使用 describeProductsForAlarm接口查询。  */
    Product string `json:"product"`

    /*   */
    ResourceOption *monitor.ResourceOption `json:"resourceOption"`

    /* 规则名称，规则名称，最大长度42个字符，只允许中英文、数字、''-''和"_"  */
    RuleName string `json:"ruleName"`

    /*   */
    RuleOption *monitor.RuleOption `json:"ruleOption"`

    /* 规则类型, 默认为resourceMonitor (Optional) */
    RuleType *string `json:"ruleType"`

    /* 资源维度，指定监控数据实例的维度标签,如resourceId=id。(请确认资源的监控数据带有该标签，否则规则会报数据不足) (Optional) */
    Tags *interface{} `json:"tags"`

    /*  (Optional) */
    WebHookOption *monitor.WebHookOption `json:"webHookOption"`
}

/*
 * param alarmId: 规则id (Required)
 * param product: 资源类型, 可用的资源类型列表请使用 describeProductsForAlarm接口查询。 (Required)
 * param resourceOption:  (Required)
 * param ruleName: 规则名称，规则名称，最大长度42个字符，只允许中英文、数字、''-''和"_" (Required)
 * param ruleOption:  (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewUpdateAlarmRequest(
    alarmId string,
    product string,
    resourceOption *monitor.ResourceOption,
    ruleName string,
    ruleOption *monitor.RuleOption,
) *UpdateAlarmRequest {

	return &UpdateAlarmRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/groupAlarms/{alarmId}",
			Method:  "PUT",
			Header:  nil,
			Version: "v2",
		},
        AlarmId: alarmId,
        Product: product,
        ResourceOption: resourceOption,
        RuleName: ruleName,
        RuleOption: ruleOption,
	}
}

/*
 * param alarmId: 规则id (Required)
 * param autoScalingPolicyId: 弹性伸缩组Id。注：仅ag\asg产品线内部使用 (Optional)
 * param baseContact: 告警通知联系人 (Optional)
 * param dataOwner: 数据所有者，1云监控控制台; 2云鼎。默认为1 (Optional)
 * param dimension: 资源维度，可用的维度请使用 describeProductsForAlarm接口查询 (Optional)
 * param enabled: 是否启用, 1表示启用规则，0表示禁用规则，默认为1 (Optional)
 * param multiWebHook: url回调设置数组 (Optional)
 * param noticeOption: 通知策略 (Optional)
 * param product: 资源类型, 可用的资源类型列表请使用 describeProductsForAlarm接口查询。 (Required)
 * param resourceOption:  (Required)
 * param ruleName: 规则名称，规则名称，最大长度42个字符，只允许中英文、数字、''-''和"_" (Required)
 * param ruleOption:  (Required)
 * param ruleType: 规则类型, 默认为resourceMonitor (Optional)
 * param tags: 资源维度，指定监控数据实例的维度标签,如resourceId=id。(请确认资源的监控数据带有该标签，否则规则会报数据不足) (Optional)
 * param webHookOption:  (Optional)
 */
func NewUpdateAlarmRequestWithAllParams(
    alarmId string,
    autoScalingPolicyId *string,
    baseContact []monitor.BaseContact,
    dataOwner *int64,
    dimension *string,
    enabled *int64,
    multiWebHook []monitor.WebHookOption,
    noticeOption []monitor.NoticeOption,
    product string,
    resourceOption *monitor.ResourceOption,
    ruleName string,
    ruleOption *monitor.RuleOption,
    ruleType *string,
    tags *interface{},
    webHookOption *monitor.WebHookOption,
) *UpdateAlarmRequest {

    return &UpdateAlarmRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/groupAlarms/{alarmId}",
            Method:  "PUT",
            Header:  nil,
            Version: "v2",
        },
        AlarmId: alarmId,
        AutoScalingPolicyId: autoScalingPolicyId,
        BaseContact: baseContact,
        DataOwner: dataOwner,
        Dimension: dimension,
        Enabled: enabled,
        MultiWebHook: multiWebHook,
        NoticeOption: noticeOption,
        Product: product,
        ResourceOption: resourceOption,
        RuleName: ruleName,
        RuleOption: ruleOption,
        RuleType: ruleType,
        Tags: tags,
        WebHookOption: webHookOption,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewUpdateAlarmRequestWithoutParam() *UpdateAlarmRequest {

    return &UpdateAlarmRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/groupAlarms/{alarmId}",
            Method:  "PUT",
            Header:  nil,
            Version: "v2",
        },
    }
}

/* param alarmId: 规则id(Required) */
func (r *UpdateAlarmRequest) SetAlarmId(alarmId string) {
    r.AlarmId = alarmId
}

/* param autoScalingPolicyId: 弹性伸缩组Id。注：仅ag\asg产品线内部使用(Optional) */
func (r *UpdateAlarmRequest) SetAutoScalingPolicyId(autoScalingPolicyId string) {
    r.AutoScalingPolicyId = &autoScalingPolicyId
}

/* param baseContact: 告警通知联系人(Optional) */
func (r *UpdateAlarmRequest) SetBaseContact(baseContact []monitor.BaseContact) {
    r.BaseContact = baseContact
}

/* param dataOwner: 数据所有者，1云监控控制台; 2云鼎。默认为1(Optional) */
func (r *UpdateAlarmRequest) SetDataOwner(dataOwner int64) {
    r.DataOwner = &dataOwner
}

/* param dimension: 资源维度，可用的维度请使用 describeProductsForAlarm接口查询(Optional) */
func (r *UpdateAlarmRequest) SetDimension(dimension string) {
    r.Dimension = &dimension
}

/* param enabled: 是否启用, 1表示启用规则，0表示禁用规则，默认为1(Optional) */
func (r *UpdateAlarmRequest) SetEnabled(enabled int64) {
    r.Enabled = &enabled
}

/* param multiWebHook: url回调设置数组(Optional) */
func (r *UpdateAlarmRequest) SetMultiWebHook(multiWebHook []monitor.WebHookOption) {
    r.MultiWebHook = multiWebHook
}

/* param noticeOption: 通知策略(Optional) */
func (r *UpdateAlarmRequest) SetNoticeOption(noticeOption []monitor.NoticeOption) {
    r.NoticeOption = noticeOption
}

/* param product: 资源类型, 可用的资源类型列表请使用 describeProductsForAlarm接口查询。(Required) */
func (r *UpdateAlarmRequest) SetProduct(product string) {
    r.Product = product
}

/* param resourceOption: (Required) */
func (r *UpdateAlarmRequest) SetResourceOption(resourceOption *monitor.ResourceOption) {
    r.ResourceOption = resourceOption
}

/* param ruleName: 规则名称，规则名称，最大长度42个字符，只允许中英文、数字、''-''和"_"(Required) */
func (r *UpdateAlarmRequest) SetRuleName(ruleName string) {
    r.RuleName = ruleName
}

/* param ruleOption: (Required) */
func (r *UpdateAlarmRequest) SetRuleOption(ruleOption *monitor.RuleOption) {
    r.RuleOption = ruleOption
}

/* param ruleType: 规则类型, 默认为resourceMonitor(Optional) */
func (r *UpdateAlarmRequest) SetRuleType(ruleType string) {
    r.RuleType = &ruleType
}

/* param tags: 资源维度，指定监控数据实例的维度标签,如resourceId=id。(请确认资源的监控数据带有该标签，否则规则会报数据不足)(Optional) */
func (r *UpdateAlarmRequest) SetTags(tags interface{}) {
    r.Tags = &tags
}

/* param webHookOption: (Optional) */
func (r *UpdateAlarmRequest) SetWebHookOption(webHookOption *monitor.WebHookOption) {
    r.WebHookOption = webHookOption
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r UpdateAlarmRequest) GetRegionId() string {
    return ""
}

type UpdateAlarmResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result UpdateAlarmResult `json:"result"`
}

type UpdateAlarmResult struct {
    AlarmId string `json:"alarmId"`
    RuleIds []int64 `json:"ruleIds"`
    Success bool `json:"success"`
}