// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type AlterTableWithOnlineDDLRequest struct {

    core.JDCloudRequest

    /* 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)  */
    RegionId string `json:"regionId"`

    /* RDS 实例ID，唯一标识一个RDS实例  */
    InstanceId string `json:"instanceId"`

    /* DDL命令修改的库名  */
    Database string `json:"database"`

    /* DDL命令修改的表名  */
    Table string `json:"table"`

    /* 需要执行的的DDL命令  */
    Command string `json:"command"`
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param database: DDL命令修改的库名 (Required)
 * param table: DDL命令修改的表名 (Required)
 * param command: 需要执行的的DDL命令 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewAlterTableWithOnlineDDLRequest(
    regionId string,
    instanceId string,
    database string,
    table string,
    command string,
) *AlterTableWithOnlineDDLRequest {

	return &AlterTableWithOnlineDDLRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/instances/{instanceId}:alterTableWithOnlineDDL",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        InstanceId: instanceId,
        Database: database,
        Table: table,
        Command: command,
	}
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param database: DDL命令修改的库名 (Required)
 * param table: DDL命令修改的表名 (Required)
 * param command: 需要执行的的DDL命令 (Required)
 */
func NewAlterTableWithOnlineDDLRequestWithAllParams(
    regionId string,
    instanceId string,
    database string,
    table string,
    command string,
) *AlterTableWithOnlineDDLRequest {

    return &AlterTableWithOnlineDDLRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}:alterTableWithOnlineDDL",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        InstanceId: instanceId,
        Database: database,
        Table: table,
        Command: command,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewAlterTableWithOnlineDDLRequestWithoutParam() *AlterTableWithOnlineDDLRequest {

    return &AlterTableWithOnlineDDLRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}:alterTableWithOnlineDDL",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)(Required) */
func (r *AlterTableWithOnlineDDLRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param instanceId: RDS 实例ID，唯一标识一个RDS实例(Required) */
func (r *AlterTableWithOnlineDDLRequest) SetInstanceId(instanceId string) {
    r.InstanceId = instanceId
}

/* param database: DDL命令修改的库名(Required) */
func (r *AlterTableWithOnlineDDLRequest) SetDatabase(database string) {
    r.Database = database
}

/* param table: DDL命令修改的表名(Required) */
func (r *AlterTableWithOnlineDDLRequest) SetTable(table string) {
    r.Table = table
}

/* param command: 需要执行的的DDL命令(Required) */
func (r *AlterTableWithOnlineDDLRequest) SetCommand(command string) {
    r.Command = command
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r AlterTableWithOnlineDDLRequest) GetRegionId() string {
    return r.RegionId
}

type AlterTableWithOnlineDDLResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result AlterTableWithOnlineDDLResult `json:"result"`
}

type AlterTableWithOnlineDDLResult struct {
}