// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type CopyParameterGroupRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* 参数组ID  */
    ParameterGroupId string `json:"parameterGroupId"`

    /* 参数组的名字  */
    ParameterGroupName string `json:"parameterGroupName"`

    /* 参数组的描述 (Optional) */
    Description *string `json:"description"`
}

/*
 * param regionId: Region ID (Required)
 * param parameterGroupId: 参数组ID (Required)
 * param parameterGroupName: 参数组的名字 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewCopyParameterGroupRequest(
    regionId string,
    parameterGroupId string,
    parameterGroupName string,
) *CopyParameterGroupRequest {

	return &CopyParameterGroupRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/parameterGroups:copyParameterGroup",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        ParameterGroupId: parameterGroupId,
        ParameterGroupName: parameterGroupName,
	}
}

/*
 * param regionId: Region ID (Required)
 * param parameterGroupId: 参数组ID (Required)
 * param parameterGroupName: 参数组的名字 (Required)
 * param description: 参数组的描述 (Optional)
 */
func NewCopyParameterGroupRequestWithAllParams(
    regionId string,
    parameterGroupId string,
    parameterGroupName string,
    description *string,
) *CopyParameterGroupRequest {

    return &CopyParameterGroupRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/parameterGroups:copyParameterGroup",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        ParameterGroupId: parameterGroupId,
        ParameterGroupName: parameterGroupName,
        Description: description,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewCopyParameterGroupRequestWithoutParam() *CopyParameterGroupRequest {

    return &CopyParameterGroupRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/parameterGroups:copyParameterGroup",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *CopyParameterGroupRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param parameterGroupId: 参数组ID(Required) */
func (r *CopyParameterGroupRequest) SetParameterGroupId(parameterGroupId string) {
    r.ParameterGroupId = parameterGroupId
}

/* param parameterGroupName: 参数组的名字(Required) */
func (r *CopyParameterGroupRequest) SetParameterGroupName(parameterGroupName string) {
    r.ParameterGroupName = parameterGroupName
}

/* param description: 参数组的描述(Optional) */
func (r *CopyParameterGroupRequest) SetDescription(description string) {
    r.Description = &description
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r CopyParameterGroupRequest) GetRegionId() string {
    return r.RegionId
}

type CopyParameterGroupResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result CopyParameterGroupResult `json:"result"`
}

type CopyParameterGroupResult struct {
    ParameterGroupId string `json:"parameterGroupId"`
}